/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.gcf;

import edu.sc.seis.seisFile.gcf.GCFBlock;
import edu.sc.seis.seisFile.gcf.GCFFormatException;
import edu.sc.seis.seisFile.gcf.SerialTransportLayer;
import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;

public class GCFSerialOutput {
    int seqNum = 0;
    InputStream in;
    DataOutputStream out;
    String serial = "/dev/ttyS0";

    public GCFSerialOutput() throws Exception {
        this.connect(this.serial);
    }

    public void writeGCF(Date startTime, int[] data) throws IOException {
        boolean isSerial = true;
        ArrayList<String> orientations = new ArrayList<String>();
        orientations.add("Z");
        orientations.add("N");
        orientations.add("E");
        for (String orient : orientations) {
            SerialTransportLayer serialLayer;
            GCFBlock block = GCFBlock.mockGCF(startTime, data, isSerial);
            block.header.streamId = block.header.streamId.substring(0, 4) + orient + block.header.streamId.charAt(5);
            try {
                serialLayer = new SerialTransportLayer(this.seqNum, block, isSerial);
            }
            catch (GCFFormatException e) {
                throw new RuntimeException("Should not happen, isSerial is " + isSerial);
            }
            serialLayer.write(this.out);
            this.seqNum = (this.seqNum + 1) % 256;
        }
    }

    void connect(String portName) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)portName);
        if (portIdentifier.isCurrentlyOwned()) {
            System.out.println("Error: Port is currently in use");
        } else {
            CommPort commPort = portIdentifier.open(this.getClass().getName(), 2000);
            if (commPort instanceof SerialPort) {
                SerialPort serialPort = (SerialPort)commPort;
                serialPort.setSerialPortParams(19200, 8, 1, 0);
                this.in = serialPort.getInputStream();
                this.out = new DataOutputStream(serialPort.getOutputStream());
            } else {
                System.out.println("Error: Only serial ports are handled by this example.");
            }
        }
    }

    public static void main(String[] args) throws Exception {
        GCFSerialOutput fake = new GCFSerialOutput();
        int[] fakeData = new int[200];
        Date roundNow = new Date(new Date().getTime() / 1000L * 1000L);
        for (int i = 0; i < fakeData.length; ++i) {
            fakeData[i] = 10 * i;
            if (i % 20 <= 10) continue;
            int n = i;
            fakeData[n] = fakeData[n] * -1;
        }
        while (true) {
            System.out.println("Send " + roundNow);
            fake.writeGCF(roundNow, fakeData);
            roundNow = new Date(roundNow.getTime() + 2000L);
            Thread.sleep(2000L);
        }
    }
}

