/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.FloatNoUnitType;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import edu.sc.seis.seisFile.sac.Complex;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public abstract class PoleZero
extends Complex {
    FloatNoUnitType realWithError;
    FloatNoUnitType imaginaryWithError;

    public PoleZero(XMLEventReader reader, String elementName) throws XMLStreamException, StationXMLException {
        super(0.0, 0.0);
        StartElement startE = StaxUtil.expectStartElement(elementName, reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("Real")) {
                    this.realWithError = new FloatNoUnitType(reader, "Real");
                    this.real = this.realWithError.value;
                    continue;
                }
                if (elName.equals("Imaginary")) {
                    this.imaginaryWithError = new FloatNoUnitType(reader, "Imaginary");
                    this.imaginary = this.imaginaryWithError.value;
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            e = reader.nextEvent();
        }
    }
}

