/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws;

import edu.sc.seis.seisFile.client.AbstractClient;
import edu.sc.seis.seisFile.fdsnws.FDSNWSException;
import edu.sc.seis.seisFile.fdsnws.TimeQueryLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stax.StAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.codehaus.stax2.XMLEventReader2;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidationSchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class AbstractFDSNQuerier {
    static XMLValidationSchemaFactory sfactory;
    static HashMap<URL, XMLValidationSchema> schemaCache;
    String userAgent = AbstractClient.DEFAULT_USER_AGENT;
    String acceptHeader = "application/xml";
    int responseCode;
    boolean error;
    String errorMessage;
    boolean empty;
    XMLEventReader reader;
    InputStream inputStream;
    CloseableHttpResponse response;
    protected URI connectionUri;
    protected int connectTimeout = DEFAULT_CONNECT_TIMEOUT;
    protected int readTimeout = DEFAULT_READ_TIMEOUT;
    protected boolean validate = false;
    public static int DEFAULT_CONNECT_TIMEOUT;
    public static int DEFAULT_READ_TIMEOUT;
    private static final Logger logger;

    public abstract URI formURI() throws URISyntaxException;

    public abstract URL getSchemaURL();

    public void connect() throws URISyntaxException, FDSNWSException {
        this.connectionUri = this.formURI();
        try {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.getConnectTimeout()).setConnectionRequestTimeout(this.getConnectTimeout()).setSocketTimeout(this.getReadTimeout()).setRedirectsEnabled(true).build();
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
            HttpGet request = new HttpGet(this.connectionUri);
            request.setHeader("User-Agent", this.getUserAgent());
            request.setHeader("Accept", this.getAcceptHeader());
            request.setHeader("Accept-Encoding", "gzip, deflate");
            TimeQueryLog.add(this.connectionUri);
            this.response = httpClient.execute((HttpUriRequest)request);
            this.processConnection(this.response);
        }
        catch (IOException e) {
            throw new FDSNWSException("Problem with connection", e, this.connectionUri);
        }
        catch (RuntimeException e) {
            throw new FDSNWSException("Problem with connection", e, this.connectionUri);
        }
    }

    protected void processConnection(CloseableHttpResponse response) throws IOException {
        this.responseCode = response.getStatusLine().getStatusCode();
        if (this.responseCode == 204) {
            this.empty = true;
            response.close();
            response = null;
            return;
        }
        if (this.responseCode != 200) {
            this.error = true;
            this.errorMessage = "Code: " + this.responseCode + " " + AbstractFDSNQuerier.extractErrorMessage((HttpResponse)response);
            response.close();
            response = null;
            return;
        }
        HttpEntity entity = response.getEntity();
        this.inputStream = "gzip".equals(entity.getContentEncoding()) ? new GZIPInputStream(new BufferedInputStream(entity.getContent(), 65536)) : new BufferedInputStream(entity.getContent(), 65536);
    }

    public static void validate(XMLStreamReader reader, URL schemaURL) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(schemaURL);
        Validator validator = schema.newValidator();
        validator.validate(new StAXSource(reader), null);
    }

    public void outputRaw(OutputStream out) throws MalformedURLException, IOException, URISyntaxException, FDSNWSException {
        this.connect();
        this.outputRaw(this.getInputStream(), out);
    }

    public void outputRaw(InputStream in, OutputStream out) throws IOException {
        BufferedInputStream bufIn = new BufferedInputStream(in);
        BufferedOutputStream bufOut = new BufferedOutputStream(out);
        byte[] buf = new byte[1024];
        int numRead = bufIn.read(buf);
        while (numRead != -1) {
            bufOut.write(buf, 0, numRead);
            numRead = bufIn.read(buf);
        }
        bufIn.close();
        bufOut.flush();
    }

    public String getRawXML() throws IOException {
        StringWriter out = new StringWriter();
        BufferedReader in = new BufferedReader(new InputStreamReader(this.getInputStream()));
        char[] buf = new char[1024];
        int numRead = in.read(buf);
        while (numRead != -1) {
            out.write(buf, 0, numRead);
        }
        in.close();
        out.close();
        return out.toString();
    }

    public boolean isError() {
        this.checkConnectionInitiated();
        return this.error;
    }

    public String getErrorMessage() {
        this.checkConnectionInitiated();
        return this.errorMessage;
    }

    public boolean isEmpty() {
        this.checkConnectionInitiated();
        return this.empty;
    }

    public InputStream getInputStream() {
        this.checkConnectionInitiated();
        return this.inputStream;
    }

    public URI getConnectionUri() {
        return this.connectionUri;
    }

    public boolean isConnectionInitiated() {
        return this.response != null;
    }

    public void checkConnectionInitiated() {
        if (!this.isConnectionInitiated()) {
            throw new RuntimeException("Not connected yet");
        }
    }

    public XMLEventReader getReader() throws XMLStreamException, URISyntaxException {
        if (this.reader == null) {
            XMLInputFactory2 factory = (XMLInputFactory2)XMLInputFactory.newInstance();
            XMLStreamReader2 sr = (XMLStreamReader2)factory.createXMLStreamReader(this.getConnectionUri().toString(), this.getInputStream());
            if (this.isValidate()) {
                try {
                    XMLValidationSchema schema = schemaCache.get(this.getSchemaURL());
                    if (schema == null) {
                        if (sfactory == null) {
                            sfactory = XMLValidationSchemaFactory.newInstance((String)"http://www.w3.org/2001/XMLSchema");
                        }
                        schema = sfactory.createSchema(this.getSchemaURL());
                        schemaCache.put(this.getSchemaURL(), schema);
                    }
                    sr.validateAgainst(schema);
                }
                catch (XMLStreamException e) {
                    throw new RuntimeException("should not happen, can't load schema in jar: " + this.getSchemaURL(), e);
                }
            }
            this.reader = (XMLEventReader2)factory.createXMLEventReader((XMLStreamReader)sr);
        }
        return this.reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractErrorMessage(HttpResponse response) {
        String out = "";
        BufferedReader errReader = null;
        try {
            HttpEntity entity = response.getEntity();
            InputStream inError = entity.getContent();
            if (inError == null) {
                out = "<Empty Error Message From Server>";
            } else {
                String line;
                int lineNum;
                if ("gzip".equals(entity.getContentEncoding())) {
                    inError = new GZIPInputStream(inError);
                }
                int maxLines = 1000;
                errReader = new BufferedReader(new InputStreamReader(inError));
                for (lineNum = 0; (line = errReader.readLine()) != null && lineNum < maxLines; ++lineNum) {
                    out = out + line + "\n";
                }
                if (lineNum == maxLines) {
                    out = out + "...output truncated at " + maxLines + " lines.";
                }
            }
        }
        catch (IOException e) {
            out = out + "\nException reading error stream: " + e.toString();
        }
        finally {
            if (errReader != null) {
                try {
                    errReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return out;
    }

    public String getAcceptHeader() {
        return this.acceptHeader;
    }

    public void setAcceptHeader(String acceptHeader) {
        this.acceptHeader = acceptHeader;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setConnectTimeout(int milliseconds) {
        this.connectTimeout = milliseconds;
    }

    public void setReadTimeout(int milliseconds) {
        this.readTimeout = milliseconds;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public static Throwable extractRootCause(Throwable t) {
        if (t.getCause() == null) {
            return t;
        }
        return AbstractFDSNQuerier.extractRootCause(t.getCause());
    }

    void handleXmlStreamException(XMLStreamException e) throws FDSNWSException {
        String bufferedText = "";
        try {
            int avail = this.getInputStream().available();
            if (avail > 0) {
                byte[] b = new byte[avail];
                int numRead = this.getInputStream().read(b);
                bufferedText = new String(b, 0, numRead);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new FDSNWSException("Unable to load xml, text past error='" + bufferedText + "'", e, this.getConnectionUri());
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public void finalize() {
        this.close();
    }

    public void close() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                logger.warn("can't close inputstream: " + this.connectionUri, (Throwable)e);
            }
        }
        if (this.response != null) {
            try {
                this.response.close();
            }
            catch (IOException e) {
                logger.warn("can't close response", (Throwable)e);
            }
        }
    }

    static {
        schemaCache = new HashMap();
        DEFAULT_CONNECT_TIMEOUT = 10000;
        DEFAULT_READ_TIMEOUT = 60000;
        logger = LoggerFactory.getLogger(AbstractFDSNQuerier.class);
    }
}

