/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.earthworm;

import edu.iris.dmc.seedcodec.Codec;
import edu.iris.dmc.seedcodec.Steim1;
import edu.iris.dmc.seedcodec.Steim2;
import edu.iris.dmc.seedcodec.SteimException;
import edu.iris.dmc.seedcodec.SteimFrameBlock;
import edu.sc.seis.seisFile.QueryParams;
import edu.sc.seis.seisFile.mseed.Blockette1000;
import edu.sc.seis.seisFile.mseed.Btime;
import edu.sc.seis.seisFile.mseed.DataHeader;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.DataTooLargeException;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.Utility;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class TraceBuf2 {
    int pin;
    int numSamples;
    double startTime;
    double endTime;
    double sampleRate;
    String station;
    String network;
    String channel;
    String locId;
    String version;
    String dataType;
    short quality;
    short pad;
    short[] shortData;
    int[] intData;
    float[] floatData;
    double[] doubleData;
    public static final String LOC_NULL_STRING = "--";
    public static final int MAX_TRACEBUF_SIZE = 4096;
    public static final int AMPLIFIER_SATURATED = 1;
    public static final int DIGITIZER_CLIPPED = 2;
    public static final int SPIKES_DETECTED = 4;
    public static final int GLITCHES_DETECTED = 8;
    public static final int MISSING_DATA_PRESENT = 16;
    public static final int TELEMETRY_SYNCH_ERROR = 32;
    public static final int FILTER_CHARGING = 64;
    public static final int TIME_TAG_QUESTIONABLE = 128;
    public static final int HEADER_SIZE = 64;
    public static final String SUN_IEEE_SINGLE_PRECISION_REAL = "t4";
    public static final String SUN_IEEE_DOUBLE_PRECISION_REAL = "t8";
    public static final String SUN_IEEE_INTEGER = "s4";
    public static final String SUN_IEEE_SHORT_INTEGER = "s2";
    public static final String INTEL_IEEE_SINGLE_PRECISION_REAL = "f4";
    public static final String INTEL_IEEE_DOUBLE_PRECISION_REAL = "f8";
    public static final String INTEL_IEEE_INTEGER = "i4";
    public static final String INTEL_IEEE_SHORT_INTEGER = "i2";
    public static final String NORESS_GAIN_RANGED = "g2";
    public static final String TRACEBUF_VERSION = "20";
    public static final int MAX_NET_LEN = 9;
    public static final int MAX_STA_LEN = 7;
    public static final int MAX_LOC_LEN = 3;
    public static final int MAX_CHAN_LEN = 4;
    public static final short S_ZERO = 0;

    protected TraceBuf2() {
    }

    TraceBuf2(int pin, int numSamples, double startTime, double endTime, double sampleRate, String station, String network, String channel, String locId, String version, String dataType, short quality, short pad) {
        this.pin = pin;
        this.numSamples = numSamples;
        this.startTime = startTime;
        this.endTime = endTime;
        this.sampleRate = sampleRate;
        this.station = station;
        this.network = network;
        this.channel = channel;
        this.locId = locId;
        if (locId == null || "".equals(locId.trim())) {
            this.locId = LOC_NULL_STRING;
        }
        this.version = version;
        this.dataType = dataType;
        this.quality = quality;
        this.pad = pad;
        if (network.length() > 8) {
            throw new IllegalArgumentException("network cannot be longer than 8 chars: " + network.length() + " '" + network + "'");
        }
        if (station.length() > 6) {
            throw new IllegalArgumentException("station cannot be longer than 6 chars: " + station.length() + " '" + station + "'");
        }
        if (locId.length() > 2) {
            throw new IllegalArgumentException("locId cannot be longer than 2 chars: " + locId.length() + " '" + locId + "'");
        }
        if (channel.length() > 3) {
            throw new IllegalArgumentException("channel cannot be longer than 3 chars: " + channel.length() + " '" + channel + "'");
        }
    }

    public TraceBuf2(int pin, int numSamples, double startTime, double sampleRate, String station, String network, String channel, String locId, short[] data) {
        this(pin, numSamples, startTime, startTime + (double)(numSamples - 1) / sampleRate, sampleRate, station, network, channel, locId, TRACEBUF_VERSION, SUN_IEEE_SHORT_INTEGER, 0, 0);
        this.shortData = data;
    }

    public TraceBuf2(int pin, int numSamples, double startTime, double sampleRate, String station, String network, String channel, String locId, int[] intData) {
        this(pin, numSamples, startTime, startTime + (double)(numSamples - 1) / sampleRate, sampleRate, station, network, channel, locId, TRACEBUF_VERSION, SUN_IEEE_INTEGER, 0, 0);
        this.intData = intData;
    }

    public TraceBuf2(int pin, int numSamples, double startTime, double sampleRate, String station, String network, String channel, String locId, float[] data) {
        this(pin, numSamples, startTime, startTime + (double)(numSamples - 1) / sampleRate, sampleRate, station, network, channel, locId, TRACEBUF_VERSION, SUN_IEEE_SINGLE_PRECISION_REAL, 0, 0);
        this.floatData = data;
    }

    public TraceBuf2(int pin, int numSamples, double startTime, double sampleRate, String station, String network, String channel, String locId, double[] data) {
        this(pin, numSamples, startTime, startTime + (double)(numSamples - 1) / sampleRate, sampleRate, station, network, channel, locId, TRACEBUF_VERSION, SUN_IEEE_DOUBLE_PRECISION_REAL, 0, 0);
        this.doubleData = data;
    }

    public TraceBuf2(byte[] data) {
        this.parseHeaders(data);
        boolean swapBytes = TraceBuf2.isSwapBytes(this.dataType);
        int offset = 64;
        if (this.isShortData()) {
            this.shortData = new short[this.numSamples];
            for (int i = 0; i < this.shortData.length; ++i) {
                this.shortData[i] = Utility.bytesToShort(data[offset], data[offset + 1], swapBytes);
                offset += 2;
            }
            this.dataType = SUN_IEEE_SHORT_INTEGER;
        } else if (this.isIntData()) {
            this.intData = new int[this.numSamples];
            for (int i = 0; i < this.intData.length; ++i) {
                this.intData[i] = Utility.bytesToInt(data[offset], data[offset + 1], data[offset + 2], data[offset + 3], swapBytes);
                offset += 4;
            }
            this.dataType = SUN_IEEE_INTEGER;
        } else if (this.isFloatData()) {
            this.floatData = new float[this.numSamples];
            for (int i = 0; i < this.floatData.length; ++i) {
                this.floatData[i] = Utility.bytesToFloat(data[offset], data[offset + 1], data[offset + 2], data[offset + 3], swapBytes);
                offset += 4;
            }
            this.dataType = SUN_IEEE_SINGLE_PRECISION_REAL;
        } else if (this.isDoubleData()) {
            this.doubleData = new double[this.numSamples];
            for (int i = 0; i < this.doubleData.length; ++i) {
                this.doubleData[i] = Utility.bytesToDouble(data[offset], data[offset + 1], data[offset + 2], data[offset + 3], data[offset + 4], data[offset + 5], data[offset + 6], data[offset + 7], swapBytes);
                offset += 8;
            }
            this.dataType = SUN_IEEE_DOUBLE_PRECISION_REAL;
        } else {
            if (this.dataType.equals(NORESS_GAIN_RANGED)) {
                throw new RuntimeException("NORESS gain-ranged data type not supported: " + this.dataType);
            }
            throw new RuntimeException("Unknown data type: " + this.dataType);
        }
    }

    public static TraceBuf2 read(DataInput in) throws IOException {
        byte[] headBytes = new byte[64];
        in.readFully(headBytes);
        String dataType = TraceBuf2.extractDataType(headBytes);
        int tbDataSize = TraceBuf2.extractNumSamples(headBytes, TraceBuf2.isSwapBytes(dataType)) * TraceBuf2.getSampleSize(dataType);
        byte[] allBytes = new byte[64 + tbDataSize];
        System.arraycopy(headBytes, 0, allBytes, 0, headBytes.length);
        in.readFully(allBytes, headBytes.length, tbDataSize);
        TraceBuf2 tb = new TraceBuf2(allBytes);
        return tb;
    }

    void parseHeaders(byte[] data) {
        if (data.length < 64) {
            throw new IllegalArgumentException("header of TraceBuf is 64 bytes, but only given " + data.length);
        }
        this.dataType = TraceBuf2.extractDataType(data);
        boolean swapBytes = TraceBuf2.isSwapBytes(this.dataType);
        this.pin = Utility.bytesToInt(data, 0, swapBytes);
        this.numSamples = TraceBuf2.extractNumSamples(data, swapBytes);
        this.startTime = Utility.bytesToDouble(data, 8, swapBytes);
        this.endTime = Utility.bytesToDouble(data, 16, swapBytes);
        this.sampleRate = Utility.bytesToDouble(data, 24, swapBytes);
        this.station = Utility.extractNullTermString(data, 32, 7);
        this.network = Utility.extractNullTermString(data, 39, 9);
        this.channel = Utility.extractNullTermString(data, 48, 4);
        this.locId = Utility.extractNullTermString(data, 52, 3);
        if (this.locId == null || "".equals(this.locId.trim())) {
            this.locId = LOC_NULL_STRING;
        }
        this.version = Utility.extractString(data, 55, 2);
        this.quality = Utility.bytesToShort(data[60], data[61], swapBytes);
        this.pad = Utility.bytesToShort(data[62], data[63], swapBytes);
    }

    public static int extractNumSamples(byte[] data, boolean swapBytes) {
        return Utility.bytesToInt(data, 4, swapBytes);
    }

    public static String extractDataType(byte[] data) {
        return Utility.extractNullTermString(data, 57, 3);
    }

    public static boolean isSwapBytes(String dataType) {
        return dataType.equals(INTEL_IEEE_DOUBLE_PRECISION_REAL) || dataType.equals(INTEL_IEEE_INTEGER) || dataType.equals(INTEL_IEEE_SHORT_INTEGER) || dataType.equals(INTEL_IEEE_SINGLE_PRECISION_REAL);
    }

    public static int getSampleSize(String dataType) {
        if (TraceBuf2.isShortData(dataType)) {
            return 2;
        }
        if (TraceBuf2.isIntData(dataType) || TraceBuf2.isFloatData(dataType)) {
            return 4;
        }
        if (TraceBuf2.isDoubleData(dataType)) {
            return 8;
        }
        throw new RuntimeException("Unknown dataType: '" + dataType + "'");
    }

    public void write(DataOutputStream out) throws IOException {
        block5: {
            block7: {
                block6: {
                    block4: {
                        out.writeInt(this.pin);
                        out.writeInt(this.numSamples);
                        out.writeDouble(this.startTime);
                        out.writeDouble(this.endTime);
                        out.writeDouble(this.sampleRate);
                        Utility.writeNullTermString(this.station, 7, out);
                        Utility.writeNullTermString(this.network, 9, out);
                        Utility.writeNullTermString(this.channel, 4, out);
                        Utility.writeNullTermString(this.locId, 3, out);
                        Utility.writeNullTermString(this.version, 2, out);
                        Utility.writeNullTermString(this.dataType, 3, out);
                        out.writeShort(this.quality);
                        out.writeShort(this.pad);
                        if (!this.isShortData()) break block4;
                        for (int i = 0; i < this.shortData.length; ++i) {
                            out.writeShort(this.shortData[i]);
                        }
                        break block5;
                    }
                    if (!this.isIntData()) break block6;
                    for (int i = 0; i < this.intData.length; ++i) {
                        out.writeInt(this.intData[i]);
                    }
                    break block5;
                }
                if (!this.isFloatData()) break block7;
                for (int i = 0; i < this.floatData.length; ++i) {
                    out.writeFloat(this.floatData[i]);
                }
                break block5;
            }
            if (!this.isDoubleData()) break block5;
            for (int i = 0; i < this.doubleData.length; ++i) {
                out.writeDouble(this.doubleData[i]);
            }
        }
    }

    public List<TraceBuf2> split(int maxSize) {
        if (maxSize <= 0) {
            return Arrays.asList(this);
        }
        if (maxSize <= 64) {
            throw new IllegalArgumentException("maxSize cannot be smaller than header size (64) but was " + maxSize);
        }
        ArrayList<TraceBuf2> out = new ArrayList<TraceBuf2>();
        if (this.getSize() <= maxSize) {
            out.add(this);
        } else {
            int splitPoints;
            int maxSamplesPerTB = (maxSize - 64) / TraceBuf2.getSampleSize(this.getDataType());
            for (int curSample = 0; curSample < this.numSamples; curSample += splitPoints) {
                splitPoints = Math.min(maxSamplesPerTB, this.numSamples - curSample);
                if (splitPoints == maxSamplesPerTB) {
                    splitPoints = Math.min(maxSamplesPerTB, (this.numSamples - curSample + 1) / 2);
                }
                double splitStartTime = this.startTime + (double)curSample / this.sampleRate;
                double splitEndTime = this.startTime + (double)(curSample + splitPoints - 1) / this.sampleRate;
                System.out.println("start: " + splitStartTime % 1000.0 + "  end:" + splitEndTime % 1000.0);
                TraceBuf2 first = new TraceBuf2(this.pin, splitPoints, splitStartTime, splitEndTime, this.sampleRate, this.station, this.network, this.channel, this.locId, this.version, this.dataType, this.quality, this.pad);
                out.add(first);
                if (this.isShortData()) {
                    first.shortData = new short[splitPoints];
                    System.arraycopy(this.shortData, curSample, first.shortData, 0, splitPoints);
                    continue;
                }
                if (this.isIntData()) {
                    first.intData = new int[splitPoints];
                    System.arraycopy(this.intData, curSample, first.intData, 0, splitPoints);
                    continue;
                }
                if (this.isFloatData()) {
                    first.floatData = new float[splitPoints];
                    System.arraycopy(this.floatData, curSample, first.floatData, 0, splitPoints);
                    continue;
                }
                if (this.isDoubleData()) {
                    first.doubleData = new double[splitPoints];
                    System.arraycopy(this.doubleData, curSample, first.doubleData, 0, splitPoints);
                    continue;
                }
                throw new RuntimeException("Unknown data type: " + this.getDataType());
            }
        }
        return out;
    }

    public boolean isShortData() {
        return TraceBuf2.isShortData(this.dataType);
    }

    public boolean isIntData() {
        return TraceBuf2.isIntData(this.dataType);
    }

    public boolean isFloatData() {
        return TraceBuf2.isFloatData(this.dataType);
    }

    public boolean isDoubleData() {
        return TraceBuf2.isDoubleData(this.dataType);
    }

    public static boolean isShortData(String dataType) {
        return dataType.equals(INTEL_IEEE_SHORT_INTEGER) || dataType.equals(SUN_IEEE_SHORT_INTEGER);
    }

    public static boolean isIntData(String dataType) {
        return dataType.equals(INTEL_IEEE_INTEGER) || dataType.equals(SUN_IEEE_INTEGER);
    }

    public static boolean isFloatData(String dataType) {
        return dataType.equals(INTEL_IEEE_SINGLE_PRECISION_REAL) || dataType.equals(SUN_IEEE_SINGLE_PRECISION_REAL);
    }

    public static boolean isDoubleData(String dataType) {
        return dataType.equals(INTEL_IEEE_DOUBLE_PRECISION_REAL) || dataType.equals(SUN_IEEE_DOUBLE_PRECISION_REAL);
    }

    public int getPin() {
        return this.pin;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public double getPredictedNextStartTime() {
        return this.getStartTime() + (double)this.getNumSamples() / this.getSampleRate();
    }

    public Date getPredictedNextStartDate() {
        return new Date(Math.round(1000.0 * this.getPredictedNextStartTime()));
    }

    public Date getStartDate() {
        return new Date(Math.round(this.getStartTime() * 1000.0));
    }

    public Date getEndDate() {
        return new Date(Math.round(this.getEndTime() * 1000.0));
    }

    public double getSampleRate() {
        return this.sampleRate;
    }

    public String getStation() {
        return this.station;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getChannel() {
        return this.channel;
    }

    public String formatNSLCCodes() {
        return this.network + "." + this.station + "." + this.locId + "." + this.channel;
    }

    public String getLocId() {
        return this.locId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDataType() {
        return this.dataType;
    }

    public short getQuality() {
        return this.quality;
    }

    public short getPad() {
        return this.pad;
    }

    public short[] getShortData() {
        return this.shortData;
    }

    public int[] getIntData() {
        if (this.isIntData()) {
            return this.intData;
        }
        if (this.isShortData()) {
            int[] out = new int[this.shortData.length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = this.shortData[i];
            }
            return out;
        }
        return null;
    }

    public float[] getFloatData() {
        if (this.isFloatData()) {
            return this.floatData;
        }
        if (this.isIntData()) {
            float[] out = new float[this.intData.length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = this.intData[i];
            }
            return out;
        }
        if (this.isShortData()) {
            float[] out = new float[this.shortData.length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = this.shortData[i];
            }
            return out;
        }
        return null;
    }

    public double[] getDoubleData() {
        if (this.isDoubleData()) {
            return this.doubleData;
        }
        if (this.isFloatData()) {
            double[] out = new double[this.floatData.length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = this.floatData[i];
            }
            return out;
        }
        if (this.isIntData()) {
            double[] out = new double[this.intData.length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = this.intData[i];
            }
            return out;
        }
        if (this.isShortData()) {
            double[] out = new double[this.shortData.length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = this.shortData[i];
            }
            return out;
        }
        return null;
    }

    public byte getSeedEncoding() {
        if (this.dataType.equals(SUN_IEEE_INTEGER) || this.dataType.equals(INTEL_IEEE_INTEGER)) {
            return 3;
        }
        if (this.dataType.equals(SUN_IEEE_SHORT_INTEGER) || this.dataType.equals(INTEL_IEEE_SHORT_INTEGER)) {
            return 1;
        }
        if (this.dataType.equals(SUN_IEEE_SINGLE_PRECISION_REAL) || this.dataType.equals(INTEL_IEEE_SINGLE_PRECISION_REAL)) {
            return 4;
        }
        if (this.dataType.equals(SUN_IEEE_DOUBLE_PRECISION_REAL) || this.dataType.equals(INTEL_IEEE_DOUBLE_PRECISION_REAL)) {
            return 5;
        }
        throw new RuntimeException("Unknown dataType: " + this.dataType);
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(out);
        this.write(dos);
        dos.close();
        return out.toByteArray();
    }

    public SteimFrameBlock encodeSteim1(int recLenExp) throws SeedFormatException {
        return this.encodeSteim1(recLenExp, 0);
    }

    public SteimFrameBlock encodeSteim1(int recLenExp, int offset) throws SeedFormatException {
        try {
            if (this.isShortData() || this.isIntData()) {
                return Steim1.encode((int[])this.getIntData(), (int)((1 << recLenExp) / 64 - 1), (int)0, (int)offset);
            }
            throw new SeedFormatException("Steim1 only applicable to integer data, not float or double: " + this.getDataType());
        }
        catch (SteimException e) {
            throw new SeedFormatException(e);
        }
    }

    public SteimFrameBlock encodeSteim2(int recLenExp) throws SeedFormatException {
        return this.encodeSteim2(recLenExp, 0);
    }

    public SteimFrameBlock encodeSteim2(int recLenExp, int offset) throws SeedFormatException {
        try {
            if (this.isShortData() || this.isIntData()) {
                return Steim2.encode((int[])this.getIntData(), (int)((1 << recLenExp) / 64 - 1), (int)0, (int)offset);
            }
            throw new SeedFormatException("Steim2 only applicable to integer data, not float or double: " + this.getDataType());
        }
        catch (SteimException e) {
            throw new SeedFormatException(e);
        }
    }

    @Deprecated
    public List<DataRecord> toMiniSeed(int recLenExp, boolean doSteim1) throws SeedFormatException {
        if (doSteim1) {
            return this.toMiniSeed(recLenExp, 10);
        }
        return this.toMiniSeedNoCompression(recLenExp);
    }

    public static void checkRecordLengthExp(int recLenExp) {
        if (recLenExp > 32) {
            throw new IllegalArgumentException("recLenExp should be exponent of 2, not actual size, " + recLenExp + " is too large, should be <21 and usually 8-12.");
        }
    }

    public List<DataRecord> toMiniSeedNoCompression(int recLenExp) throws SeedFormatException {
        TraceBuf2.checkRecordLengthExp(recLenExp);
        int recordSize = 1 << recLenExp;
        ArrayList<DataRecord> out = new ArrayList<DataRecord>();
        List<TraceBuf2> subList = this.split(recordSize - 64 + 64);
        for (TraceBuf2 subTBuf : subList) {
            out.add(subTBuf.toMiniSeedNoSplit(recLenExp, false));
        }
        return out;
    }

    public List<DataRecord> toMiniSeed(int recLenExp, int compressionType) throws SeedFormatException {
        TraceBuf2.checkRecordLengthExp(recLenExp);
        ArrayList<DataRecord> out = new ArrayList<DataRecord>();
        int recordSize = 1 << recLenExp;
        if (compressionType == 10 || compressionType == 11) {
            int offset = 0;
            boolean done = false;
            while (!done) {
                SteimFrameBlock sfb = null;
                if (compressionType == 10) {
                    sfb = this.encodeSteim1(recLenExp, offset);
                } else if (compressionType == 11) {
                    sfb = this.encodeSteim2(recLenExp, offset);
                }
                sfb.trimEmptyFrames();
                try {
                    out.add(this.toMiniSeedWithCompressedData(recLenExp, compressionType, sfb.getEncodedData(), sfb.getNumSamples(), offset));
                }
                catch (IOException e) {
                    throw new SeedFormatException("unable to get encoded data from SteimFrameBlock", e);
                }
                if ((offset += sfb.getNumSamples()) != this.getNumSamples()) continue;
                done = true;
            }
        } else {
            throw new SeedFormatException("Compression type " + compressionType + " not known or implemented.");
        }
        return out;
    }

    public DataRecord toMiniSeedNoSplit(int recLenExp, boolean steim1) throws SeedFormatException {
        byte[] compressedData = new byte[]{};
        int compressionType = -1;
        if (steim1) {
            try {
                if (!this.isShortData() && !this.isIntData()) {
                    throw new SeedFormatException("Steim1 only applicable to integer data, not float or double: " + this.getDataType());
                }
                compressionType = 10;
                compressedData = Steim1.encode((int[])this.getIntData(), (int)((1 << recLenExp) / 64 - 1)).getEncodedData();
            }
            catch (SteimException e) {
                throw new SeedFormatException(e);
            }
            catch (IOException e) {
                throw new SeedFormatException(e);
            }
        } else {
            Codec codec = new Codec();
            compressionType = this.getSeedEncoding();
            if (this.isShortData()) {
                compressedData = codec.encodeAsBytes(this.getShortData());
            } else if (this.isIntData()) {
                compressedData = codec.encodeAsBytes(this.getIntData());
            } else if (this.isFloatData()) {
                compressedData = codec.encodeAsBytes(this.getFloatData());
            } else if (this.isDoubleData()) {
                compressedData = codec.encodeAsBytes(this.getDoubleData());
            } else {
                throw new SeedFormatException("Unknown data type: " + this.getDataType());
            }
        }
        return this.toMiniSeedWithCompressedData(recLenExp, compressionType, compressedData, this.getNumSamples(), 0);
    }

    DataRecord toMiniSeedWithCompressedData(int recLenExp, int compressionType, byte[] compressedData, int numSamples, int dataOffset) throws SeedFormatException {
        DataHeader dh = new DataHeader(0, 'D', false);
        String s = this.getStation().trim();
        if (s.length() > 5) {
            s = s.substring(0, 5);
        }
        dh.setStationIdentifier(s);
        s = this.getChannel().trim();
        if (s.length() > 3) {
            s = s.substring(0, 3);
        }
        dh.setChannelIdentifier(s);
        s = this.getNetwork().trim();
        if (s.length() > 2) {
            s = s.substring(0, 2);
        }
        dh.setNetworkCode(s);
        s = this.getLocId().trim();
        if (s == null || s.equals("") || s.equals(LOC_NULL_STRING)) {
            s = "  ";
        }
        if (s.length() > 2) {
            s = s.substring(0, 2);
        }
        dh.setLocationIdentifier(s);
        dh.setDataQualityFlags((byte)(this.getQuality() >> 8));
        dh.setNumSamples((short)numSamples);
        dh.setStartBtime(new Btime(this.getStartTime() + (double)dataOffset / this.getSampleRate()));
        dh.setSampleRate(this.getSampleRate());
        DataRecord dr = new DataRecord(dh);
        Blockette1000 b1000 = new Blockette1000();
        b1000.setEncodingFormat((byte)compressionType);
        b1000.setDataRecordLength((byte)recLenExp);
        b1000.setWordOrder((byte)1);
        dr.addBlockette(b1000);
        if ((double)(dh.getSize() + b1000.getSize() + compressedData.length) > Math.pow(2.0, recLenExp)) {
            throw new DataTooLargeException("Cannot fit data into record lenght of " + recLenExp + "(" + Math.pow(2.0, recLenExp) + "). header=" + (dh.getSize() + b1000.getSize()) + " data=" + compressedData.length);
        }
        dr.setData(compressedData);
        return dr;
    }

    public int getSize() {
        return 64 + this.getNumSamples() * TraceBuf2.getSampleSize(this.getDataType());
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        sdf.setTimeZone(QueryParams.UTC);
        return this.getPin() + " " + this.formatNSLCCodes() + " " + sdf.format(this.getStartDate()) + "(" + this.getStartTime() + ") to " + sdf.format(this.getEndDate()) + "(" + this.getEndTime() + ") sr=" + this.getSampleRate() + "  npts=" + this.numSamples + " datetype=" + this.getDataType() + " ver=" + this.getVersion();
    }

    public String toStringWithData() {
        String out = this.toString() + "\n";
        if (this.isShortData() || this.isIntData()) {
            int[] d = this.getIntData();
            for (int i = 0; i < d.length; ++i) {
                out = out + d[i] + " ";
                if (i % 8 != 7) continue;
                out = out + "\n";
            }
        } else {
            double[] d = this.getDoubleData();
            for (int i = 0; i < d.length; ++i) {
                out = out + d[i] + " ";
                if (i % 8 != 7) continue;
                out = out + "\n";
            }
        }
        return out;
    }
}

