/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.client;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.StringParser;
import edu.sc.seis.seisFile.QueryParams;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ISOTimeParser
extends StringParser {
    private boolean ceiling;
    public static final String ISO_TIME_RE = "(\\-?\\d{4})-?(\\d{2})?-?(\\d{2})?(T)?(\\d{2})?:?(\\d{2})?:?(\\d{2})?";
    private static Pattern datePattern = Pattern.compile("(\\-?\\d{4})-?(\\d{2})?-?(\\d{2})?(T)?(\\d{2})?:?(\\d{2})?:?(\\d{2})?");
    public static final String FIRST_SEISMOGRAM = "1889-04-17";
    private static String YESTERDAY = "yesterday";

    public ISOTimeParser(boolean ceiling) {
        this.ceiling = ceiling;
    }

    public Object parse(String arg) throws ParseException {
        return this.getDate(arg);
    }

    public String parseDate(String arg) throws ParseException {
        return ISOTimeParser.format(this.getDate(arg));
    }

    public static String format(Date d) {
        SimpleDateFormat passcalFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        passcalFormat.setTimeZone(QueryParams.UTC);
        return passcalFormat.format(d);
    }

    public static String formatForParsing(Date d) {
        SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        isoFormat.setTimeZone(QueryParams.UTC);
        return isoFormat.format(d);
    }

    public Date getDate(String arg) throws ParseException {
        if (arg.equals("now")) {
            return new Date();
        }
        if (arg.equals(YESTERDAY)) {
            return this.yesterday();
        }
        Matcher m = datePattern.matcher(arg);
        if (!m.matches()) {
            throw new ParseException("A time must be formatted as YYYY[[[[[-MM]-DD]Thh]:mm]:ss] like 2006-11-19 or 2006-11-19T06:34:21, not '" + arg + "'");
        }
        Calendar cal = ISOTimeParser.createCalendar(Integer.parseInt(m.group(1)), ISOTimeParser.extract(m, 2), ISOTimeParser.extract(m, 3), ISOTimeParser.extract(m, 5), ISOTimeParser.extract(m, 6), ISOTimeParser.extract(m, 7), this.ceiling);
        return cal.getTime();
    }

    public static Calendar createCalendar(int year, int month, int day, int hour, int minute, int second, boolean ceiling) {
        Calendar cal = Calendar.getInstance(QueryParams.UTC);
        cal.set(1, year);
        ISOTimeParser.fillInField(2, month - 1, ceiling, cal);
        ISOTimeParser.fillInField(5, day, ceiling, cal);
        ISOTimeParser.fillInField(11, hour, ceiling, cal);
        ISOTimeParser.fillInField(12, minute, ceiling, cal);
        ISOTimeParser.fillInField(13, second, ceiling, cal);
        ISOTimeParser.fillInField(14, -1, ceiling, cal);
        return cal;
    }

    public static void fillInField(int field, int value, boolean ceiling, Calendar cal) {
        if (value >= 0) {
            cal.set(field, value);
        } else if (ceiling) {
            cal.set(field, cal.getActualMaximum(field));
        } else {
            cal.set(field, cal.getActualMinimum(field));
        }
    }

    private static int extract(Matcher m, int i) {
        if (m.group(i) == null) {
            return -1;
        }
        return Integer.parseInt(m.group(i));
    }

    public static FlaggedOption createRequiredParam(String name, String helpMessage, boolean ceiling) {
        return new FlaggedOption(name, (StringParser)new ISOTimeParser(ceiling), null, true, name.charAt(0), name, helpMessage);
    }

    public static FlaggedOption createYesterdayParam(String name, String helpMessage, boolean ceiling) {
        return ISOTimeParser.createParam(name, YESTERDAY, helpMessage, ceiling);
    }

    public static FlaggedOption createParam(String name, String helpMessage, boolean ceiling) {
        return ISOTimeParser.createParam(name, null, helpMessage, ceiling);
    }

    public static FlaggedOption createParam(String name, String defaultTime, String helpMessage, boolean ceiling) {
        return new FlaggedOption(name, (StringParser)new ISOTimeParser(ceiling), defaultTime, false, name.charAt(0), name, helpMessage);
    }

    public Date yesterday() {
        Calendar cal = GregorianCalendar.getInstance(QueryParams.UTC);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(6, -1);
        return cal.getTime();
    }
}

