/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.IfNetwork;

import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.SiteHelper;
import edu.iris.Fissures.IfNetwork.SiteId;
import edu.iris.Fissures.IfNetwork.SiteIdHelper;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationHelper;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.LocationHelper;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.TimeRangeHelper;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.StreamableValue;

public abstract class Site
implements StreamableValue {
    protected SiteId id;
    protected Location my_location;
    protected TimeRange effective_time;
    private Station my_station;
    protected String comment;
    private static String[] _OB_truncatableIds_ = new String[]{SiteHelper.id()};
    private static Map<String, WeakReference<Site>> knownSites = Collections.synchronizedMap(new HashMap());

    public abstract SiteId get_id();

    public abstract String get_code();

    public String[] _truncatable_ids() {
        return _OB_truncatableIds_;
    }

    public void _read(InputStream in) {
        this.id = SiteIdHelper.read(in);
        this.my_location = LocationHelper.read(in);
        this.effective_time = TimeRangeHelper.read(in);
        this.setStation(StationHelper.read(in));
        this.comment = in.read_string();
    }

    public void _write(OutputStream out) {
        SiteIdHelper.write(out, this.id);
        LocationHelper.write(out, this.my_location);
        TimeRangeHelper.write(out, this.effective_time);
        StationHelper.write(out, this.getStation());
        out.write_string(this.comment);
    }

    public TypeCode _type() {
        return SiteHelper.type();
    }

    public SiteId getId() {
        if (this.id != null && this.id.network_id == null && this.getStation() != null && this.getStation().getNetworkAttr() != null) {
            this.id.network_id = this.getStation().getNetworkAttr().getId();
        }
        return this.id;
    }

    public Location getLocation() {
        return this.my_location;
    }

    public TimeRange getEffectiveTime() {
        return this.effective_time;
    }

    public Station getStation() {
        return this.my_station;
    }

    public String getComment() {
        return this.comment;
    }

    public static void intern(SiteId id) {
        id.network_id = NetworkAttr.intern(id.network_id);
        id.station_code = NetworkAttr.intern(id.station_code);
        id.site_code = NetworkAttr.intern(id.site_code);
        id.begin_time = NetworkAttr.intern(id.begin_time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Site intern(Site site) {
        Map<String, WeakReference<Site>> map = knownSites;
        synchronized (map) {
            String key = site.getStation().getNetworkAttr().getId().network_code + site.getStation().getNetworkAttr().getId().begin_time.date_time + ":" + site.getStation().getId().station_code + ":" + site.getId().site_code + site.getId().begin_time.date_time;
            Site interned = null;
            if (knownSites.containsKey(key)) {
                interned = (Site)knownSites.get(key).get();
            }
            if (interned == null) {
                knownSites.put(key, new WeakReference<Site>(site));
                Site.intern(site.get_id());
                site.comment = NetworkAttr.intern(site.comment);
                site.setStation(Station.intern(site.getStation()));
                site.getId().network_id = site.getStation().getNetworkAttr().getId();
                site.effective_time = NetworkAttr.intern(site.effective_time);
                return site;
            }
            return interned;
        }
    }

    protected void setId(SiteId s) {
        this.id = s;
    }

    protected void setLocation(Location loc) {
        this.my_location = loc;
    }

    protected void setEffectiveTime(TimeRange effective_time) {
        this.effective_time = effective_time;
    }

    public void setStation(Station my_station) {
        this.my_station = my_station;
    }

    protected void setComment(String comment) {
        this.comment = comment;
    }

    public Time getBeginTime() {
        return this.get_id().begin_time;
    }

    protected void setBeginTime(Time beginTime) {
        if (this.effective_time == null) {
            this.effective_time = new TimeRange();
        }
        this.effective_time.start_time = beginTime;
        this.get_id().begin_time = beginTime;
    }

    public Time getEndTime() {
        return this.effective_time.end_time;
    }

    protected void setEndTime(Time endTime) {
        if (this.effective_time == null) {
            this.effective_time = new TimeRange();
        }
        this.effective_time.end_time = endTime;
        this.effective_time.start_time = this.get_id().begin_time;
    }
}

