/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.IfNetwork;

import edu.iris.Fissures.IfNetwork.ChannelHelper;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.ChannelIdHelper;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.SiteHelper;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.OrientationHelper;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.SamplingHelper;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.TimeRangeHelper;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.StreamableValue;

public abstract class Channel
implements StreamableValue {
    protected ChannelId id;
    private String name;
    private Orientation an_orientation;
    private Sampling sampling_info;
    private TimeRange effective_time;
    private Site my_site;
    private static String[] _OB_truncatableIds_ = new String[]{ChannelHelper.id()};

    public abstract ChannelId get_id();

    public abstract String get_code();

    public String[] _truncatable_ids() {
        return _OB_truncatableIds_;
    }

    public void _read(InputStream in) {
        this.id = ChannelIdHelper.read(in);
        this.setName(in.read_string());
        this.setOrientation(OrientationHelper.read(in));
        this.setSamplingInfo(SamplingHelper.read(in));
        this.setEffectiveTime(TimeRangeHelper.read(in));
        this.setSite(SiteHelper.read(in));
    }

    public void _write(OutputStream out) {
        ChannelIdHelper.write(out, this.id);
        out.write_string(this.getName());
        OrientationHelper.write(out, this.getOrientation());
        SamplingHelper.write(out, this.getSamplingInfo());
        TimeRangeHelper.write(out, this.getEffectiveTime());
        SiteHelper.write(out, this.getSite());
    }

    public TypeCode _type() {
        return ChannelHelper.type();
    }

    public String getName() {
        return this.name;
    }

    public Orientation getOrientation() {
        return this.an_orientation;
    }

    public Sampling getSamplingInfo() {
        return this.sampling_info;
    }

    public TimeRange getEffectiveTime() {
        return this.effective_time;
    }

    public Site getSite() {
        return this.my_site;
    }

    public Station getStation() {
        return this.getSite().getStation();
    }

    public NetworkAttr getNetworkAttr() {
        return this.getStation().getNetworkAttr();
    }

    public static Channel intern(Channel channel) {
        Channel.intern(channel.get_id());
        channel.setSite(Site.intern(channel.getSite()));
        NetworkAttr.intern(channel.getEffectiveTime());
        channel.setName(NetworkAttr.intern(channel.getName()));
        return channel;
    }

    private static void intern(ChannelId id) {
        id.channel_code = NetworkAttr.intern(id.channel_code);
        id.network_id = NetworkAttr.intern(id.network_id);
        id.station_code = NetworkAttr.intern(id.station_code);
        id.site_code = NetworkAttr.intern(id.site_code);
        id.begin_time = NetworkAttr.intern(id.begin_time);
    }

    public Time getBeginTime() {
        return this.get_id().begin_time;
    }

    public void setBeginTime(Time beginTime) {
        if (this.getEffectiveTime() == null) {
            this.setEffectiveTime(new TimeRange());
        }
        this.getEffectiveTime().start_time = beginTime;
        if (this.id != null) {
            this.id.begin_time = beginTime;
        }
    }

    public Time getEndTime() {
        return this.getEffectiveTime().end_time;
    }

    public void setEndTime(Time endTime) {
        if (this.getEffectiveTime() == null) {
            this.setEffectiveTime(new TimeRange());
            this.getEffectiveTime().start_time = this.id.begin_time;
        }
        this.getEffectiveTime().end_time = endTime;
    }

    public void setSite(Site site) {
        this.my_site = site;
    }

    public ChannelId getId() {
        if (this.id.network_id == null) {
            this.id.network_id = this.getSite().getStation().getNetworkAttr().getId();
        }
        return this.id;
    }

    protected void setId(ChannelId id) {
        if (this.id != null && id.network_id == null) {
            id.network_id = this.id.network_id;
        }
        this.id = id;
        if (id.begin_time == null && this.getEffectiveTime() != null) {
            id.begin_time = this.getEffectiveTime().start_time;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOrientation(Orientation orientation) {
        this.an_orientation = orientation;
    }

    public void setSamplingInfo(Sampling sampling_info) {
        this.sampling_info = sampling_info;
    }

    public void setEffectiveTime(TimeRange eff) {
        this.effective_time = eff;
    }
}

