/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.icon;

import com.bbn.openmap.tools.icon.BasicIconPart;
import com.bbn.openmap.tools.icon.IconPartCollection;
import com.bbn.openmap.tools.icon.IconPartCollectionEntry;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;

public class OpenMapAppPartCollection
extends IconPartCollection {
    static OpenMapAppPartCollection omparts;
    public static final OpenMapAppPart BIG_BOX;
    public static final OpenMapAppPart SMALL_BOX;
    public static final OpenMapAppPart FILL_BOX;
    public static final OpenMapAppPart UL_TRI;
    public static final OpenMapAppPart LR_TRI;
    public static final OpenMapAppPart LL_UR_LINE;
    public static final OpenMapAppPart UL_LR_LINE;

    protected OpenMapAppPartCollection() {
        super("OpenMap", "Common parts used in OpenMap Application Icons");
        this.init();
    }

    public static synchronized OpenMapAppPartCollection getInstance() {
        if (omparts == null) {
            omparts = new OpenMapAppPartCollection();
        }
        return omparts;
    }

    protected void init() {
        this.add(BIG_BOX.getEntry());
        this.add(SMALL_BOX.getEntry());
        this.add(FILL_BOX.getEntry());
        this.add(UL_TRI.getEntry());
        this.add(LR_TRI.getEntry());
        this.add(LL_UR_LINE.getEntry());
        this.add(UL_LR_LINE.getEntry());
    }

    static {
        BIG_BOX = new OpenMapAppPart("BIG_BOX", "BIG_BOX", new int[]{10, 10, 90, 90, 10}, new int[]{10, 90, 90, 10, 10});
        SMALL_BOX = new OpenMapAppPart("SMALL_BOX", "SMALL_BOX", new int[]{30, 30, 70, 70, 30}, new int[]{30, 70, 70, 30, 30});
        FILL_BOX = new OpenMapAppPart("FILL_BOX", "FILL_BOX", new int[]{10, 10, 50, 50, 30, 30, 70, 70, 50, 50, 90, 90, 10}, new int[]{10, 90, 90, 70, 70, 30, 30, 70, 70, 90, 90, 10, 10});
        UL_TRI = new OpenMapAppPart("UL_TRI", "UL_TRI", new int[]{10, 10, 75, 10}, new int[]{10, 75, 10, 10});
        LR_TRI = new OpenMapAppPart("LR_TRI", "LR_TRI", new int[]{25, 90, 90, 25}, new int[]{90, 90, 25, 90});
        LL_UR_LINE = new OpenMapAppPart("LL_UR_LINE", "LL_UR_LINE", new int[]{10, 90}, new int[]{90, 10});
        UL_LR_LINE = new OpenMapAppPart("UL_LR_LINE", "UL_LR_LINE", new int[]{10, 90}, new int[]{10, 90});
    }

    public static class OpenMapAppPart {
        int[] xpoints;
        int[] ypoints;
        String name;
        String description;
        AffineTransform af;

        public OpenMapAppPart(String n, String d, int[] xp, int[] yp) {
            this(n, d, xp, yp, null);
        }

        public OpenMapAppPart(String n, String d, int[] xp, int[] yp, AffineTransform affTrans) {
            this.name = n;
            this.description = d;
            this.xpoints = xp;
            this.ypoints = yp;
            this.af = affTrans;
        }

        public IconPartCollectionEntry getEntry() {
            return new IconPartCollectionEntry(this.name, this.description, new BasicIconPart(new Polygon(this.xpoints, this.ypoints, this.xpoints.length), this.af));
        }
    }
}

