/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj.coords;

import com.bbn.openmap.LatLonPoint;

public class UPSPoint {
    protected double easting;
    protected double northing;
    private double Degree = Math.PI / 180;

    public UPSPoint() {
        this.easting = 0.0;
        this.northing = 0.0;
    }

    public UPSPoint(double easting, double northing) {
        this.easting = easting;
        this.northing = northing;
    }

    public static UPSPoint createUPSPoint(double lat, double lon) {
        UPSPoint ups = new UPSPoint();
        ups.toUPS(lat, lon);
        return ups;
    }

    public UPSPoint(LatLonPoint llpt) {
        double lat = llpt.getLatitude();
        double lon = llpt.getLongitude();
        this.toUPS(lat, lon);
    }

    public void toUPS(double lat, double lon) {
        double a = 0.0;
        double t = 0.0;
        double e = 0.0;
        double es = 0.0;
        double rho = 0.0;
        double k0 = 0.994;
        double lambda = lon * this.Degree;
        double phi = Math.abs(lat * this.Degree);
        a = 6378137.0;
        es = 0.00669438;
        e = Math.sqrt(es);
        t = Math.tan(0.7853981633974483 - phi / 2.0) / Math.pow((1.0 - e * Math.sin(phi)) / (1.0 + e * Math.sin(phi)), e / 2.0);
        rho = 2.0 * a * 0.994 * t / Math.sqrt(Math.pow(1.0 + e, 1.0 + e) * Math.pow(1.0 - e, 1.0 - e));
        double x = rho * Math.sin(lambda);
        double y = rho * Math.cos(lambda);
        if (lat > 0.0) {
            y = -y;
        }
        this.easting = x += 2000000.0;
        this.northing = y += 2000000.0;
    }

    public LatLonPoint toLatLonPoint(boolean southernHemisphere) {
        LatLonPoint llp = new LatLonPoint();
        double lon = 0.0;
        double lat = 0.0;
        double a = 0.0;
        double es = 0.0;
        double e = 0.0;
        double t = 0.0;
        double rho = 0.0;
        double x = this.easting;
        double y = this.northing;
        double k0 = 0.994;
        a = 6378137.0;
        es = 0.00669438;
        e = Math.sqrt(es);
        rho = Math.sqrt((x -= 2000000.0) * x + (y -= 2000000.0) * y);
        t = rho * Math.sqrt(Math.pow(1.0 + e, 1.0 + e) * Math.pow(1.0 - e, 1.0 - e)) / (2.0 * a * 0.994);
        lat = UPSPoint.calcPhi(e, t);
        lat /= this.Degree;
        if (y != 0.0) {
            t = Math.atan(Math.abs(x / y));
        } else {
            t = 1.5707963267948966;
            if (x < 0.0) {
                t = -t;
            }
        }
        if (!southernHemisphere) {
            y = -y;
        } else {
            lat = -lat;
        }
        if (y < 0.0) {
            t = Math.PI - t;
        }
        if (x < 0.0) {
            t = -t;
        }
        lon = t / this.Degree;
        llp.setLatitude((float)lat);
        llp.setLongitude((float)lon);
        return llp;
    }

    public void setNorthing(double northing) {
        this.northing = northing;
    }

    public void setEasting(double easting) {
        this.easting = easting;
    }

    public double getNorthing() {
        return this.northing;
    }

    public double getEasting() {
        return this.easting;
    }

    public String toString() {
        return "Easting:" + this.easting + " Northing:" + this.northing;
    }

    static double calcPhi(double e, double t) {
        double phi = 0.0;
        double old = 1.5707963267948966 - 2.0 * Math.atan(t);
        int maxIterations = 20;
        while (Math.abs((phi - old) / phi) > 1.0E-8 && maxIterations != 0) {
            old = phi;
            phi = 1.5707963267948966 - 2.0 * Math.atan(t * Math.pow((1.0 - e * Math.sin(phi)) / (1.0 + e * Math.sin(phi)), e / 2.0));
            maxIterations = (short)(maxIterations - 1);
        }
        return phi;
    }

    public static void main(String[] args) {
        LatLonPoint llpt1 = new LatLonPoint(87.0, -74.5);
        System.out.println(llpt1.toString());
        UPSPoint ups = new UPSPoint(llpt1);
        System.out.println(ups.toString());
        LatLonPoint llpt2 = ups.toLatLonPoint(false);
        System.out.println(llpt2.toString());
        System.out.println("--------------------------------------------");
        llpt1 = new LatLonPoint(-89.0, 110.5);
        System.out.println(llpt1.toString());
        ups = new UPSPoint(llpt1);
        System.out.println(ups.toString());
        llpt2 = ups.toLatLonPoint(true);
        System.out.println(llpt2.toString());
    }
}

