/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.plugin;

import com.bbn.openmap.io.CSVFile;
import com.bbn.openmap.layer.util.LayerUtils;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMScalingRaster;
import com.bbn.openmap.plugin.OMGraphicHandlerPlugIn;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;

public class CSVTiledImagePlugIn
extends OMGraphicHandlerPlugIn {
    HashSet tiles = new HashSet();
    boolean DEBUG = false;
    public static final String CSVFileNameProperty = "tileFile";
    public static final String FileHasHeaderProperty = "fileHasHeader";
    protected String tileFileName = null;
    protected boolean fileHasHeader = true;
    protected CSVFile tilefile = null;
    public int ullatIndex = 0;
    public int ullonIndex = 1;
    public int lrlatIndex = 2;
    public int lrlonIndex = 3;
    public int urlIndex = 4;

    public CSVTiledImagePlugIn() {
        this.DEBUG = Debug.debugging("tiledimage");
    }

    public CSVTiledImagePlugIn(Component comp) {
        super(comp);
    }

    public OMGraphicList getRectangle(Projection p) {
        OMGraphicList list = this.getList();
        list.clear();
        if (this.DEBUG) {
            Debug.output("CSVTIPI: getRectangle");
        }
        if (this.tilefile == null) {
            this.loadTiles(this.tileFileName);
        }
        Iterator it = this.tiles.iterator();
        while (it.hasNext()) {
            OMScalingRaster tile = (OMScalingRaster)it.next();
            if (tile.isOnMap(p)) {
                if (this.DEBUG) {
                    Debug.output("CSVTIPI: image on map");
                }
                tile.generate(p);
                list.add(tile);
                continue;
            }
            if (!this.DEBUG) continue;
            Debug.output("CSVTIPI: image not on map, skipping");
        }
        this.repaint();
        return list;
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.tileFileName = props.getProperty(realPrefix + CSVFileNameProperty);
        if (this.DEBUG) {
            Debug.output("CSVTIPI: file: " + this.tileFileName);
        }
        this.fileHasHeader = LayerUtils.booleanFromProperties(props, realPrefix + FileHasHeaderProperty, this.fileHasHeader);
        if (this.DEBUG) {
            Debug.output("CSVTIPI: file has header: " + this.fileHasHeader);
        }
    }

    protected void loadTiles(String csvFileName) {
        block10: {
            int imageCount = 0;
            if (csvFileName == null) break block10;
            try {
                this.tilefile = new CSVFile(csvFileName);
                this.tilefile.setHeadersExist(this.fileHasHeader);
                this.tilefile.loadData(false);
                MediaTracker tracker = new MediaTracker(this.component);
                Iterator records = this.tilefile.iterator();
                while (records.hasNext()) {
                    Vector record = (Vector)records.next();
                    if (this.DEBUG) {
                        Debug.output("CSVTIPI: record: " + record);
                    }
                    String imageURLString = null;
                    try {
                        Image fileImage;
                        float lrlon;
                        float lrlat;
                        float ullon;
                        float ullat;
                        block9: {
                            ullat = ((Double)record.get(this.ullatIndex)).floatValue();
                            ullon = ((Double)record.get(this.ullonIndex)).floatValue();
                            lrlat = ((Double)record.get(this.lrlatIndex)).floatValue();
                            lrlon = ((Double)record.get(this.lrlonIndex)).floatValue();
                            imageURLString = (String)record.get(this.urlIndex);
                            URL imageURL = PropUtils.getResourceOrFileOrURL(imageURLString);
                            ImageIcon ii = new ImageIcon(imageURL);
                            fileImage = ii.getImage();
                            try {
                                tracker.addImage(fileImage, imageCount);
                                tracker.waitForID(imageCount);
                            }
                            catch (Exception e) {
                                if (!Debug.debugging("csvtiledimage")) break block9;
                                e.printStackTrace();
                            }
                        }
                        OMScalingRaster omsr = new OMScalingRaster(ullat, ullon, lrlat, lrlon, fileImage);
                        this.tiles.add(omsr);
                        ++imageCount;
                    }
                    catch (MalformedURLException innerMurle) {
                        Debug.error("CSVTiledImagePlugIn: image tile path not valid: " + imageURLString + ", skipping...");
                    }
                    catch (ArrayIndexOutOfBoundsException aioobe) {
                        Debug.error("CSVTiledImagePlugIn: having trouble reading line (" + imageCount + "), skipping...\n" + aioobe.getMessage());
                    }
                }
            }
            catch (MalformedURLException murle) {
                Debug.error("CSVTiledImagePlugIn: CSV tile file not valid: " + csvFileName);
            }
        }
    }

    public Properties getProperties(Properties getList) {
        if (getList == null) {
            getList = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        getList.put(prefix + CSVFileNameProperty, PropUtils.unnull(this.tileFileName));
        getList.put(prefix + FileHasHeaderProperty, new Boolean(this.fileHasHeader).toString());
        return getList;
    }

    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        list.put(CSVFileNameProperty, "URL to CSV data file");
        list.put(FileHasHeaderProperty, "Flag to note if CSV file has descriptive header line");
        list.put("fileHasHeader.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        return list;
    }
}

