/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.meteo;

import com.bbn.openmap.omGraphics.awt.AbstractShapeDecoration;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class HotFrontShapeDecoration
extends AbstractShapeDecoration {
    public static Color COLOR = Color.red;
    private boolean filled = true;

    public HotFrontShapeDecoration(int length, int width, int orientation) {
        super(length, width, orientation);
        this.setPaint(COLOR);
    }

    public void draw(Graphics g, Point2D[] points, boolean complete) {
        Graphics2D g2D = (Graphics2D)g;
        this.setGraphics(g);
        int nbpts = points.length;
        int[] xcoord = new int[nbpts + 6];
        int[] ycoord = new int[nbpts + 6];
        int i = 0;
        while (i < nbpts) {
            xcoord[i] = (int)points[i].getX();
            ycoord[i] = (int)points[i].getY();
            ++i;
        }
        if (complete) {
            int orient = this.getOrientation() == 2 ? -1 : 1;
            double dx = points[nbpts - 1].getX() - points[0].getX();
            double dy = points[nbpts - 1].getY() - points[0].getY();
            double norm = Math.sqrt(dx * dx + dy * dy);
            double rcos = dx / norm;
            double rsin = dy / norm;
            double ll = this.getLength();
            double ww = (float)orient * this.getWidth();
            double l = 0.9330127 * ll;
            double w = 0.5 * ww;
            xcoord[nbpts] = (int)(points[0].getX() + l * rcos - w * rsin);
            ycoord[nbpts++] = (int)(points[0].getY() + l * rsin + w * rcos);
            l = 0.85355339 * ll;
            w = 0.70710678 * ww;
            xcoord[nbpts] = (int)(points[0].getX() + l * rcos - w * rsin);
            ycoord[nbpts++] = (int)(points[0].getY() + l * rsin + w * rcos);
            l = 0.5 * ll;
            w = ww;
            xcoord[nbpts] = (int)(points[0].getX() + l * rcos - w * rsin);
            ycoord[nbpts++] = (int)(points[0].getY() + l * rsin + w * rcos);
            l = 0.14644661 * ll;
            w = 0.70710678 * ww;
            xcoord[nbpts] = (int)(points[0].getX() + l * rcos - w * rsin);
            ycoord[nbpts++] = (int)(points[0].getY() + l * rsin + w * rcos);
            l = 0.066987298 * ll;
            w = 0.5 * ww;
            xcoord[nbpts] = (int)(points[0].getX() + l * rcos - w * rsin);
            ycoord[nbpts++] = (int)(points[0].getY() + l * rsin + w * rcos);
            xcoord[nbpts] = (int)points[0].getX();
            ycoord[nbpts++] = (int)points[0].getY();
            if (this.filled) {
                g.fillPolygon(xcoord, ycoord, nbpts);
            }
        }
        g.drawPolyline(xcoord, ycoord, nbpts);
        this.restoreGraphics(g);
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setFilled(boolean filled) {
        this.filled = filled;
    }
}

