/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.grid;

import com.bbn.openmap.omGraphics.grid.ElevationColors;
import com.bbn.openmap.omGraphics.grid.GeneratorLoader;
import com.bbn.openmap.omGraphics.grid.OMGridGenerator;
import com.bbn.openmap.omGraphics.grid.SlopeGenerator;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SlopeGeneratorLoader
extends GeneratorLoader {
    public static final String ColorsClassProperty = "colorsClass";
    public static final String COLORS_PROPERTY = "COLORS";
    public static final String CONTRAST_PROPERTY = "CONTRAST";
    public static final String DEFAULT_COLORS_CLASS = "com.bbn.openmap.omGraphics.grid.ColoredShadingColors";
    protected ElevationColors colors;
    protected int contrast = 5;

    public void setColors(ElevationColors cols) {
        ElevationColors oldColors = this.colors;
        this.colors = cols;
        if (oldColors != this.colors) {
            this.firePropertyChange(COLORS_PROPERTY, oldColors, this.colors);
        }
    }

    public ElevationColors getColors() {
        block4: {
            if (this.colors != null) break block4;
            try {
                this.colors = (ElevationColors)Class.forName(DEFAULT_COLORS_CLASS).newInstance();
            }
            catch (InstantiationException ie) {
            }
            catch (IllegalAccessException iae) {
            }
            catch (ClassNotFoundException cnfe) {}
        }
        return this.colors;
    }

    public void setContrast(int cont) {
        int oldValue = this.contrast;
        this.contrast = cont;
        if (oldValue != this.contrast) {
            this.firePropertyChange(CONTRAST_PROPERTY, new Integer(oldValue), new Integer(this.contrast));
        }
    }

    public int getContrast() {
        return this.contrast;
    }

    public Component getGUI() {
        JPanel panel = new JPanel();
        JPanel contrastPanel = PaletteHelper.createPaletteJPanel("Contrast Adjustment");
        JSlider contrastSlide = new JSlider(0, 1, 10, this.getContrast());
        Hashtable<Integer, JLabel> dict = new Hashtable<Integer, JLabel>();
        dict.put(new Integer(1), new JLabel("min"));
        dict.put(new Integer(10), new JLabel("max"));
        contrastSlide.setLabelTable(dict);
        contrastSlide.setPaintLabels(true);
        contrastSlide.setMajorTickSpacing(1);
        contrastSlide.setPaintTicks(true);
        contrastSlide.setSnapToTicks(true);
        contrastSlide.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                JSlider slider = (JSlider)ce.getSource();
                if (slider.getValueIsAdjusting()) {
                    SlopeGeneratorLoader.this.setContrast(slider.getValue());
                }
            }
        });
        contrastPanel.add(contrastSlide);
        panel.add(contrastPanel);
        return panel;
    }

    public OMGridGenerator getGenerator() {
        SlopeGenerator gen = new SlopeGenerator();
        gen.setColors(this.getColors());
        gen.setContrast(this.contrast);
        return gen;
    }

    public void setProperties(String prefix, Properties props) {
        block2: {
            super.setProperties(prefix, props);
            prefix = PropUtils.getScopedPropertyPrefix(prefix);
            String colorsClassProperty = props.getProperty(prefix + ColorsClassProperty);
            if (colorsClassProperty == null) break block2;
            try {
                this.setColors((ElevationColors)ComponentFactory.create(colorsClassProperty));
            }
            catch (ClassCastException cce) {
                Debug.output("SlopeGeneratorLoader created a " + colorsClassProperty + ", but it's not a ElevationColors object");
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        super.addPropertyChangeListener(CONTRAST_PROPERTY, pcl);
        super.addPropertyChangeListener(COLORS_PROPERTY, pcl);
    }
}

