/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.editable;

import com.bbn.openmap.layer.util.stateMachine.State;
import com.bbn.openmap.omGraphics.EditableOMGraphic;
import com.bbn.openmap.omGraphics.GrabPoint;
import com.bbn.openmap.omGraphics.editable.EOMGCursors;
import com.bbn.openmap.omGraphics.editable.EOMGSelectedState;
import com.bbn.openmap.omGraphics.event.EOMGEvent;
import com.bbn.openmap.util.Debug;
import java.awt.event.MouseEvent;

public class GraphicSelectedState
extends State
implements EOMGSelectedState {
    protected EditableOMGraphic graphic;

    public GraphicSelectedState(EditableOMGraphic eomg) {
        this.graphic = eomg;
    }

    public boolean mousePressed(MouseEvent e) {
        Debug.message("eomg", "GraphicStateMachine|selected state|mousePressed");
        GrabPoint mp = this.graphic.getMovingPoint(e);
        if (mp == null) {
            float distance = this.graphic.getGraphic().distance(e.getX(), e.getY());
            if (distance <= 2.0f) {
                if (this.graphic.getCanGrabGraphic()) {
                    Debug.message("eomg", "GraphicStateMachine|selected state|mousePressed - graphic held");
                    this.graphic.getStateMachine().setEdit();
                    this.graphic.fireEvent(EOMGCursors.MOVE, "");
                    this.graphic.move(e);
                } else {
                    Debug.message("eomg", "GraphicStateMachine|selected state|mousePressed - graphic can't be held");
                }
                this.graphic.fireEvent(EOMGCursors.DEFAULT, "");
            } else {
                Debug.message("eomg", "GraphicStateMachine|selected state|mousePressed - click off graphic, " + distance + " away");
                this.graphic.fireEvent(EOMGCursors.DEFAULT, "");
            }
        } else {
            this.graphic.getStateMachine().setEdit();
            this.graphic.fireEvent(EOMGCursors.EDIT, "");
        }
        return this.getMapMouseListenerResponse();
    }

    public boolean mouseReleased(MouseEvent e) {
        Debug.message("eomg", "GraphicStateMachine|selected state|mouseReleased");
        GrabPoint mp = this.graphic.getMovingPoint(e);
        if (mp == null) {
            if (this.graphic.getGraphic().distance(e.getX(), e.getY()) <= 2.0f) {
                if (this.graphic.getCanGrabGraphic()) {
                    this.graphic.fireEvent(EOMGCursors.EDIT, "", e);
                    this.graphic.redraw(e, true);
                } else {
                    this.graphic.fireEvent(EOMGCursors.DEFAULT, "", e);
                }
            } else {
                Debug.message("eomg", " deactivating with fired event");
                this.graphic.fireEvent(new EOMGEvent());
            }
        } else {
            this.graphic.fireEvent(EOMGCursors.EDIT, "", e);
            this.graphic.redraw(e, true);
        }
        this.graphic.setMovingPoint(null);
        return this.getMapMouseListenerResponse();
    }

    public boolean mouseMoved(MouseEvent e) {
        Debug.message("eomgdetail", "GraphicStateMachine|selected state|mouseMoved");
        GrabPoint mp = this.graphic.getMovingPoint(e);
        if (mp == null) {
            if (this.graphic.getGraphic().distance(e.getX(), e.getY()) < 2.0f) {
                this.graphic.fireEvent(EOMGCursors.EDIT, "Click and Drag to move the graphic.");
            } else {
                this.graphic.fireEvent(EOMGCursors.DEFAULT, "");
            }
        } else {
            this.graphic.fireEvent(EOMGCursors.EDIT, "Click and Drag to change the graphic.");
        }
        return false;
    }
}

