/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.omGraphics.geom.BasicGeometry;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.ImageIcon;

public class OMScalingRaster
extends OMRaster
implements Serializable {
    protected float lat2 = 0.0f;
    protected float lon2 = 0.0f;
    protected BufferedImage sourceImage = null;
    protected Rectangle clipRect;

    public OMScalingRaster() {
    }

    public OMScalingRaster(float ullat, float ullon, float lrlat, float lrlon, int w, int h, int[] pix) {
        super(ullat, ullon, w, h, pix);
        this.lat2 = lrlat;
        this.lon2 = lrlon;
    }

    public OMScalingRaster(float ullat, float ullon, float lrlat, float lrlon, ImageIcon ii) {
        this(ullat, ullon, lrlat, lrlon, ii.getImage());
    }

    public OMScalingRaster(float ullat, float ullon, float lrlat, float lrlon, Image ii) {
        this.setRenderType(1);
        this.setColorModel(2);
        this.lat = ullat;
        this.lon = ullon;
        this.lat2 = lrlat;
        this.lon2 = lrlon;
        this.setImage(ii);
    }

    public OMScalingRaster(float ullat, float ullon, float lrlat, float lrlon, int w, int h, byte[] bytes, Color[] colorTable, int trans) {
        super(ullat, ullon, w, h, bytes, colorTable, trans);
        this.lat2 = lrlat;
        this.lon2 = lrlon;
    }

    public void setImage(Image image) {
        if (this.DEBUG) {
            Debug.output("OMScalingRaster.setImage: " + image);
        }
        if (image == null) {
            return;
        }
        if (!(image instanceof BufferedImage)) {
            this.sourceImage = new BufferedImage(image.getWidth(this), image.getHeight(this), 2);
            Graphics2D g2D = this.sourceImage.createGraphics();
            g2D.drawImage(image, 0, 0, this);
        } else {
            this.sourceImage = (BufferedImage)image;
        }
        this.width = this.sourceImage.getWidth();
        this.height = this.sourceImage.getHeight();
        this.bitmap = this.sourceImage;
    }

    protected boolean position(Projection proj) {
        if (proj == null) {
            if (this.DEBUG) {
                Debug.error("OMScalingRaster: null projection in position!");
            }
            return false;
        }
        this.point1 = proj.forward(this.lat, this.lon);
        this.point2 = proj.forward(this.lat2, this.lon2);
        this.setNeedToReposition(false);
        return true;
    }

    public boolean generate(Projection proj) {
        this.shape = null;
        if (!this.position(proj)) {
            if (this.DEBUG) {
                Debug.error("OMRaster.generate(): positioning failed!");
            }
            return false;
        }
        if (this.colorModel != 2 && (this.sourceImage == null || this.getNeedToRegenerate())) {
            if (this.DEBUG) {
                Debug.output("OMScalingRaster: generating image");
            }
            boolean ret = super.generate(proj);
            this.setImage(this.bitmap);
        }
        this.scaleTo(proj);
        if (this.bitmap != null) {
            int w = this.bitmap.getWidth(this);
            int h = this.bitmap.getHeight(this);
            this.setShape(BasicGeometry.createBoxShape(this.point1.x, this.point1.y, w, h));
            this.setNeedToRegenerate(false);
        }
        return true;
    }

    protected void rotate(Graphics2D g) {
        int rotOffsetX = this.point1.x + (this.point2.x - this.point1.x) / 2;
        int rotOffsetY = this.point1.y + (this.point2.y - this.point1.y) / 2;
        g.rotate(this.rotationAngle, rotOffsetX, rotOffsetY);
    }

    protected void scaleTo(Projection thisProj) {
        if (this.DEBUG) {
            Debug.output("OMScalingRaster: scaleTo()");
        }
        if (this.sourceImage == null) {
            if (this.DEBUG) {
                Debug.output("OMScalingRaster.scaleTo() sourceImage is null");
            }
            return;
        }
        Rectangle winRect = new Rectangle(thisProj.getWidth(), thisProj.getHeight());
        Rectangle projRect = new Rectangle();
        projRect.setLocation(this.point1);
        projRect.setSize(this.point2.x - this.point1.x, this.point2.y - this.point1.y);
        Rectangle sourceRect = new Rectangle();
        sourceRect.width = this.sourceImage.getWidth();
        sourceRect.height = this.sourceImage.getHeight();
        this.clipRect = null;
        Rectangle iRect = winRect.intersection(projRect);
        if (!iRect.isEmpty()) {
            this.clipRect = new Rectangle();
            this.clipRect.setBounds(sourceRect);
            if (iRect.width >= 1 && iRect.height >= 1) {
                if (!winRect.contains(projRect)) {
                    float xScaleFactor = (float)sourceRect.width / (float)projRect.width;
                    float yScaleFactor = (float)sourceRect.height / (float)projRect.height;
                    int xOffset = iRect.x - projRect.x;
                    int yOffset = iRect.y - projRect.y;
                    this.clipRect.x = (int)((float)xOffset * xScaleFactor);
                    this.clipRect.y = (int)((float)yOffset * yScaleFactor);
                    this.clipRect.width = (int)Math.ceil((float)iRect.width * xScaleFactor);
                    this.clipRect.height = (int)Math.ceil((float)iRect.height * yScaleFactor);
                    if (this.clipRect.width + this.clipRect.x > sourceRect.width) {
                        this.clipRect.width = sourceRect.width - this.clipRect.x;
                    }
                    if (this.clipRect.height + this.clipRect.y > sourceRect.height) {
                        this.clipRect.height = sourceRect.height - this.clipRect.y;
                    }
                }
                if (this.clipRect.width <= 0) {
                    this.clipRect.width = 1;
                }
                if (this.clipRect.height <= 0) {
                    this.clipRect.height = 1;
                }
                double widthAdj = (double)iRect.width / (double)this.clipRect.width;
                double heightAdj = (double)iRect.height / (double)this.clipRect.height;
                AffineTransform xform = new AffineTransform();
                xform.setToScale(widthAdj, heightAdj);
                AffineTransformOp xformOp = new AffineTransformOp(xform, 1);
                BufferedImage newImage = xformOp.filter(this.sourceImage.getSubimage(this.clipRect.x, this.clipRect.y, this.clipRect.width, this.clipRect.height), null);
                this.bitmap = newImage;
                this.point1.setLocation(iRect.x, iRect.y);
            }
        } else {
            this.bitmap = null;
        }
    }

    public Rectangle getClippedRectangle() {
        return this.clipRect;
    }

    public void setULLat(float value) {
        this.setLat(value);
    }

    public float getULLat() {
        return this.getLat();
    }

    public void setULLon(float value) {
        this.setLon(value);
    }

    public float getULLon() {
        return this.getLon();
    }

    public void setLRLat(float value) {
        if (this.lat2 == value) {
            return;
        }
        this.lat2 = value;
        this.setNeedToReposition(true);
    }

    public float getLRLat() {
        return this.lat2;
    }

    public void setLRLon(float value) {
        if (this.lon2 == value) {
            return;
        }
        this.lon2 = value;
        this.setNeedToReposition(true);
    }

    public float getLRLon() {
        return this.lon2;
    }

    public void setShape() {
        int w = this.point2.x - this.point1.x;
        int h = this.point2.y - this.point1.y;
        this.setShape(BasicGeometry.createBoxShape(this.point1.x, this.point1.y, w, h));
    }

    public boolean isOnMap(Projection proj) {
        Point p1 = proj.forward(this.lat, this.lon);
        Point p2 = proj.forward(this.lat2, this.lon2);
        int h = (int)(p2.getY() - p1.getY());
        int w = (int)(p2.getX() - p1.getX());
        Rectangle imageRect = new Rectangle((int)p1.getX(), (int)p1.getY(), w, h);
        proj.forward(proj.getUpperLeft(), p1);
        proj.forward(proj.getLowerRight(), p2);
        h = (int)(p2.getY() - p1.getY());
        w = (int)(p2.getX() - p1.getX());
        Rectangle mapRect = new Rectangle((int)p1.getX(), (int)p1.getY(), w, h);
        return mapRect.intersects(imageRect);
    }
}

