/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.Cubic;
import java.awt.Polygon;

public class NatCubicSpline {
    private int steps = 12;

    Cubic[] calcNaturalCubic(int n, int[] x) {
        float[] gamma = new float[n + 1];
        float[] delta = new float[n + 1];
        float[] D = new float[n + 1];
        gamma[0] = 0.5f;
        int i = 1;
        while (i < n) {
            gamma[i] = 1.0f / (4.0f - gamma[i - 1]);
            ++i;
        }
        gamma[n] = 1.0f / (2.0f - gamma[n - 1]);
        delta[0] = (float)(3 * (x[1] - x[0])) * gamma[0];
        i = 1;
        while (i < n) {
            delta[i] = ((float)(3 * (x[i + 1] - x[i - 1])) - delta[i - 1]) * gamma[i];
            ++i;
        }
        delta[n] = ((float)(3 * (x[n] - x[n - 1])) - delta[n - 1]) * gamma[n];
        D[n] = delta[n];
        i = n - 1;
        while (i >= 0) {
            D[i] = delta[i] - gamma[i] * D[i + 1];
            --i;
        }
        Cubic[] C = new Cubic[n];
        i = 0;
        while (i < n) {
            C[i] = new Cubic(x[i], D[i], (float)(3 * (x[i + 1] - x[i])) - 2.0f * D[i] - D[i + 1], (float)(2 * (x[i] - x[i + 1])) + D[i] + D[i + 1]);
            ++i;
        }
        return C;
    }

    public int[][] calc(int[] xpoints, int[] ypoints) {
        int[][] res = new int[2][0];
        if (xpoints.length > 2) {
            Cubic[] X = this.calcNaturalCubic(xpoints.length - 1, xpoints);
            Cubic[] Y = this.calcNaturalCubic(ypoints.length - 1, ypoints);
            Polygon p = new Polygon();
            p.addPoint(Math.round(X[0].eval(0.0f)), Math.round(Y[0].eval(0.0f)));
            int i = 0;
            while (i < X.length) {
                int j = 1;
                while (j <= this.steps) {
                    float u = (float)j / (float)this.steps;
                    p.addPoint(Math.round(X[i].eval(u)), Math.round(Y[i].eval(u)));
                    ++j;
                }
                ++i;
            }
            res[0] = new int[p.npoints];
            System.arraycopy(p.xpoints, 0, res[0], 0, p.npoints);
            res[1] = new int[p.npoints];
            System.arraycopy(p.ypoints, 0, res[1], 0, p.npoints);
            p = null;
        } else {
            res[0] = xpoints;
            res[1] = ypoints;
        }
        return res;
    }

    public float[] calc(float[] llpoints, float precision) {
        float[] res;
        if (llpoints.length > 4) {
            int[] xpoints = new int[llpoints.length / 2];
            int[] ypoints = new int[xpoints.length];
            int i = 0;
            int j = 0;
            while (i < llpoints.length) {
                xpoints[j] = (int)(llpoints[i] / precision);
                ypoints[j] = (int)(llpoints[i + 1] / precision);
                i += 2;
                ++j;
            }
            Cubic[] X = this.calcNaturalCubic(xpoints.length - 1, xpoints);
            Cubic[] Y = this.calcNaturalCubic(ypoints.length - 1, ypoints);
            Polygon p = new Polygon();
            p.addPoint(Math.round(X[0].eval(0.0f)), Math.round(Y[0].eval(0.0f)));
            int i2 = 0;
            while (i2 < X.length) {
                int j2 = 1;
                while (j2 <= this.steps) {
                    float u = (float)j2 / (float)this.steps;
                    p.addPoint(Math.round(X[i2].eval(u)), Math.round(Y[i2].eval(u)));
                    ++j2;
                }
                ++i2;
            }
            res = new float[p.npoints * 2];
            int i3 = 0;
            int j3 = 0;
            while (i3 < p.npoints) {
                res[j3] = (float)p.xpoints[i3] * precision;
                res[j3 + 1] = (float)p.ypoints[i3] * precision;
                ++i3;
                j3 += 2;
            }
            p = null;
        } else {
            res = llpoints;
        }
        return res;
    }

    public int getSteps() {
        return this.steps;
    }

    public void setSteps(int steps) {
        this.steps = steps > 0 ? steps : 12;
    }
}

