/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.Cubic;
import com.bbn.openmap.omGraphics.NatCubicSpline;

public class NatCubicClosedSpline
extends NatCubicSpline {
    Cubic[] calcNaturalCubic(int n, int[] x) {
        float[] w = new float[n + 1];
        float[] v = new float[n + 1];
        float[] y = new float[n + 1];
        float[] D = new float[n + 1];
        float z = 0.25f;
        v[1] = 0.25f;
        w[1] = 0.25f;
        y[0] = z * 3.0f * (float)(x[1] - x[n]);
        float H = 4.0f;
        float F = 3 * (x[0] - x[n - 1]);
        float G = 1.0f;
        int k = 1;
        while (k < n) {
            v[k + 1] = z = 1.0f / (4.0f - v[k]);
            w[k + 1] = -z * w[k];
            y[k] = z * ((float)(3 * (x[k + 1] - x[k - 1])) - y[k - 1]);
            H -= G * w[k];
            F -= G * y[k - 1];
            G = -v[k] * G;
            ++k;
        }
        y[n] = F - (G + 1.0f) * y[n - 1];
        D[n] = y[n] / (H -= (G + 1.0f) * (v[n] + w[n]));
        D[n - 1] = y[n - 1] - (v[n] + w[n]) * D[n];
        k = n - 2;
        while (k >= 0) {
            D[k] = y[k] - v[k + 1] * D[k + 1] - w[k + 1] * D[n];
            --k;
        }
        Cubic[] C = new Cubic[n + 1];
        k = 0;
        while (k < n) {
            C[k] = new Cubic(x[k], D[k], (float)(3 * (x[k + 1] - x[k])) - 2.0f * D[k] - D[k + 1], (float)(2 * (x[k] - x[k + 1])) + D[k] + D[k + 1]);
            ++k;
        }
        C[n] = new Cubic(x[n], D[n], (float)(3 * (x[0] - x[n])) - 2.0f * D[n] - D[0], (float)(2 * (x[n] - x[0])) + D[n] + D[0]);
        return C;
    }

    public int[][] calc(int[] xpoints, int[] ypoints) {
        int[] xpts = xpoints;
        int[] ypts = ypoints;
        int l = xpoints.length;
        if (xpoints.length > 2 && xpoints[0] == xpoints[l - 1] && ypoints[0] == ypoints[l - 1]) {
            xpts = new int[l - 1];
            System.arraycopy(xpoints, 0, xpts, 0, l - 1);
            ypts = new int[l - 1];
            System.arraycopy(ypoints, 0, ypts, 0, l - 1);
        }
        return super.calc(xpts, ypts);
    }

    public float[] calc(float[] llpoints, float precision) {
        float[] llpts = llpoints;
        int l = llpoints.length;
        if (l > 4 && (double)Math.abs(llpoints[0] - llpoints[l - 2]) < 1.0E-5 && (double)Math.abs(llpoints[1] - llpoints[l - 1]) < 1.0E-5) {
            llpts = new float[l - 2];
            System.arraycopy(llpoints, 0, llpts, 0, l - 2);
        }
        return super.calc(llpts, precision);
    }
}

