/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.shape.ESRIPoint;
import com.bbn.openmap.layer.shape.ESRIRecord;
import com.bbn.openmap.layer.shape.NumAndBox;
import com.bbn.openmap.layer.shape.SpatialIndex;
import com.bbn.openmap.layer.util.LayerUtils;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGeometryList;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SpatialIndexHandler
implements PropertyConsumer {
    public SpatialIndex spatialIndex;
    public String shapeFileName = null;
    public String spatialIndexFileName = null;
    public String imageURLString = null;
    protected String prettyName = null;
    protected DrawingAttributes drawingAttributes;
    protected boolean enabled = true;
    protected boolean buffered = false;
    protected String propertyPrefix;
    public static final String EnabledProperty = "enabled";
    public static final String BufferedProperty = "buffered";
    protected I18n i18n = Environment.getI18n();
    protected OMGeometryList masterList = null;
    static /* synthetic */ Class class$com$bbn$openmap$layer$shape$SpatialIndexHandler;
    static /* synthetic */ Class class$com$bbn$openmap$layer$shape$ShapeLayer;

    public SpatialIndexHandler() {
    }

    public SpatialIndexHandler(String prefix, Properties props) {
        this.setProperties(prefix, props);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("For " + this.prettyName + ":\n");
        sb.append("  Shape file name: " + this.shapeFileName + "\n");
        sb.append("  Spatal index file name: " + this.spatialIndexFileName + "\n");
        sb.append("  image URL: " + this.imageURLString + "\n");
        sb.append("  drawing attributes: " + this.drawingAttributes + "\n");
        return sb.toString();
    }

    public JComponent getGUI() {
        JPanel stuff = new JPanel();
        stuff.setBorder(BorderFactory.createRaisedBevelBorder());
        stuff.add(this.drawingAttributes.getGUI());
        JPanel checks = new JPanel(new GridLayout(0, 1));
        JCheckBox enableButton = new JCheckBox(this.i18n.get(class$com$bbn$openmap$layer$shape$SpatialIndexHandler == null ? (class$com$bbn$openmap$layer$shape$SpatialIndexHandler = SpatialIndexHandler.class$("com.bbn.openmap.layer.shape.SpatialIndexHandler")) : class$com$bbn$openmap$layer$shape$SpatialIndexHandler, "enableButton", "Show"));
        enableButton.setSelected(this.enabled);
        enableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JCheckBox jcb = (JCheckBox)ae.getSource();
                SpatialIndexHandler.this.enabled = jcb.isSelected();
            }
        });
        checks.add(enableButton);
        JCheckBox bufferButton = new JCheckBox(this.i18n.get(class$com$bbn$openmap$layer$shape$SpatialIndexHandler == null ? (class$com$bbn$openmap$layer$shape$SpatialIndexHandler = SpatialIndexHandler.class$("com.bbn.openmap.layer.shape.SpatialIndexHandler")) : class$com$bbn$openmap$layer$shape$SpatialIndexHandler, "bufferButton", "Buffer"));
        bufferButton.setSelected(this.buffered);
        bufferButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JCheckBox jcb = (JCheckBox)ae.getSource();
                SpatialIndexHandler.this.buffered = jcb.isSelected();
            }
        });
        checks.add(bufferButton);
        stuff.add(checks);
        return stuff;
    }

    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public void setProperties(Properties props) {
        this.setProperties(null, props);
    }

    public void setProperties(String prefix, Properties props) {
        this.setPropertyPrefix(prefix);
        String realPrefix = PropUtils.getScopedPropertyPrefix(this);
        this.prettyName = props.getProperty(realPrefix + "prettyName");
        this.shapeFileName = props.getProperty(realPrefix + "shapeFile");
        this.spatialIndexFileName = props.getProperty(realPrefix + "spatialIndex");
        if (this.shapeFileName != null && !this.shapeFileName.equals("")) {
            this.spatialIndex = this.spatialIndexFileName != null && !this.spatialIndexFileName.equals("") ? SpatialIndex.locateAndSetShapeData(this.shapeFileName, this.spatialIndexFileName) : SpatialIndex.locateAndSetShapeData(this.shapeFileName);
            this.imageURLString = props.getProperty(realPrefix + "pointImageURL");
            try {
                if (this.imageURLString != null && !this.imageURLString.equals("")) {
                    URL imageURL = LayerUtils.getResourceOrFileOrURL(this, this.imageURLString);
                    ImageIcon imageIcon = new ImageIcon(imageURL);
                    this.spatialIndex.setPointIcon(imageIcon);
                }
            }
            catch (MalformedURLException murle) {
                Debug.error("MultiShapeLayer.setProperties(" + realPrefix + ": point image URL not so good: \n\t" + this.imageURLString);
            }
            catch (NullPointerException npe) {
                Debug.error("Can't access icon image: \n" + this.imageURLString);
            }
        } else {
            Debug.error(realPrefix + ": One of the following properties was null or empty:");
            Debug.error("\t" + realPrefix + "shapeFile");
            Debug.error("\t" + realPrefix + "spatialIndex");
        }
        props.put("spatialIndex", "Location of Spatial Index file - .ssx (File, URL or relative file path).");
        this.drawingAttributes = new DrawingAttributes(realPrefix, props);
        this.enabled = LayerUtils.booleanFromProperties(props, realPrefix + EnabledProperty, this.enabled);
        this.buffered = LayerUtils.booleanFromProperties(props, realPrefix + BufferedProperty, this.buffered);
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + "shapeFile", this.shapeFileName == null ? "" : this.shapeFileName);
        props.put(prefix + "spatialIndex", this.spatialIndexFileName == null ? "" : this.spatialIndexFileName);
        props.put(prefix + "pointImageURL", this.imageURLString == null ? "" : this.imageURLString);
        if (this.drawingAttributes != null) {
            this.drawingAttributes.getProperties(props);
        } else {
            DrawingAttributes da = (DrawingAttributes)DrawingAttributes.DEFAULT.clone();
            da.setPropertyPrefix(prefix);
            da.getProperties(props);
        }
        props.put(prefix + EnabledProperty, new Boolean(this.enabled).toString());
        props.put(prefix + BufferedProperty, new Boolean(this.buffered).toString());
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String interString = this.i18n.get(class$com$bbn$openmap$layer$shape$ShapeLayer == null ? (class$com$bbn$openmap$layer$shape$ShapeLayer = SpatialIndexHandler.class$("com.bbn.openmap.layer.shape.ShapeLayer")) : class$com$bbn$openmap$layer$shape$ShapeLayer, "shapeFile", 3, "Location of Shape file - .shp (File, URL or relative file path).");
        props.put("shapeFile", interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$shape$ShapeLayer == null ? (class$com$bbn$openmap$layer$shape$ShapeLayer = SpatialIndexHandler.class$("com.bbn.openmap.layer.shape.ShapeLayer")) : class$com$bbn$openmap$layer$shape$ShapeLayer, "shapeFile", "shapeFile");
        props.put("shapeFile.label", interString);
        props.put("shapeFile.editor", "com.bbn.openmap.util.propertyEditor.FUPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$shape$ShapeLayer == null ? (class$com$bbn$openmap$layer$shape$ShapeLayer = SpatialIndexHandler.class$("com.bbn.openmap.layer.shape.ShapeLayer")) : class$com$bbn$openmap$layer$shape$ShapeLayer, "spatialIndex", 3, "Location of Spatial Index file - .ssx (File, URL or relative file path).");
        props.put("spatialIndex", interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$shape$ShapeLayer == null ? (class$com$bbn$openmap$layer$shape$ShapeLayer = SpatialIndexHandler.class$("com.bbn.openmap.layer.shape.ShapeLayer")) : class$com$bbn$openmap$layer$shape$ShapeLayer, "spatialIndex", "spatialIndex");
        props.put("spatialIndex.label", interString);
        props.put("spatialIndex.editor", "com.bbn.openmap.util.propertyEditor.FUPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$shape$ShapeLayer == null ? (class$com$bbn$openmap$layer$shape$ShapeLayer = SpatialIndexHandler.class$("com.bbn.openmap.layer.shape.ShapeLayer")) : class$com$bbn$openmap$layer$shape$ShapeLayer, "pointImageURL", 3, "Image file to use for map location of point data (optional).");
        props.put("pointImageURL", interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$shape$ShapeLayer == null ? (class$com$bbn$openmap$layer$shape$ShapeLayer = SpatialIndexHandler.class$("com.bbn.openmap.layer.shape.ShapeLayer")) : class$com$bbn$openmap$layer$shape$ShapeLayer, "pointImageURL", "pointImageURL");
        props.put("pointImageURL.label", interString);
        props.put("pointImageURL.editor", "com.bbn.openmap.util.propertyEditor.FUPropertyEditor");
        if (this.drawingAttributes != null) {
            this.drawingAttributes.getPropertyInfo(props);
        } else {
            DrawingAttributes.DEFAULT.getPropertyInfo(props);
        }
        interString = this.i18n.get(class$com$bbn$openmap$layer$shape$SpatialIndexHandler == null ? (class$com$bbn$openmap$layer$shape$SpatialIndexHandler = SpatialIndexHandler.class$("com.bbn.openmap.layer.shape.SpatialIndexHandler")) : class$com$bbn$openmap$layer$shape$SpatialIndexHandler, EnabledProperty, 3, "Show file contents");
        props.put(EnabledProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$shape$SpatialIndexHandler == null ? (class$com$bbn$openmap$layer$shape$SpatialIndexHandler = SpatialIndexHandler.class$("com.bbn.openmap.layer.shape.SpatialIndexHandler")) : class$com$bbn$openmap$layer$shape$SpatialIndexHandler, EnabledProperty, EnabledProperty);
        props.put("enabled.label", interString);
        props.put("enabled.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$shape$SpatialIndexHandler == null ? (class$com$bbn$openmap$layer$shape$SpatialIndexHandler = SpatialIndexHandler.class$("com.bbn.openmap.layer.shape.SpatialIndexHandler")) : class$com$bbn$openmap$layer$shape$SpatialIndexHandler, BufferedProperty, 3, "Read and hold entire file contents (may be faster)");
        props.put(BufferedProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$shape$SpatialIndexHandler == null ? (class$com$bbn$openmap$layer$shape$SpatialIndexHandler = SpatialIndexHandler.class$("com.bbn.openmap.layer.shape.SpatialIndexHandler")) : class$com$bbn$openmap$layer$shape$SpatialIndexHandler, BufferedProperty, BufferedProperty);
        props.put("buffered.label", interString);
        props.put("buffered.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        return props;
    }

    public OMGraphicList getGraphics(double xmin, double ymin, double xmax, double ymax) throws IOException, FormatException {
        return this.getGraphics(xmin, ymin, xmax, ymax, null);
    }

    public OMGraphicList getGraphics(double xmin, double ymin, double xmax, double ymax, OMGraphicList list) throws IOException, FormatException {
        if (list == null) {
            list = new OMGraphicList();
        }
        if (!this.buffered) {
            if (this.masterList != null) {
                this.masterList = null;
            }
            OMGeometryList geometrys = new OMGeometryList();
            this.drawingAttributes.setTo(geometrys);
            list.add(geometrys);
            ESRIRecord[] records = this.spatialIndex.locateRecords(xmin, ymin, xmax, ymax);
            int nRecords = records.length;
            int i = 0;
            while (i < nRecords) {
                ESRIRecord rec = records[i];
                OMGeometry geom = records[i].addOMGeometry(geometrys);
                geom.setAppObject(new NumAndBox(rec.getRecordNumber(), rec.getBoundingBox()));
                ++i;
            }
        } else {
            if (this.masterList == null) {
                this.getWholePlanet();
            }
            this.drawingAttributes.setTo(this.masterList);
            list.add(this.masterList);
            Iterator iterator = this.masterList.iterator();
            while (iterator.hasNext()) {
                OMGeometry geom = (OMGeometry)iterator.next();
                Object obj = geom.getAppObject();
                geom.setVisible(true);
                if (obj == null || !(obj instanceof NumAndBox)) continue;
                NumAndBox nab = (NumAndBox)obj;
                ESRIPoint min = nab.getBoundingBox().min;
                ESRIPoint max = nab.getBoundingBox().max;
                if (SpatialIndex.intersects(xmin, ymin, xmax, ymax, min.x, min.y, max.x, max.y)) continue;
                geom.setVisible(false);
            }
        }
        return list;
    }

    protected OMGraphicList RecordList(ESRIRecord rec, DrawingAttributes drawingAttributes) {
        int recNumber = rec.getRecordNumber();
        OMGraphicList recList = new OMGraphicList(10);
        if (drawingAttributes == null) {
            drawingAttributes = new DrawingAttributes();
        }
        rec.addOMGraphics(recList, drawingAttributes);
        recList.setAppObject(new Integer(recNumber));
        return recList;
    }

    protected void getWholePlanet() throws FormatException {
        this.masterList = new OMGeometryList();
        if (Debug.debugging("shape")) {
            Debug.output(this.prettyName + "|SpatialIndexHolder.getWholePlanet(): fetching all graphics.");
        }
        try {
            ESRIRecord[] records = this.spatialIndex.locateRecords(-180.0, -90.0, 180.0, 90.0);
            int nRecords = records.length;
            int i = 0;
            while (i < nRecords) {
                OMGeometry geom = records[i].addOMGeometry(this.masterList);
                geom.setAppObject(new NumAndBox(records[i].getRecordNumber(), records[i].getBoundingBox()));
                ++i;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
        catch (NullPointerException npe) {
            Debug.error(this.prettyName + "|SpatialIndexHolder can't access files.");
            return;
        }
        if (Debug.debugging("shape")) {
            Debug.output(this.prettyName + "|SpatialIndexHolder.getWholePlanet(): finished fetch.");
        }
    }

    public void setPrettyName(String set) {
        this.prettyName = set;
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public void setBuffered(boolean set) {
        this.buffered = set;
    }

    public boolean getBuffered() {
        return this.buffered;
    }

    public void setDrawingAttributes(DrawingAttributes set) {
        this.drawingAttributes = set;
    }

    public DrawingAttributes getDrawingAttributes() {
        return this.drawingAttributes;
    }

    public void setEnabled(boolean set) {
        this.enabled = set;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

