/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image;

import com.bbn.openmap.image.AbstractImageFormatter;
import com.bbn.openmap.image.AcmeJPEGHelper;
import com.bbn.openmap.image.ImageFormatter;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Properties;

public class AcmeJPEGFormatter
extends AbstractImageFormatter {
    public static final String QualityProperty = "imagequality";
    public static final int DEFAULT_IMAGE_QUALITY = 80;
    protected int imageQuality = 80;

    public ImageFormatter makeClone() {
        AcmeJPEGFormatter formatter = new AcmeJPEGFormatter();
        formatter.setImageQuality(this.getImageQuality());
        return formatter;
    }

    public void setProperties(String prefix, Properties props) {
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.imageQuality = PropUtils.intFromProperties(props, prefix + QualityProperty, this.imageQuality);
        if (Debug.debugging("image")) {
            Debug.output("AcmeJPEGFormatter setting image quality to: " + this.imageQuality);
        }
    }

    public int getImageQuality() {
        return this.imageQuality;
    }

    public void setImageQuality(int quality) {
        this.imageQuality = quality;
    }

    public byte[] formatImage(BufferedImage bi) {
        try {
            return AcmeJPEGHelper.encodeJPEG(bi, this.imageQuality);
        }
        catch (IOException ioe) {
            Debug.error("AcmeJPEGFormatter caught IOException formatting image!");
            return new byte[0];
        }
    }

    public String getFormatLabel() {
        return "JPEG";
    }
}

