/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.Layer;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.image.BufferedImageHelper;
import com.bbn.openmap.image.ImageFormatter;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.ProjectionFactory;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;

public abstract class AbstractImageFormatter
implements ImageFormatter,
PropertyConsumer,
PropertyChangeListener {
    protected BufferedImage bufferedImage;
    protected String propertiesPrefix;
    protected Layer[] layers = null;

    public void setProperties(String prefix, Properties props) {
    }

    public abstract byte[] formatImage(BufferedImage var1);

    public abstract ImageFormatter makeClone();

    public byte[] getImageFromMapBean(MapBean map) {
        return this.getImageFromMapBean(map, -1, -1, false);
    }

    public byte[] getImageFromMapBean(MapBean map, int width, int height) {
        return this.getImageFromMapBean(map, width, height, true);
    }

    public byte[] getImageFromMapBean(MapBean map, int width, int height, boolean scaleImage) {
        boolean needToScale;
        if (map == null) {
            return new byte[0];
        }
        Proj proj = (Proj)map.getProjection();
        boolean bl = needToScale = width != proj.getWidth() || height != proj.getHeight();
        if (Debug.debugging("formatter")) {
            Debug.output("AIF: called with w:" + width + ", h:" + height + ", need to scale (" + needToScale + ")" + " and scaleImage (" + scaleImage + ")");
        }
        if (width == -1) {
            width = proj.getWidth();
        }
        if (height == -1) {
            height = proj.getHeight();
        }
        Graphics graphics = this.getGraphics(width, height);
        if (!needToScale) {
            if (Debug.debugging("formatter")) {
                Debug.output("AIF: don't need to scale, painting normally.");
            }
            map.paintAll(graphics);
        } else {
            map.addPropertyChangeListener(this);
            LatLonPoint cp = new LatLonPoint(map.getCenter());
            double scaleMod = 1.0;
            if (scaleImage) {
                if (Debug.debugging("formatter")) {
                    Debug.output("AIF: scaling image to w:" + width + ", h:" + height);
                }
                double area1 = (double)proj.getHeight() * (double)proj.getWidth();
                double area2 = (double)height * (double)width;
                scaleMod = Math.sqrt(area1 / area2);
            }
            Proj tp = (Proj)ProjectionFactory.makeProjection(map.getProjection().getClass(), cp.getLatitude(), cp.getLongitude(), map.getScale() * (float)scaleMod, width, height);
            tp.drawBackground((Graphics2D)graphics, map.getBckgrnd());
            if (this.layers != null) {
                int i = this.layers.length - 1;
                while (i >= 0) {
                    this.layers[i].renderDataForProjection(tp, graphics);
                    if (Debug.debugging("formatter")) {
                        Debug.output("AbstractImageFormatter: rendering " + this.layers[i].getName());
                    }
                    this.layers[i].setProjection(proj);
                    --i;
                }
            } else {
                Debug.output("AbstractImageFormatter can't get layers from map!");
            }
            map.removePropertyChangeListener(this);
            this.layers = null;
        }
        return this.getImageBytes();
    }

    public Graphics getGraphics(int width, int height) {
        return this.getGraphics(width, height, 1);
    }

    public Graphics getGraphics(int width, int height, int imageType) {
        this.bufferedImage = new BufferedImage(width, height, imageType);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Graphics2D g = ge.createGraphics(this.bufferedImage);
        g.setClip(0, 0, width, height);
        return g;
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public void setBufferedImage(BufferedImage bi) {
        this.bufferedImage = bi;
    }

    public BufferedImage getScaledBufferedImage(int scaledWidth, int scaledHeight) {
        if (this.bufferedImage == null) {
            return null;
        }
        if (Debug.debugging("formatter")) {
            Debug.output("Formatter: scaling image to : " + scaledWidth + ", " + scaledHeight);
        }
        Image image = this.bufferedImage.getScaledInstance(scaledWidth, scaledHeight, 4);
        if (Debug.debugging("formatter")) {
            Debug.output("Formatter: creating scaled image...");
        }
        try {
            BufferedImage buffi;
            this.bufferedImage = buffi = BufferedImageHelper.getBufferedImage(image, 0, 0, -1, -1);
        }
        catch (InterruptedException ie) {
            Debug.error("Formatter: Something bad happened during scaling! \n" + ie);
        }
        if (Debug.debugging("formatter")) {
            Debug.output("Formatter: image successfully scaled");
        }
        return this.bufferedImage;
    }

    public byte[] getImageBytes() {
        BufferedImage bi = this.getBufferedImage();
        if (bi == null) {
            return new byte[0];
        }
        Debug.message("formatter", "Formatter: creating formatted image bytes...");
        return this.formatImage(bi);
    }

    public byte[] getScaledImageBytes(int scaledWidth, int scaledHeight) {
        BufferedImage bi = this.getScaledBufferedImage(scaledWidth, scaledHeight);
        if (bi == null) {
            return new byte[0];
        }
        Debug.message("formatter", "Formatter: creating formatted image bytes...");
        return this.formatImage(bi);
    }

    public void setProperties(Properties props) {
        this.setProperties(null, props);
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        return list;
    }

    public void setPropertyPrefix(String prefix) {
        this.propertiesPrefix = prefix;
    }

    public String getPropertyPrefix() {
        return this.propertiesPrefix;
    }

    public void propertyChange(PropertyChangeEvent pce) {
        String propName = pce.getPropertyName();
        if (propName == "MapBean.layers") {
            this.layers = (Layer[])pce.getNewValue();
        }
    }
}

