/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.gui.OMToolComponent;
import com.bbn.openmap.proj.ProjectionStack;
import com.bbn.openmap.proj.ProjectionStackTrigger;
import com.bbn.openmap.util.Debug;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class ProjectionStackTool
extends OMToolComponent
implements ProjectionStackTrigger {
    protected Vector listeners;
    protected JButton backButton;
    protected JButton forwardButton;
    protected static transient String backName = "backproj.gif";
    protected static transient String forwardName = "forwardproj.gif";
    protected static transient String dimBackName = "dimbackproj.gif";
    protected static transient String dimForwardName = "dimforwardproj.gif";
    protected boolean dimBackButton = true;
    protected boolean dimForwardButton = true;
    ImageIcon backIcon;
    ImageIcon dimBackIcon;
    ImageIcon forwardIcon;
    ImageIcon dimForwardIcon;
    static /* synthetic */ Class class$com$bbn$openmap$gui$ProjectionStackTool;

    public ProjectionStackTool() {
        this.setKey("projectionstacktool");
        this.resetButtons(!this.dimBackButton, !this.dimForwardButton);
        this.add(this.backButton);
        this.add(this.forwardButton);
    }

    public void addActionListener(ActionListener al) {
        if (this.backButton != null && this.forwardButton != null) {
            this.backButton.addActionListener(al);
            this.forwardButton.addActionListener(al);
        } else {
            if (this.listeners == null) {
                this.listeners = new Vector();
            }
            this.listeners.add(al);
        }
    }

    public void removeActionListener(ActionListener al) {
        if (this.backButton != null && this.forwardButton != null) {
            this.backButton.removeActionListener(al);
            this.forwardButton.removeActionListener(al);
        } else if (this.listeners != null) {
            this.listeners.remove(al);
        }
    }

    public void updateProjectionStackStatus(boolean containsBackProjections, boolean containsForwardProjections) {
        this.dimBackButton = !containsBackProjections;
        this.dimForwardButton = !containsForwardProjections;
        this.resetButtons(containsBackProjections, containsForwardProjections);
    }

    public void resetButtons(boolean enableBackButton, boolean enableForwardButton) {
        int i;
        int size;
        ImageIcon active;
        URL url;
        if (this.backIcon == null) {
            url = this.getClass().getResource(backName);
            this.backIcon = new ImageIcon(url);
        }
        if (this.dimBackIcon == null) {
            url = this.getClass().getResource(dimBackName);
            this.dimBackIcon = new ImageIcon(url);
        }
        if (this.forwardIcon == null) {
            url = this.getClass().getResource(forwardName);
            this.forwardIcon = new ImageIcon(url);
        }
        if (this.dimForwardIcon == null) {
            url = this.getClass().getResource(dimForwardName);
            this.dimForwardIcon = new ImageIcon(url);
        }
        String disabled = " (" + this.i18n.get(class$com$bbn$openmap$gui$ProjectionStackTool == null ? (class$com$bbn$openmap$gui$ProjectionStackTool = ProjectionStackTool.class$("com.bbn.openmap.gui.ProjectionStackTool")) : class$com$bbn$openmap$gui$ProjectionStackTool, "disabled", "disabled") + ")";
        String toolTip = this.i18n.get(class$com$bbn$openmap$gui$ProjectionStackTool == null ? (class$com$bbn$openmap$gui$ProjectionStackTool = ProjectionStackTool.class$("com.bbn.openmap.gui.ProjectionStackTool")) : class$com$bbn$openmap$gui$ProjectionStackTool, "backTip", "Go back to previous projection");
        if (enableBackButton) {
            active = this.backIcon;
        } else {
            active = this.dimBackIcon;
            toolTip = toolTip + " " + disabled;
        }
        if (this.backButton == null) {
            this.backButton = new JButton(active);
            this.backButton.setMargin(new Insets(0, 0, 0, 0));
            this.backButton.setBorderPainted(false);
            this.backButton.setActionCommand("backProjection");
            if (this.listeners != null) {
                size = this.listeners.size();
                i = 0;
                while (i < size) {
                    this.backButton.addActionListener((ActionListener)this.listeners.elementAt(i));
                    ++i;
                }
            }
        } else {
            this.backButton.setIcon(active);
        }
        this.backButton.setToolTipText(toolTip);
        toolTip = this.i18n.get(class$com$bbn$openmap$gui$ProjectionStackTool == null ? (class$com$bbn$openmap$gui$ProjectionStackTool = ProjectionStackTool.class$("com.bbn.openmap.gui.ProjectionStackTool")) : class$com$bbn$openmap$gui$ProjectionStackTool, "forwardTip", "Go forward to next projection");
        if (enableForwardButton) {
            active = this.forwardIcon;
        } else {
            active = this.dimForwardIcon;
            toolTip = toolTip + " " + disabled;
        }
        if (this.forwardButton == null) {
            this.forwardButton = new JButton(active);
            this.forwardButton.setMargin(new Insets(0, 0, 0, 0));
            this.forwardButton.setBorderPainted(false);
            this.forwardButton.setActionCommand("forwardProjection");
            if (this.listeners != null) {
                size = this.listeners.size();
                i = 0;
                while (i < size) {
                    this.forwardButton.addActionListener((ActionListener)this.listeners.elementAt(i));
                    ++i;
                }
            }
        } else {
            this.forwardButton.setIcon(active);
        }
        this.forwardButton.setToolTipText(toolTip);
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof ProjectionStack) {
            Debug.message("projectionstacktrigger", "ProjectionStackTrigger adding a ProjectionStack");
            ((ProjectionStack)someObj).addProjectionStackTrigger(this);
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof ProjectionStack) {
            Debug.message("projectionstacktrigger", "ProjectionStackTrigger removing a ProjectionStack");
            ((ProjectionStack)someObj).removeProjectionStackTrigger(this);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

