/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.graphicLoader.netmap;

import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.graphicLoader.netmap.ChoiceItem;
import com.bbn.openmap.graphicLoader.netmap.ChoiceList;
import com.bbn.openmap.graphicLoader.netmap.NetMapConstants;
import com.bbn.openmap.graphicLoader.netmap.NetMapListener;
import com.bbn.openmap.graphicLoader.netmap.NetMapListenerSupport;
import com.bbn.openmap.graphicLoader.netmap.NetMapReader;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.PropUtils;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class NetMapConnector
implements ActionListener,
NetMapConstants,
PropertyConsumer {
    public static final String ServerConnectCmd = "Connect";
    public static final String ServerDisconnectCmd = "Disconnect";
    public static final String LoadViewCmd = "Load View";
    public static final String GetViewsCmd = "Get Network Views";
    public static final String ServerProperty = "server";
    public static final String PortProperty = "port";
    public static final String DefaultViewProperty = "defaultView";
    public static final String STATUS_CONNECTING = "  Connecting  ";
    public static final String STATUS_CONNECTED = "   Connected  ";
    public static final String STATUS_IDLE = "  Idle  ";
    private JPanel serverPanel = null;
    private JTextField serverAddrField = null;
    private JTextField serverPortField = null;
    private JLabel connectedStatus = null;
    private Choice viewChoice = null;
    private ChoiceList viewList = null;
    private JButton controlButton = null;
    protected String server = "localhost";
    protected String port = "5554";
    protected String defaultView = null;
    protected String propertyPrefix = null;
    NetMapReader reader = null;
    NetMapListenerSupport listenerSupport = new NetMapListenerSupport(this);

    public void setServer(String sName) {
        this.server = sName;
    }

    public String getServer() {
        return this.server;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getPort() {
        return this.port;
    }

    public void setDefaultView(String view) {
        this.defaultView = view;
    }

    public String getDefaultView() {
        return this.defaultView;
    }

    public void addNetMapListener(NetMapListener nml) {
        this.listenerSupport.addNetMapListener(nml);
    }

    public void removeNetMapListener(NetMapListener nml) {
        this.listenerSupport.removeNetMapListener(nml);
    }

    public void clearNetMapListeners() {
        this.listenerSupport.clearNetMapListeners();
    }

    protected void distributeEvent(Properties netmapProps) {
        this.listenerSupport.fireNetMapEvent(netmapProps);
    }

    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        this.server = this.serverAddrField.getText();
        this.port = this.serverPortField.getText();
        if (cmd == GetViewsCmd) {
            this.connectedStatus.setText(STATUS_CONNECTING);
            this.viewList = this.getViews();
            if (this.viewList == null) {
                Debug.message("netmap", "Can't get view list from " + this.server + ":" + this.port);
                this.disconnect();
            }
        } else if (cmd == ServerDisconnectCmd) {
            Debug.message("netmap", "Disconnecting from server " + this.server + ":" + this.port);
            this.disconnect();
        } else if (cmd == LoadViewCmd) {
            ChoiceItem ci = this.viewList.get(this.viewChoice.getSelectedItem());
            if (ci == null) {
                this.disconnect();
                return;
            }
            String view = ((String)ci.value()).trim();
            Debug.message("netmap", "Loading view " + view);
            this.connect(view);
        }
    }

    protected void connectionUp() {
        if (this.connectedStatus != null) {
            this.connectedStatus.setText(STATUS_CONNECTED);
            this.connectedStatus.setBackground(Color.green);
        }
    }

    protected void connectionDown() {
        if (this.connectedStatus != null) {
            this.connectedStatus.setText(STATUS_IDLE);
            this.connectedStatus.setBackground(Color.red);
        }
    }

    public void disconnect() {
        if (this.reader != null) {
            this.reader.shutdown();
        }
        this.reader = null;
        if (this.serverPanel != null) {
            this.serverAddrField.setEnabled(true);
            this.serverPortField.setEnabled(true);
            this.viewChoice.setEnabled(false);
            this.controlButton.setText(GetViewsCmd);
            this.controlButton.setActionCommand(GetViewsCmd);
            this.connectedStatus.setText(STATUS_IDLE);
        }
    }

    public ChoiceList getViews() {
        ChoiceList views = null;
        try {
            this.reader = new NetMapReader(this.server, this.port, this);
        }
        catch (IOException e) {
            Debug.message("netmap", "Can't start reader: " + e);
        }
        Debug.message("netmap", "Checking for views...");
        if (this.reader != null) {
            views = this.reader.getViewList(this.server, this.port);
        }
        if (this.serverPanel != null) {
            this.viewChoice.removeAll();
            if (views != null) {
                int i = 0;
                while (i < views.size()) {
                    if (Debug.debugging("netmap")) {
                        Debug.output("Adding view: " + views.labelAt(i));
                    }
                    this.viewChoice.add(views.labelAt(i));
                    ++i;
                }
                this.serverAddrField.setEnabled(false);
                this.serverPortField.setEnabled(false);
                this.viewChoice.setEnabled(true);
                this.controlButton.setText(LoadViewCmd);
                this.controlButton.setActionCommand(LoadViewCmd);
            }
        }
        return views;
    }

    public void connect(String view) {
        try {
            this.reader = new NetMapReader(this.server, this.port, this, view);
            this.reader.start();
            if (this.serverPanel != null) {
                this.serverAddrField.setEnabled(false);
                this.serverPortField.setEnabled(false);
                this.controlButton.setText(ServerDisconnectCmd);
                this.controlButton.setActionCommand(ServerDisconnectCmd);
            }
        }
        catch (IOException e) {
            Debug.message("netmap", "Can't start reader: " + e);
            this.disconnect();
        }
    }

    public void reset() {
        this.disconnect();
        Properties rp = new Properties();
        rp.setProperty("cmd", "clear");
        this.distributeEvent(rp);
        if (this.serverPanel != null) {
            this.viewChoice.removeAll();
            this.connectedStatus.setText(STATUS_IDLE);
        }
    }

    public Component getGUI() {
        if (this.serverPanel != null) {
            return this.serverPanel;
        }
        this.serverAddrField = new JTextField(this.server);
        this.serverPortField = new JTextField(this.port);
        JTextArea serverViewList = new JTextArea();
        JPanel serverAddrPanel = new JPanel(new GridLayout(0, 2));
        serverAddrPanel.add(new JLabel("Name or IP Addr: "));
        serverAddrPanel.add(this.serverAddrField);
        JPanel serverPortPanel = new JPanel(new GridLayout(0, 2));
        serverPortPanel.add(new JLabel("Port: "));
        serverPortPanel.add(this.serverPortField);
        JPanel statusPanel = PaletteHelper.createHorizontalPanel("Server Connection");
        this.connectedStatus = new JLabel(STATUS_IDLE);
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                NetMapConnector.this.reset();
            }
        });
        statusPanel.add(this.connectedStatus);
        statusPanel.add(resetButton);
        JPanel netmapPanel = PaletteHelper.createVerticalPanel("Server Settings");
        netmapPanel.add(serverAddrPanel);
        netmapPanel.add(serverPortPanel);
        this.viewChoice = new Choice();
        this.viewList = new ChoiceList();
        this.viewChoice.setEnabled(false);
        this.controlButton = new JButton(GetViewsCmd);
        this.controlButton.setActionCommand(GetViewsCmd);
        this.controlButton.addActionListener(this);
        JPanel viewPanel = PaletteHelper.createVerticalPanel(null);
        viewPanel.add(new JLabel("Available Views"));
        viewPanel.add(this.viewChoice);
        viewPanel.add(this.controlButton);
        this.serverPanel = new JPanel();
        Box box = Box.createVerticalBox();
        box.add(netmapPanel);
        box.add(statusPanel);
        box.add(viewPanel);
        this.serverPanel.add(box);
        return this.serverPanel;
    }

    public void setProperties(Properties setList) {
        this.setProperties(null, setList);
    }

    public void setProperties(String prefix, Properties setList) {
        this.setPropertyPrefix(prefix);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.server = setList.getProperty(prefix + ServerProperty);
        if (this.server == null) {
            this.server = "localhost";
        }
        this.port = setList.getProperty(prefix + PortProperty);
        if (this.port == null) {
            this.port = "5554";
        }
    }

    public Properties getProperties(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        list.put(prefix + ServerProperty, this.server);
        list.put(prefix + PortProperty, this.port);
        return list;
    }

    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        list.put(ServerProperty, "The hostname or IP for NetMap server");
        list.put(PortProperty, "The port number for NetMap server");
        return list;
    }

    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }
}

