/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task.dataSetBrowser;

import edu.sc.seis.fissuresUtil.dataset.DataSetChangeEvent;
import edu.sc.seis.fissuresUtil.dataset.DataSetChangeListener;
import edu.sc.seis.fissuresUtil.dataset.Organizer;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.task.dataSetBrowser.ParameterTreeNode;
import edu.sc.seis.gee.task.dataSetBrowser.SeismogramTreeNode;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class DataSetTreeModel
implements TreeModel {
    CommonAccess commonAccess;
    TreeModelListener tmListen = null;
    boolean showParams = false;
    static Logger logger = Logger.getLogger(DataSetTreeModel.class);

    public DataSetTreeModel() {
        this(false);
    }

    public DataSetTreeModel(boolean showParams) {
        this.showParams = showParams;
        this.commonAccess = CommonAccess.getCommonAccess();
        Organizer organizer = this.commonAccess.getOrganizer();
        organizer.addDataSetChangeListener(new DataSetChangeListener(){

            public void datasetChanged(DataSetChangeEvent e) {
                logger.debug((Object)"  datasetChanged");
                if (DataSetTreeModel.this.tmListen != null) {
                    Object[] tmp = new Object[]{DataSetTreeModel.this.getRoot()};
                    TreeModelEvent tme = new TreeModelEvent((Object)DataSetTreeModel.this, tmp);
                    DataSetTreeModel.this.tmListen.treeStructureChanged(tme);
                }
            }

            public void datasetAdded(DataSetChangeEvent e) {
                String[] names = ((DataSet)DataSetTreeModel.this.getRoot()).getDataSetNames();
                logger.debug((Object)("  datasetAdded names.length=" + names.length));
                for (int i = 0; i < names.length; ++i) {
                    logger.debug((Object)("names[" + i + "] = " + names[i]));
                }
                if (DataSetTreeModel.this.tmListen != null) {
                    logger.debug((Object)"sending notice to tmListen");
                    Object[] tmp = new Object[]{DataSetTreeModel.this.getRoot()};
                    TreeModelEvent tme = new TreeModelEvent((Object)DataSetTreeModel.this, tmp);
                    DataSetTreeModel.this.tmListen.treeNodesInserted(tme);
                }
            }

            public void datasetRemoved(DataSetChangeEvent e) {
                logger.debug((Object)"  datasetRemoved");
                if (DataSetTreeModel.this.tmListen != null) {
                    Object[] tmp = new Object[]{DataSetTreeModel.this.getRoot()};
                    TreeModelEvent tme = new TreeModelEvent((Object)DataSetTreeModel.this, tmp);
                    DataSetTreeModel.this.tmListen.treeNodesRemoved(tme);
                }
            }
        });
    }

    @Override
    public Object getRoot() {
        return this.commonAccess.getDataSetRoot();
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof DataSet) {
            String[] params;
            DataSet ds = (DataSet)parent;
            String[] childDataSets = ds.getDataSetNames();
            if (index < childDataSets.length) {
                return ds.getDataSet(childDataSets[index]);
            }
            String[] dseismogramNames = ds.getDataSetSeismogramNames();
            if (index < dseismogramNames.length + childDataSets.length) {
                return new SeismogramTreeNode(ds.getDataSetSeismogram(dseismogramNames[index - childDataSets.length]));
            }
            if (this.showParams && index < childDataSets.length + (params = ds.getParameterNames()).length + dseismogramNames.length) {
                return new ParameterTreeNode(ds, params[index - childDataSets.length - dseismogramNames.length]);
            }
        }
        return "BUG: can't find index " + index;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof DataSet) {
            DataSet ds = (DataSet)parent;
            String[] childDataSets = ds.getDataSetNames();
            String[] dseismogramNames = ds.getDataSetSeismogramNames();
            if (this.showParams) {
                String[] params = ds.getParameterNames();
                return childDataSets.length + params.length + dseismogramNames.length;
            }
            return childDataSets.length + dseismogramNames.length;
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        return !(node instanceof DataSet);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof DataSet) {
            DataSet ds = (DataSet)parent;
            String[] childDataSets = ds.getDataSetNames();
            if (child instanceof DataSet) {
                for (int i = 0; i < childDataSets.length; ++i) {
                    if (!child.equals(childDataSets[i])) continue;
                    return i;
                }
            }
            String[] dseismogramNames = ds.getDataSetSeismogramNames();
            String[] params = ds.getParameterNames();
            for (int i = 0; i < params.length; ++i) {
                if (!child.equals(params[i])) continue;
                return childDataSets.length + dseismogramNames.length + i;
            }
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.tmListen = l;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }
}

