/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task.dataSetBrowser;

import edu.sc.seis.fissuresUtil.display.ParseRegions;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.gee.task.dataSetBrowser.ParameterTreeNode;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.log4j.Logger;

public class DataSetTreeCellRenderer
extends DefaultTreeCellRenderer {
    public static ParseRegions feRegions = ParseRegions.getInstance();
    private static Logger logger = Logger.getLogger(DataSetTreeCellRenderer.class);

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component orig = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof DataSet && orig instanceof JLabel) {
            DataSet ds = (DataSet)value;
            String labelStr = "" + ds.getName();
            if (labelStr.length() == 0) {
                labelStr = "ID:" + ds.getId();
            }
            JLabel dsLabel = (JLabel)orig;
            dsLabel.setText(labelStr);
            return dsLabel;
        }
        if (value instanceof ParameterTreeNode && orig instanceof JLabel) {
            ParameterTreeNode paramNode = (ParameterTreeNode)value;
            JLabel paramLabel = (JLabel)orig;
            if (paramNode.getName().equals("edu.sc.seis.fissuresUtil.xml#EVENT")) {
                paramLabel.setText("Event");
            } else if (paramNode.getName().startsWith("edu.sc.seis.fissuresUtil.xml#CHANNEL_")) {
                paramLabel.setText("Channel for " + paramNode.getName().substring("edu.sc.seis.fissuresUtil.xml#CHANNEL_".length()));
            }
            return paramLabel;
        }
        return orig;
    }
}

