/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.fissuresUtil.display.drawable.DrawableSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.FilterTarget;
import edu.sc.seis.gee.task.Task;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ToggleOriginalTask
implements Task {
    private Map params;
    private boolean visible = false;
    private FilterTarget[] destinations;
    Logger logger = Logger.getLogger(ToggleOriginalTask.class);

    @Override
    public void configure(Map params) throws ConfigurationException {
        this.params = params;
        CommonAccess ca = CommonAccess.getCommonAccess();
        if (params.containsKey("filterTargets")) {
            String destinationId = (String)params.get("filterTargets");
            StringTokenizer destinationTokenizer = new StringTokenizer(destinationId, ",");
            int tokens = destinationTokenizer.countTokens();
            this.destinations = new FilterTarget[tokens];
            for (int i = 0; i < tokens; ++i) {
                String destID = destinationTokenizer.nextToken();
                this.destinations[i] = (FilterTarget)((Object)ca.getTaskAction(destID).getTask());
            }
        } else {
            throw new ConfigurationException("toggle original task requires a colSeisDisplay in the configuration");
        }
    }

    @Override
    public void invoke() {
        this.visible = !this.visible;
        DrawableSeismogram.setDefaultVisibility((boolean)this.visible);
        for (int i = 0; i < this.destinations.length; ++i) {
            this.destinations[i].setOriginal(this.visible);
        }
    }

    @Override
    public void destroy() {
    }
}

