/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.PhaseFilter;
import edu.sc.seis.gee.task.PhasePlotTask;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import edu.sc.seis.gee.task.TauP;
import java.util.Arrays;
import java.util.Map;
import java.util.StringTokenizer;

public class TauPTask
implements Task {
    protected TauP taup;
    private Map params;
    private PhaseFilter filter;

    @Override
    public void configure(Map params) throws ConfigurationException {
        this.params = params;
        this.taup = params.containsKey("calculatorTitle") ? new TauP((String)params.get("calculatorTitle")) : new TauP("Earthquake Travel Time Calculator");
        if (params.containsKey("phases")) {
            String phasesString = (String)params.get("phases");
            StringTokenizer phasesTok = new StringTokenizer(phasesString, ",");
            int tokens = phasesTok.countTokens();
            String[] phases = new String[tokens];
            for (int i = 0; i < tokens; ++i) {
                phases[i] = phasesTok.nextToken();
            }
            this.taup.setSelectedPhases(phases);
        }
        if (params.containsKey("filter")) {
            String filterId = (String)params.get("filter");
            TaskAction filterAction = CommonAccess.getCommonAccess().getTaskAction(filterId);
            this.filter = (PhaseFilter)filterAction.getTask();
        }
    }

    @Override
    public void invoke() {
        this.taup.show();
    }

    public Arrival[] getArrivals(DataSetSeismogram seis) {
        ChannelId chanId = seis.getRequestFilter().channel_id;
        DataSet ds = seis.getDataSet();
        Channel chan = ds.getChannel(chanId);
        EventAccessOperations event = ds.getEvent();
        return this.getArrivals(chan, event, this.filter);
    }

    public Arrival[] getArrivals(Channel chan, EventAccessOperations event) {
        return this.getArrivals(chan, event, this.filter);
    }

    public Arrival[] getArrivals(Channel chan, EventAccessOperations event, PhaseFilter filter) {
        Location eventLoc = EventUtil.extractOrigin((EventAccessOperations)event).getLocation();
        Site site = chan.getSite();
        Arrival[] arrivals = null;
        arrivals = this.taup.calculate(SphericalCoords.distance((double)site.getLocation().latitude, (double)site.getLocation().longitude, (double)eventLoc.latitude, (double)eventLoc.longitude), ((QuantityImpl)eventLoc.depth).convertTo((UnitImpl)UnitImpl.KILOMETER).value);
        if (filter != null) {
            arrivals = filter.filter(Arrays.asList(arrivals)).toArray(new Arrival[0]);
        }
        return arrivals;
    }

    public void setTauPListener(PhasePlotTask listener) {
        this.taup.setTauPListener(listener);
    }

    @Override
    public void destroy() {
    }

    public TauP getTauP() {
        return this.taup;
    }
}

