/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.parmo3d.PartMo;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ParticleMotion3DTask
extends JPanel
implements Task {
    private Map configParams;
    private boolean guiInitialized = false;

    @Override
    public void invoke() throws ConfigurationException {
        if (!this.guiInitialized) {
            this.guiInitialized = true;
            this.createGUI();
        }
    }

    @Override
    public void destroy() {
    }

    public void createGUI() throws ConfigurationException {
        this.setLayout(new BorderLayout());
        try {
            Class.forName("javax.media.j3d.Group");
        }
        catch (ClassNotFoundException e) {
            String message = "Sorry Java3D is not available on this computer and so this task will not work.";
            if (this.configParams.containsKey("unsupportedOS_" + System.getProperty("os.name"))) {
                message = (String)this.configParams.get("unsupportedOS_" + System.getProperty("os.name"));
            }
            JOptionPane.showMessageDialog(null, message, "Java3D not available", 2);
            return;
        }
        float bazimuth = 0.0f;
        float ang = 0.0f;
        try {
            bazimuth = Float.parseFloat((String)this.configParams.get("backazimuth"));
        }
        catch (NumberFormatException nfe) {
            bazimuth = 0.0f;
        }
        try {
            ang = Float.parseFloat((String)this.configParams.get("angle"));
        }
        catch (NumberFormatException nfe) {
            ang = 0.0f;
        }
        PartMo particleMotion = new PartMo(bazimuth, ang);
        this.add((Component)particleMotion, "Center");
    }

    @Override
    public void configure(Map params) {
        this.configParams = params;
        try {
            Class.forName("javax.media.j3d.Group");
        }
        catch (ClassNotFoundException e) {
            params.put("gee.task.displayLocation", "none");
            TaskAction ta = (TaskAction)params.get("gee.task.taskAction");
            ta.setEnabled(false);
        }
    }
}

