/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.AuditInfo;
import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfSeismogramDC.DataCenterCallBack;
import edu.iris.Fissures.IfSeismogramDC.DataCenterOperations;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.cache.InstrumentationLoader;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooser;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooserSource;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.chooser.CoarseAvailableData;
import edu.sc.seis.fissuresUtil.chooser.DateChooser;
import edu.sc.seis.fissuresUtil.chooser.DateChooserOptions;
import edu.sc.seis.fissuresUtil.chooser.IntervalChooser;
import edu.sc.seis.fissuresUtil.chooser.IntervalChooserOptions;
import edu.sc.seis.fissuresUtil.database.DBDataCenter;
import edu.sc.seis.fissuresUtil.dataset.Organizer;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.FDSNWSDataSetSeismogram;
import edu.sc.seis.gee.BuildVersion;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.NetworkGateKeeper;
import edu.sc.seis.gee.NoNetworkException;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.ChannelChooserTask;
import edu.sc.seis.gee.task.FDSNChannelChooserSource;
import edu.sc.seis.gee.task.GUITask;
import edu.sc.seis.gee.task.TaskAction;
import edu.sc.seis.sod.source.seismogram.ChoiceSource;
import edu.sc.seis.sod.source.seismogram.FdsnDataSelect;
import edu.sc.seis.sod.source.seismogram.SeismogramSource;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceLocator;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Category;
import org.omg.CORBA.SystemException;

public class LoadSeismogram
implements GUITask {
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy MMM dd HH:mm:ss z");
    protected boolean guiInitialized = false;
    protected JPanel panel = null;
    protected SeismogramSourceLocator dataCenterRouter;
    protected DataCenterOperations dataCenter;
    protected HashMap nameToDataCenterMap = new HashMap();
    private Map configParams;
    private ChannelChooserTask channelChooserTask;
    private String messageStr = new String();
    private InstrumentationLoader instLoader;
    static Category logger = Category.getInstance((String)LoadSeismogram.class.getName());

    public LoadSeismogram() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.instLoader = new InstrumentationLoader();
        this.instLoader.start();
    }

    @Override
    public void invoke() throws Exception {
    }

    @Override
    public JComponent getMoreOptionsGUI() {
        return null;
    }

    @Override
    public boolean hasMoreOptions() {
        return false;
    }

    @Override
    public JComponent getGUI() {
        if (!this.guiInitialized) {
            this.guiInitialized = true;
            this.createGUI();
        }
        return this.panel;
    }

    @Override
    public void destroy() {
    }

    public void createGUI() {
        this.panel = new JPanel();
        IntervalChooserOptions[] options = new IntervalChooserOptions[]{IntervalChooserOptions.SECOND, IntervalChooserOptions.MINUTE, IntervalChooserOptions.HOUR, IntervalChooserOptions.DAY, IntervalChooserOptions.MONTH, IntervalChooserOptions.YEAR};
        final IntervalChooser intervalChooser = new IntervalChooser(options);
        intervalChooser.setSelectedValue(10);
        DateChooserOptions[] dateformat = new DateChooserOptions[]{DateChooserOptions.YEAR, DateChooserOptions.MONTH, DateChooserOptions.DAY, DateChooserOptions.HOUR, DateChooserOptions.MINUTES, DateChooserOptions.SECONDS};
        final DateChooser startDate = new DateChooser(dateformat);
        MicroSecondDate end = ClockUtil.now();
        MicroSecondDate begin = end.subtract(new TimeInterval(10.0, UnitImpl.MINUTE));
        startDate.setDate((Date)begin);
        JPanel endPanel = new JPanel();
        final JLabel endDateLabel = new JLabel("End Date");
        JLabel intervalLabel = new JLabel("Interval");
        JLabel startDateLabel = new JLabel("Start Date");
        JButton okButton = new JButton("OK");
        GridBagLayout bagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        endPanel.setLayout(new FlowLayout());
        endPanel.add(okButton);
        this.panel.setLayout(bagLayout);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        bagLayout.setConstraints(startDateLabel, constraints);
        this.panel.add(startDateLabel);
        constraints.weightx = 0.0;
        ++constraints.gridy;
        bagLayout.setConstraints((Component)startDate, constraints);
        this.panel.add((Component)startDate);
        constraints.gridheight = 1;
        constraints.gridy = 2;
        constraints.gridx = 0;
        bagLayout.setConstraints(intervalLabel, constraints);
        this.panel.add(intervalLabel);
        constraints.gridx = 0;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        ++constraints.gridy;
        bagLayout.setConstraints((Component)intervalChooser, constraints);
        this.panel.add((Component)intervalChooser);
        constraints.gridx = 0;
        constraints.weighty = 1.0;
        ++constraints.gridy;
        bagLayout.setConstraints(endDateLabel, constraints);
        this.panel.add(endDateLabel);
        ++constraints.gridy;
        bagLayout.setConstraints(endPanel, constraints);
        this.panel.add(endPanel);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Date intervalDate = intervalChooser.addTo(startDate.getDate());
                    endDateLabel.setText("End Date:" + LoadSeismogram.this.dateFormat.format(intervalDate));
                    MicroSecondDate when = new MicroSecondDate(startDate.getDate());
                    Time startTime = when.getFissuresTime();
                    Time endTime = new MicroSecondDate(intervalDate).getFissuresTime();
                    ChannelImpl[] channels = LoadSeismogram.this.channelChooserTask.getChannelChooser().getSelectedChannels(when);
                    ChannelId[] chanIds = new ChannelId[channels.length];
                    for (int i = 0; i < channels.length; ++i) {
                        logger.debug((Object)(channels[i].get_id().station_code + "=" + channels[i].getSite().getStation().getName()));
                        chanIds[i] = channels[i].get_id();
                    }
                    LoadSeismogram.this.populateLocalDataSet((Channel[])channels);
                    LoadSeismogram.this.loadAndStore(startTime, endTime, chanIds);
                }
                catch (Exception fe) {
                    GlobalExceptionHandler.handle((String)"Exception while Getting the Seismograms", (Throwable)fe);
                }
            }
        });
    }

    protected DataSetSeismogram[] loadAndStore(Time startTime, Time endTime, ChannelId[] channelId) throws ConfigurationException, NoNetworkException {
        DataSetSeismogram[] seis = new DataSetSeismogram[]{};
        boolean tryAgain = true;
        while (tryAgain) {
            try {
                seis = this.retrieveSeismograms(startTime, endTime, channelId);
                this.populateLocalDataSet(seis);
                tryAgain = false;
            }
            catch (SystemException corbaE) {
                int n = JOptionPane.showConfirmDialog(this.panel, "A problem has occured in connecting to the server. Would you like to try again?", "Network Error", 2, 0);
                if (n == 2) {
                    tryAgain = false;
                    seis = new DataSetSeismogram[]{};
                    continue;
                }
                tryAgain = true;
                this.dataCenter = null;
            }
        }
        this.messageStr = new String("Retrieved " + seis.length + " Seismograms");
        JOptionPane.showMessageDialog(null, this.messageStr, "Seismogram Information", 1);
        return seis;
    }

    public DataSetSeismogram retrieveSeismogram(RequestFilter request) throws ConfigurationException, NoNetworkException {
        RequestFilter[] inRequest = new RequestFilter[]{request};
        FDSNWSDataSetSeismogram seis = new FDSNWSDataSetSeismogram(request);
        seis.setUserAgent("GEE/" + BuildVersion.getVersion());
        ChannelChooser channelChooser = this.channelChooserTask.getChannelChooser();
        if (channelChooser.isSourceKnown(inRequest[0].channel_id.network_id)) {
            this.instLoader.getInstrumentation((DataSetSeismogram)seis, channelChooser);
        } else {
            logger.warn((Object)("networkAccess for " + NetworkIdUtil.toString((NetworkId)inRequest[0].channel_id.network_id) + " is not loaded, skipping instrumentation"));
        }
        return seis;
    }

    public DataSetSeismogram retrieveSeismogram(Time startTime, Time endTime, ChannelId channelId) throws ConfigurationException, NoNetworkException {
        return this.retrieveSeismogram(new RequestFilter(channelId, startTime, endTime));
    }

    public DataSetSeismogram[] retrieveSeismograms(Time startTime, Time endTime, ChannelId[] channelId) throws ConfigurationException, NoNetworkException {
        LinkedList<DataSetSeismogram> seismos = new LinkedList<DataSetSeismogram>();
        for (int i = 0; i < channelId.length; ++i) {
            DataSetSeismogram seis = this.retrieveSeismogram(new RequestFilter(channelId[i], startTime, endTime));
            if (seis == null) continue;
            seismos.add(seis);
        }
        DataSetSeismogram[] seismoArray = new DataSetSeismogram[]{};
        return seismos.toArray(seismoArray);
    }

    public void populateLocalDataSet(DataSetSeismogram[] seismograms) {
        Organizer organizer = CommonAccess.getCommonAccess().getOrganizer();
        for (int i = 0; i < seismograms.length; ++i) {
            if (seismograms[i] != null) {
                AuditInfo[] audit_info = new AuditInfo[]{new AuditInfo(System.getProperty("user.name"), "loaded seismogram " + seismograms[i].getName())};
                organizer.addSeismogram(seismograms[i], audit_info);
                continue;
            }
            logger.warn((Object)"Received a null seismogram");
        }
    }

    public void populateLocalDataSet(Channel[] channels) {
        Organizer organizer = CommonAccess.getCommonAccess().getOrganizer();
        AuditInfo[] audit = new AuditInfo[]{new AuditInfo(System.getProperty("user.name"), "loaded channel.")};
        for (int counter = 0; counter < channels.length; ++counter) {
            organizer.addChannel(channels[counter], audit);
        }
    }

    @Override
    public void configure(Map params) throws ConfigurationException {
        this.configParams = params;
        String chanChooserId = (String)params.get("channelChooserTask");
        TaskAction chanChooserAction = CommonAccess.getCommonAccess().getTaskAction(chanChooserId);
        this.channelChooserTask = (ChannelChooserTask)chanChooserAction.getTask();
    }

    void initializeDCRouter() throws ConfigurationException {
        if (!NetworkGateKeeper.accessAllowed()) {
            logger.info((Object)"No internet");
            return;
        }
        CommonAccess commonAccess = CommonAccess.getCommonAccess();
        CoarseAvailableData coarseAvailableData = null;
        String host = "service.iris.edu";
        try {
            List netdcList = this.channelChooserTask.getChannelChooser().getNetworkDCs();
            for (ChannelChooserSource netSource : netdcList) {
                FDSNChannelChooserSource fdsnStation;
                if (!(netSource instanceof FDSNChannelChooserSource) || !(fdsnStation = (FDSNChannelChooserSource)netSource).getFdsnStation().getDefaultQueryParams().getHost().equals(host)) continue;
                coarseAvailableData = fdsnStation.getFdsnStation().getAvailableData();
            }
        }
        catch (NoNetworkException e) {
            logger.info((Object)"No network, so no available data");
        }
        this.dataCenterRouter = new ChoiceSource(new ArrayList(), (SeismogramSourceLocator)new FdsnDataSelect(host, 80, coarseAvailableData));
        try {
            this.dataCenter = DBDataCenter.getDataCenter((String)commonAccess.getCacheDirectory(), (String)"GEE_database", (DataCenterOperations)new DataCenterOperations(){

                public RequestFilter[] available_data(RequestFilter[] request) {
                    try {
                        SeismogramSource s = LoadSeismogram.this.dataCenterRouter.getSeismogramSource(null, (ChannelImpl)LoadSeismogram.this.channelChooserTask.getChannelChooser().getChannel(request[0].channel_id), request, null);
                        return s.availableData(Arrays.asList(request)).toArray(new RequestFilter[0]);
                    }
                    catch (NoNetworkException e) {
                        throw new RuntimeException(e);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public LocalSeismogram[] retrieve_seismograms(RequestFilter[] request) throws FissuresException {
                    try {
                        SeismogramSource s = LoadSeismogram.this.dataCenterRouter.getSeismogramSource(null, (ChannelImpl)LoadSeismogram.this.channelChooserTask.getChannelChooser().getChannel(request[0].channel_id), request, null);
                        return (LocalSeismogram[])s.retrieveData(Arrays.asList(request)).toArray(new LocalSeismogramImpl[0]);
                    }
                    catch (NoNetworkException e) {
                        throw new RuntimeException(e);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public String request_seismograms(RequestFilter[] a_filterseq, DataCenterCallBack a_client, boolean long_lived, Time expiration_time) throws FissuresException {
                    throw new RuntimeException("No implement");
                }

                public String queue_seismograms(RequestFilter[] a_filterseq) throws FissuresException {
                    throw new RuntimeException("No implement");
                }

                public LocalSeismogram[] retrieve_queue(String a_request) throws FissuresException {
                    throw new RuntimeException("No implement");
                }

                public void cancel_request(String a_request) throws FissuresException {
                    throw new RuntimeException("No implement");
                }

                public String request_status(String a_request) throws FissuresException {
                    throw new RuntimeException("No implement");
                }
            });
        }
        catch (SQLException e) {
            throw new ConfigurationException("Database problem.", e);
        }
    }

    public SeismogramSourceLocator getDataCenterRouter() throws ConfigurationException {
        if (this.dataCenterRouter == null) {
            this.initializeDCRouter();
        }
        return this.dataCenterRouter;
    }
}

