/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooserException;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooserSource;
import edu.sc.seis.fissuresUtil.sac.InvalidResponse;
import edu.sc.seis.sod.source.SodSourceException;
import edu.sc.seis.sod.source.network.FdsnStation;
import java.util.ArrayList;
import java.util.List;

public class FDSNChannelChooserSource
implements ChannelChooserSource {
    FdsnStation fdsnStation;

    public FDSNChannelChooserSource(FdsnStation fdsnStation) {
        this.fdsnStation = fdsnStation;
    }

    public List<NetworkAttrImpl> getNetworks() throws ChannelChooserException {
        try {
            ArrayList<NetworkAttrImpl> out = new ArrayList<NetworkAttrImpl>();
            out.addAll(this.fdsnStation.getNetworks());
            return out;
        }
        catch (SodSourceException e) {
            throw new ChannelChooserException((Throwable)e);
        }
    }

    public List<StationImpl> getStations(NetworkAttrImpl net) throws ChannelChooserException {
        try {
            ArrayList<StationImpl> out = new ArrayList<StationImpl>();
            out.addAll(this.fdsnStation.getStations(net));
            return out;
        }
        catch (SodSourceException e) {
            throw new ChannelChooserException((Throwable)e);
        }
    }

    public List<ChannelImpl> getChannels(StationImpl station) throws ChannelChooserException {
        try {
            ArrayList<ChannelImpl> out = new ArrayList<ChannelImpl>();
            out.addAll(this.fdsnStation.getChannels(station));
            return out;
        }
        catch (SodSourceException e) {
            throw new ChannelChooserException((Throwable)e);
        }
    }

    public QuantityImpl getSensitivity(ChannelImpl chan) throws ChannelNotFound, InvalidResponse, ChannelChooserException {
        try {
            return this.fdsnStation.getSensitivity(chan);
        }
        catch (SodSourceException e) {
            throw new ChannelChooserException((Throwable)e);
        }
    }

    public Instrumentation getInstrumentation(ChannelImpl chan) throws ChannelNotFound, InvalidResponse, ChannelChooserException {
        try {
            return this.fdsnStation.getInstrumentation(chan);
        }
        catch (SodSourceException e) {
            throw new ChannelChooserException((Throwable)e);
        }
    }

    public FdsnStation getFdsnStation() {
        return this.fdsnStation;
    }

    public String toString() {
        return this.fdsnStation.getName();
    }
}

