/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.fissuresUtil.display.registrar.RTTimeRangeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.NoNetworkException;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.ColumnSeismogramTask;
import edu.sc.seis.gee.task.TaskAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class DataSetRealTimePlayerTask
extends ColumnSeismogramTask {
    protected JButton stopButton;
    protected JButton playButton;
    private JButton currentButton;
    private ImageIcon[] currentButtonIcons;
    private RTTimeRangeConfig rtTimeRangeConfig;
    private boolean guiLoaded = false;

    @Override
    public void invoke() throws ConfigurationException, NoNetworkException {
        super.invoke();
        if (!this.guiLoaded) {
            ClassLoader loader = this.getClass().getClassLoader();
            TaskAction taskAction = (TaskAction)this.params.get("gee.task.taskAction");
            ImageIcon[] rewIcons = new ImageIcon[]{new ImageIcon(loader.getResource("edu/sc/seis/gee/data/images/rew.png")), new ImageIcon(loader.getResource("edu/sc/seis/gee/data/images/rew-lit.png"))};
            JButton rewindButton = new JButton(rewIcons[0]);
            rewindButton.setToolTipText("Click here to make the seismograms move quickly to the right");
            taskAction.addToToolBar(rewindButton);
            rewindButton.addActionListener(new RTSpeedChanger(-20, rewIcons, rewindButton));
            ImageIcon[] stopIcons = new ImageIcon[]{new ImageIcon(loader.getResource("edu/sc/seis/gee/data/images/stop.png")), new ImageIcon(loader.getResource("edu/sc/seis/gee/data/images/stop-lit.png"))};
            this.stopButton = new JButton(stopIcons[1]);
            this.stopButton.setToolTipText("Click here to make the seismograms stop moving");
            this.currentButton = this.stopButton;
            this.currentButtonIcons = stopIcons;
            taskAction.addToToolBar(this.stopButton);
            this.stopButton.addActionListener(new RTSpeedChanger(0, stopIcons, this.stopButton));
            ImageIcon[] playIcons = new ImageIcon[]{new ImageIcon(loader.getResource("edu/sc/seis/gee/data/images/play.png")), new ImageIcon(loader.getResource("edu/sc/seis/gee/data/images/play-lit.png"))};
            this.playButton = new JButton(playIcons[0]);
            this.playButton.setToolTipText("Click here to make the seismograms move to the left");
            taskAction.addToToolBar(this.playButton);
            this.playButton.addActionListener(new RTSpeedChanger(1, playIcons, this.playButton));
            ImageIcon[] ffIcons = new ImageIcon[]{new ImageIcon(loader.getResource("edu/sc/seis/gee/data/images/fastf.png")), new ImageIcon(loader.getResource("edu/sc/seis/gee/data/images/fastf-lit.png"))};
            JButton fastForwardButton = new JButton(ffIcons[0]);
            fastForwardButton.setToolTipText("Click here to make the seismograms move quickly to the left");
            taskAction.addToToolBar(fastForwardButton);
            fastForwardButton.addActionListener(new RTSpeedChanger(20, ffIcons, fastForwardButton));
            this.guiLoaded = true;
        }
    }

    private RTTimeRangeConfig getTimeConfig() {
        if (this.getDisplay().getTimeConfig() != null) {
            if (!(this.getDisplay().getTimeConfig() instanceof RTTimeRangeConfig)) {
                this.getDisplay().setTimeConfig((TimeConfig)new RTTimeRangeConfig(this.getDisplay().getTimeConfig()));
            }
            if (this.getDisplay().getTimeConfig() != this.rtTimeRangeConfig) {
                if (this.rtTimeRangeConfig != null) {
                    this.rtTimeRangeConfig.stopTimer();
                }
                this.rtTimeRangeConfig = (RTTimeRangeConfig)this.getDisplay().getTimeConfig();
            }
        }
        return this.rtTimeRangeConfig;
    }

    @Override
    public void destroy() {
        if (this.rtTimeRangeConfig != null) {
            this.rtTimeRangeConfig.stopTimer();
        }
        super.destroy();
    }

    @Override
    public void addSeismogram(DataSetSeismogram dss) {
        if ((this.getDisplay() == null || this.getDisplay().getSeismograms().length == 0) && this.rtTimeRangeConfig != null) {
            this.rtTimeRangeConfig.stopTimer();
            this.rtTimeRangeConfig = null;
        }
        super.addSeismogram(dss);
    }

    @Override
    protected void setDisplay() {
        super.setDisplay();
        this.getTimeConfig();
    }

    static /* synthetic */ ImageIcon[] access$302(DataSetRealTimePlayerTask x0, ImageIcon[] x1) {
        x0.currentButtonIcons = x1;
        return x1;
    }

    private class RTSpeedChanger
    implements ActionListener {
        private int speed;
        private ImageIcon[] icons;
        private JButton button;

        private RTSpeedChanger(int speed, ImageIcon[] icons, JButton button) {
            this.speed = speed;
            this.icons = icons;
            this.button = button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataSetRealTimePlayerTask.this.currentButton == this.button) {
                return;
            }
            if (DataSetRealTimePlayerTask.this.getTimeConfig() != null) {
                DataSetRealTimePlayerTask.this.currentButton.setIcon(DataSetRealTimePlayerTask.this.currentButtonIcons[0]);
                DataSetRealTimePlayerTask.this.getTimeConfig().setSpeed((float)this.speed);
                if (this.speed != 0) {
                    DataSetRealTimePlayerTask.this.getTimeConfig().startTimer();
                } else {
                    DataSetRealTimePlayerTask.this.getTimeConfig().stopTimer();
                }
                DataSetRealTimePlayerTask.this.currentButton = this.button;
                DataSetRealTimePlayerTask.this.currentButton.setIcon(this.icons[1]);
                DataSetRealTimePlayerTask.access$302(DataSetRealTimePlayerTask.this, this.icons);
            }
        }
    }
}

