/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.propertyeditor;

import com.isti.util.BaseProperties;
import com.isti.util.CfgPropItem;
import com.isti.util.propertyeditor.BasePropertyInspector;
import com.isti.util.propertyeditor.PropertyEditorFactory;
import java.awt.Component;
import java.beans.PropertyEditor;
import java.util.Collection;

public class CfgPropertyInspector
extends BasePropertyInspector {
    public static boolean setLoadedFlag = false;
    private static final boolean defaultSaveAsTextFlag = false;
    private final BaseProperties propertiesObj;
    private final boolean startupItems;

    public CfgPropertyInspector(BaseProperties settingsProps) {
        this(settingsProps, false);
    }

    public CfgPropertyInspector(BaseProperties settingsProps, boolean startupItems) {
        this.saveAsTextFlag = false;
        this.centerFlag = true;
        this.propertiesObj = settingsProps;
        this.startupItems = startupItems;
        this.addProperties(settingsProps);
        this.lowerButtonPanelObj.defaultsButton.setEnabled(this.propertiesObj != null);
    }

    protected Collection getPropertyKeys() {
        return this.propertiesObj.keySet();
    }

    protected Object getDefaultValue(String key) {
        if (this.propertiesObj == null) {
            return null;
        }
        CfgPropItem item = this.propertiesObj.get(key);
        if (item == null) {
            return null;
        }
        return item.getDefaultValue();
    }

    public static Object getEditorValue(CfgPropItem item, PropertyEditor editor) {
        return BasePropertyInspector.getEditorValue(item.getName(), editor, item.getValue(), false);
    }

    protected String getTabTitle(String key) {
        CfgPropItem item = this.propertiesObj.get(key);
        if (item.getIgnoreItemFlag()) {
            return null;
        }
        if (this.startupItems && !item.isStartupConfigFlag()) {
            return null;
        }
        Object groupSelObj = item.getGroupSelObj();
        if (groupSelObj instanceof String) {
            return (String)groupSelObj;
        }
        if (groupSelObj instanceof CfgPropItem.ItemGroupSelector) {
            return ((CfgPropItem.ItemGroupSelector)groupSelObj).getSelectStr();
        }
        return null;
    }

    protected Component createPropertyLabel(String key) {
        CfgPropItem item = this.propertiesObj.get(key);
        return PropertyEditorFactory.createPropertyLabel(item);
    }

    protected PropertyEditor createPropertyEditor(String key) {
        CfgPropItem item = this.propertiesObj.get(key);
        return PropertyEditorFactory.createPropertyEditor(item);
    }

    public void setValue(String key, Object value) {
        CfgPropItem item = this.propertiesObj.get(key);
        item.setValue(value);
        if (setLoadedFlag) {
            item.setLoadedFlag(true);
        }
    }
}

