/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.math;

import com.isti.util.ErrorMessageMgr;

public class CubicSpline
extends ErrorMessageMgr {
    public static double TRIG_ARG_MIN = 0.001;
    public static double TRIG_ARG_MAX = 50.0;

    public double[] calcSpline(double[] t, double[] y, double tension, double k, double[] xValsArr) {
        if (t.length != y.length) {
            this.setErrorMessageString("Arrays 't[]' and 'y[]' not same length");
            return null;
        }
        int used = t.length - 1;
        int numXVals = xValsArr.length;
        if (used < 1 || numXVals <= 0) {
            return new double[0];
        }
        if (used <= 1) {
            k = 0.0;
        }
        if (!this.isMonotonic(t)) {
            this.setErrorMessageString("Abscissa values not monotonic");
            return null;
        }
        double[] z = this.fit(t, y, k, tension, false);
        if (z == null) {
            return null;
        }
        double lastXVal = xValsArr[numXVals - 1];
        int lastVal = 0;
        if (lastXVal == t[0]) {
            lastVal = 1;
        } else if (lastXVal == t[used]) {
            lastVal = 2;
        }
        double[] retValsArr = new double[numXVals];
        int retArrIdx = 0;
        int outRangeCount = 0;
        for (int i = 0; i < numXVals; ++i) {
            double x = xValsArr[i];
            if (i == numXVals - 1) {
                if (lastVal == 1) {
                    x = t[0];
                } else if (lastVal == 2) {
                    x = t[used];
                }
            }
            if ((x - t[0]) * (x - t[used]) <= 0.0) {
                retValsArr[retArrIdx++] = CubicSpline.interpolate(t, y, z, x, tension, false);
                continue;
            }
            ++outRangeCount;
        }
        if (outRangeCount > 0) {
            this.setErrorMessageString(outRangeCount + " requested point" + (outRangeCount != 1 ? "s" : "") + " could not be computed (out of data range)");
            return null;
        }
        return retValsArr;
    }

    public double[] fit(double[] t, double[] y, double k, double tension, boolean periodic) {
        double xabs;
        double x;
        int i;
        if (t.length != y.length) {
            this.setErrorMessageString("Arrays 't[]' and 'y[]' not same length in 'fit' method");
            return null;
        }
        int n = t.length - 1;
        if (n == 1) {
            return new double[]{0.0, 0.0};
        }
        double[] z = new double[n + 1];
        double[] h = new double[n];
        double[] b = new double[n];
        double[] u = new double[n];
        double[] v = new double[n];
        double[] alpha = new double[n];
        double[] beta = new double[n];
        double[] uu = null;
        double[] vv = null;
        double[] s = null;
        if (periodic) {
            s = new double[n];
            uu = new double[n];
            vv = new double[n];
        }
        for (i = 0; i <= n - 1; ++i) {
            h[i] = t[i + 1] - t[i];
            b[i] = 6.0 * (y[i + 1] - y[i]) / h[i];
        }
        if (tension < 0.0) {
            for (i = 0; i <= n - 1; ++i) {
                if (Math.sin(tension * h[i]) != 0.0) continue;
                this.setErrorMessageString("Specified negative tension value is singular in 'fit' method");
                return null;
            }
        }
        if (tension == 0.0) {
            for (i = 0; i <= n - 1; ++i) {
                alpha[i] = h[i];
                beta[i] = 2.0 * h[i];
            }
        } else if (tension > 0.0) {
            for (i = 0; i <= n - 1; ++i) {
                x = tension * h[i];
                double d = xabs = x < 0.0 ? -x : x;
                if (xabs < TRIG_ARG_MIN) {
                    alpha[i] = h[i] * CubicSpline.sinh_func(x);
                    beta[i] = 2.0 * h[i] * CubicSpline.tanh_func(x);
                    continue;
                }
                if (xabs > TRIG_ARG_MAX) {
                    int sign = x < 0.0 ? -1 : 1;
                    alpha[i] = 6.0 / (tension * tension) * (1.0 / h[i] - tension * 2.0 * (double)sign * Math.exp(-xabs));
                    beta[i] = 6.0 / (tension * tension) * (tension - 1.0 / h[i]);
                    continue;
                }
                alpha[i] = 6.0 / (tension * tension) * (1.0 / h[i] - tension / CubicSpline.sinh(x));
                beta[i] = 6.0 / (tension * tension) * (tension / CubicSpline.tanh(x) - 1.0 / h[i]);
            }
        } else {
            for (i = 0; i <= n - 1; ++i) {
                x = tension * h[i];
                double d = xabs = x < 0.0 ? -x : x;
                if (xabs < TRIG_ARG_MIN) {
                    alpha[i] = h[i] * CubicSpline.sin_func(x);
                    beta[i] = 2.0 * h[i] * CubicSpline.tan_func(x);
                    continue;
                }
                alpha[i] = 6.0 / (tension * tension) * (1.0 / h[i] - tension / Math.sin(x));
                beta[i] = 6.0 / (tension * tension) * (tension / Math.tan(x) - 1.0 / h[i]);
            }
        }
        u[1] = !periodic && n == 2 ? beta[0] + beta[1] + 2.0 * k * alpha[0] : beta[0] + beta[1] + k * alpha[0];
        v[1] = b[1] - b[0];
        if (u[1] == 0.0) {
            this.setErrorMessageString("As posed, problem of computing spline is singular in 'fit' method");
            return null;
        }
        if (periodic) {
            s[1] = alpha[0];
            uu[1] = 0.0;
            vv[1] = 0.0;
        }
        for (i = 2; i <= n - 1; ++i) {
            u[i] = beta[i] + beta[i - 1] - alpha[i - 1] * alpha[i - 1] / u[i - 1] + (i == n - 1 ? k * alpha[n - 1] : 0.0);
            if (u[i] == 0.0) {
                this.setErrorMessageString("As posed, problem of computing spline is singular in 'fit' method");
                return null;
            }
            v[i] = b[i] - b[i - 1] - alpha[i - 1] * v[i - 1] / u[i - 1];
            if (!periodic) continue;
            s[i] = -s[i - 1] * alpha[i - 1] / u[i - 1];
            uu[i] = uu[i - 1] - s[i - 1] * s[i - 1] / u[i - 1];
            vv[i] = vv[i - 1] - v[i - 1] * s[i - 1] / u[i - 1];
        }
        if (!periodic) {
            z[n] = 0.0;
            for (i = n - 1; i >= 1; --i) {
                z[i] = (v[i] - alpha[i] * z[i + 1]) / u[i];
            }
            z[0] = 0.0;
            z[0] = k * z[1];
            z[n] = k * z[n - 1];
        } else {
            z[n - 1] = (v[n - 1] + vv[n - 1]) / (u[n - 1] + uu[n - 1] + 2.0 * s[n - 1]);
            for (i = n - 2; i >= 1; --i) {
                z[i] = (v[i] - alpha[i] * z[i + 1] - s[i] * z[n - 1]) / u[i];
            }
            z[0] = z[n - 1];
            z[n] = z[1];
        }
        return z;
    }

    public static double interpolate(double[] t, double[] y, double[] z, double x, double tension, boolean periodic) {
        double value;
        int n = t.length <= y.length ? t.length - 1 : y.length - 1;
        boolean is_ascending = t[n - 1] < t[n];
        int i = 0;
        if (periodic && (x - t[0]) * (x - t[n]) > 0.0) {
            x -= (double)((int)Math.floor((x - t[0]) / (t[n] - t[0]))) * (t[n] - t[0]);
        }
        int k = n - i;
        while (k > 1) {
            if (is_ascending ? x >= t[i + (k >> 1)] : x <= t[i + (k >> 1)]) {
                i += k >> 1;
                k -= k >> 1;
                continue;
            }
            k >>= 1;
        }
        double h = t[i + 1] - t[i];
        double diff = x - t[i];
        double updiff = t[i + 1] - x;
        double reldiff = diff / h;
        double relupdiff = updiff / h;
        if (tension == 0.0) {
            value = y[i] + diff * ((y[i + 1] - y[i]) / h - h * (z[i + 1] + z[i] * 2.0) / 6.0 + diff * (0.5 * z[i] + diff * (z[i + 1] - z[i]) / (6.0 * h)));
        } else if (tension > 0.0) {
            if (Math.abs(tension * h) < TRIG_ARG_MIN) {
                value = y[i] * relupdiff + y[i + 1] * reldiff + z[i] * h * h / 6.0 * CubicSpline.quotient_sinh_func(relupdiff, tension * h) + z[i + 1] * h * h / 6.0 * CubicSpline.quotient_sinh_func(reldiff, tension * h);
            } else if (Math.abs(tension * h) > TRIG_ARG_MAX) {
                int sign = h < 0.0 ? -1 : 1;
                value = (z[i] * (Math.exp(tension * updiff - (double)sign * tension * h) + Math.exp(-tension * updiff - (double)sign * tension * h)) + z[i + 1] * (Math.exp(tension * diff - (double)sign * tension * h) + Math.exp(-tension * diff - (double)sign * tension * h))) * ((double)sign / (tension * tension)) + (y[i] - z[i] / (tension * tension)) * (updiff / h) + (y[i + 1] - z[i + 1] / (tension * tension)) * (diff / h);
            } else {
                value = (z[i] * CubicSpline.sinh(tension * updiff) + z[i + 1] * CubicSpline.sinh(tension * diff)) / (tension * tension * CubicSpline.sinh(tension * h)) + (y[i] - z[i] / (tension * tension)) * (updiff / h) + (y[i + 1] - z[i + 1] / (tension * tension)) * (diff / h);
            }
        } else {
            value = Math.abs(tension * h) < TRIG_ARG_MIN ? y[i] * relupdiff + y[i + 1] * reldiff + z[i] * h * h / 6.0 * CubicSpline.quotient_sin_func(relupdiff, tension * h) + z[i + 1] * h * h / 6.0 * CubicSpline.quotient_sin_func(reldiff, tension * h) : (z[i] * Math.sin(tension * updiff) + z[i + 1] * Math.sin(tension * diff)) / (tension * tension * Math.sin(tension * h)) + (y[i] - z[i] / (tension * tension)) * (updiff / h) + (y[i + 1] - z[i + 1] / (tension * tension)) * (diff / h);
        }
        return value;
    }

    public final boolean isMonotonic(double[] t) {
        boolean isAscending;
        int n = t.length - 1;
        if (n <= 0) {
            return false;
        }
        if (t[n - 1] < t[n]) {
            isAscending = true;
        } else if (t[n - 1] > t[n]) {
            isAscending = false;
        } else {
            return false;
        }
        while (n > 0) {
            --n;
            if (!(isAscending ? t[n] >= t[n + 1] : t[n] <= t[n + 1])) continue;
            return false;
        }
        return true;
    }

    public static double sinh(double value) {
        return (Math.exp(value) - Math.exp(-value)) / 2.0;
    }

    public static double tanh(double value) {
        double expVal = Math.exp(value);
        double expNVal = Math.exp(-value);
        return (expVal - expNVal) / (expVal + expNVal);
    }

    public static double sinh_func(double x) {
        return 1.0 - 0.11666666666666667 * x * x + 0.012301587301587301 * x * x * x * x;
    }

    public static double tanh_func(double x) {
        return 1.0 - 0.06666666666666667 * x * x + 0.006349206349206349 * x * x * x * x;
    }

    public static double sin_func(double x) {
        return -1.0 - 0.11666666666666667 * x * x - 0.012301587301587301 * x * x * x * x;
    }

    public static double tan_func(double x) {
        return -1.0 - 0.06666666666666667 * x * x - 0.006349206349206349 * x * x * x * x;
    }

    public static double quotient_sinh_func(double x, double y) {
        return x * x * x - x + (x * x * x * x * x / 20.0 - x * x * x / 6.0 + 7.0 * x / 60.0) * (y * y) + (x * x * x * x * x * x * x / 840.0 - x * x * x * x * x / 120.0 + 7.0 * x * x * x / 360.0 - 31.0 * x / 2520.0) * (y * y * y * y);
    }

    public static double quotient_sin_func(double x, double y) {
        return -(x * x * x - x) + (x * x * x * x * x / 20.0 - x * x * x / 6.0 + 7.0 * x / 60.0) * (y * y) - (x * x * x * x * x * x * x / 840.0 - x * x * x * x * x / 120.0 + 7.0 * x * x * x / 360.0 - 31.0 * x / 2520.0) * (y * y * y * y);
    }
}

