/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui.textvalidator;

import com.isti.util.UtilFns;
import com.isti.util.gui.textvalidator.AllowedCharactersConstants;
import com.isti.util.gui.textvalidator.TextValidator;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public abstract class AbstractValidatedDocument
extends PlainDocument
implements AllowedCharactersConstants {
    public abstract boolean getAllowedFlag();

    public abstract int getColumns();

    public abstract int getMaxNumChars();

    public abstract String getSpecialChars();

    public abstract TextValidator getTextValidator();

    public void insertString(int insOffs, String insStr, AttributeSet aSet) throws BadLocationException {
        int p;
        String dataStr;
        block12: {
            int insLen;
            block13: {
                int q;
                char ch;
                int offs;
                dataStr = null;
                if (insStr == null || (insLen = insStr.length()) <= 0) {
                    return;
                }
                String cmpString = insStr;
                char decimalSeparator = UtilFns.getDecimalSeparator();
                boolean numericFlag = this.isNumeric();
                if (numericFlag && decimalSeparator != '.') {
                    insStr = insStr.replace('.', decimalSeparator);
                    cmpString = cmpString.replace(decimalSeparator, '.');
                }
                int dataLen = this.getLength();
                int maxNumChars = this.getMaxNumChars();
                if (maxNumChars > 0 && dataLen + insLen > maxNumChars) {
                    return;
                }
                String specialChars = this.getSpecialChars();
                if (specialChars == null || specialChars.length() <= 0) break block13;
                boolean replaceFlag = this.isReplace();
                if (insOffs >= 0 && insOffs <= dataLen) {
                    offs = insOffs;
                    dataStr = (this.getText(0, offs) + insStr + this.getText(offs, dataLen - offs)).toLowerCase();
                    dataLen = dataStr.length();
                } else {
                    dataStr = insStr;
                    offs = dataLen;
                }
                p = 0;
                do {
                    if (this.isAllowed(ch = cmpString.charAt(p))) continue;
                    if (!replaceFlag) break block12;
                    char newch = ch;
                    if (Character.isLowerCase(ch)) {
                        newch = Character.toUpperCase(ch);
                    } else if (Character.isUpperCase(ch)) {
                        newch = Character.toLowerCase(ch);
                    }
                    if (newch == ch || !this.isAllowed(newch)) break block12;
                    insStr = insStr.replace(ch, newch);
                    cmpString = cmpString.replace(ch, newch);
                } while ((!numericFlag || (ch != '-' && ch != '+' || offs + p <= 0 || dataStr.substring(offs + p - 1, offs + p).equalsIgnoreCase("e") && (offs + p + 1 >= dataLen || "0123456789".indexOf(dataStr.charAt(offs + p + 1)) >= 0)) && (ch != decimalSeparator || (q = dataStr.indexOf(decimalSeparator)) < 0 || q >= dataLen || dataStr.indexOf(decimalSeparator, q + 1) < 0) && (ch != 'e' && ch != 'E' || offs + p != 0 && "0123456789".indexOf(dataStr.charAt(offs + p - 1)) >= 0) && ((q = dataStr.indexOf(101)) < 0 || q >= dataLen || dataStr.indexOf(101, q + 1) < 0)) && ++p < insLen);
                break block12;
                {
                }
            }
            p = insLen;
        }
        if (p > 0) {
            TextValidator textValidator = this.getTextValidator();
            if (textValidator != null && !textValidator.isValid(dataStr)) {
                return;
            }
            super.insertString(insOffs, insStr.substring(0, p), aSet);
        }
    }

    protected boolean isAllowed(char ch) {
        return this.isSpecialChar(ch) == this.getAllowedFlag();
    }

    public abstract boolean isNumeric();

    protected boolean isReplace() {
        return AbstractValidatedDocument.isReplace(this.getSpecialChars(), this.isNumeric());
    }

    protected boolean isSpecialChar(char ch) {
        String specialChars = this.getSpecialChars();
        return specialChars != null && specialChars.indexOf(ch) >= 0;
    }

    public abstract void setTextValidator(TextValidator var1);

    protected static boolean isReplace(String specialChars, boolean numericFlag) {
        boolean replaceFlag = false;
        if (!numericFlag && specialChars != null && specialChars.length() > 0) {
            boolean allLowerCaseFlag;
            boolean allUpperCaseFlag = specialChars.indexOf("ABCDEFGHIJKLMNOPQRSTUVWXYZ") >= 0;
            boolean bl = allLowerCaseFlag = specialChars.indexOf("abcdefghijklmnopqrstuvwxyz") >= 0;
            if (!allUpperCaseFlag || !allLowerCaseFlag) {
                replaceFlag = true;
            }
        }
        return replaceFlag;
    }
}

