/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.UtilFns;
import com.isti.util.gis.IstiRegion;
import com.isti.util.gis.IstiRegionMgrIntf;
import com.isti.util.gui.IstiDialogPopup;
import com.isti.util.gui.IstiDialogUtil;
import com.isti.util.gui.IstiRegionEditPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class IstiRegionPanel
extends JPanel
implements WindowListener {
    public static final String HELP_OPTION_TEXT = "Help";
    public static final String CLOSE_OPTION_TEXT = "Close";
    protected static final String DEF_NEWREGION_NAME = "Region";
    private final Vector panelListenerList = new Vector();
    private final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    protected final IstiDialogUtil dialogUtilObj = new IstiDialogUtil(this);
    protected boolean dialogModalFlag = false;
    protected boolean centerEditDialogFlag = false;
    protected boolean mouseClickEditFlag = true;
    protected String newRegionNameStr = "Region";
    protected IstiDialogPopup dialogObj = null;
    private IstiRegionEditPanel regionEditPanel = null;
    private ActionListener helpActionListener = null;
    public final AbstractAction addCircleButtonActionObj = new AbstractAction("Add Circle"){

        public void actionPerformed(ActionEvent evtObj) {
            IstiRegionPanel.this.addNewRegion(true);
        }
    };
    public final AbstractAction addPolyButtonActionObj = new AbstractAction("Add Poly"){

        public void actionPerformed(ActionEvent evtObj) {
            IstiRegionPanel.this.addNewRegion(false);
        }
    };
    public final AbstractAction editButtonActionObj = new AbstractAction("Edit"){

        public void actionPerformed(ActionEvent evtObj) {
            IstiRegionPanel.this.editSelectedRegion();
        }
    };
    public final AbstractAction removeButtonActionObj = new AbstractAction("Remove"){

        public void actionPerformed(ActionEvent evtObj) {
            IstiRegionPanel.this.removeSelectedRegions();
        }
    };
    public final AbstractAction copyButtonActionObj = new AbstractAction("Copy"){

        public void actionPerformed(ActionEvent evtObj) {
            IstiRegionPanel.this.copyToNewRegion();
        }
    };
    private final JButton addCircleButton = new JButton(this.addCircleButtonActionObj);
    private final JButton addPolyButton = new JButton(this.addPolyButtonActionObj);
    private final JButton editButton = new JButton(this.editButtonActionObj);
    private final JButton removeButton = new JButton(this.removeButtonActionObj);
    private final JButton copyButton = new JButton(this.copyButtonActionObj);
    private final Vector regionListDataObj = new Vector();
    private final JList regionJListObj = new JList();
    private Vector regionEditPanels = new Vector();
    private Component regionEditParentComp = null;
    private final List optionGroups;
    private IstiRegionMgrIntf istiRegionMgrObj = null;

    public IstiRegionPanel() {
        this((List)null);
    }

    public IstiRegionPanel(List optionGroups) {
        this.optionGroups = optionGroups;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setIstiRegionMgrObj(IstiRegionMgrIntf istiRegionMgrObj) {
        this.istiRegionMgrObj = istiRegionMgrObj;
    }

    public void setNewRegionNameStr(String nameStr) {
        this.newRegionNameStr = nameStr;
    }

    protected final void jbInit() throws Exception {
        this.setPreferredSize(new Dimension(this.screenSize.width / 4, this.screenSize.height / 4));
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraintsObj = new GridBagConstraints();
        constraintsObj.gridy = 0;
        constraintsObj.gridx = 0;
        constraintsObj.gridheight = 1;
        constraintsObj.gridwidth = 1;
        constraintsObj.weightx = 1.0;
        constraintsObj.weighty = 0.25;
        constraintsObj.anchor = 10;
        constraintsObj.fill = 2;
        constraintsObj.insets = new Insets(2, 0, 2, 0);
        buttonsPanel.add((Component)this.addCircleButton, constraintsObj);
        ++constraintsObj.gridy;
        buttonsPanel.add((Component)this.addPolyButton, constraintsObj);
        ++constraintsObj.gridy;
        buttonsPanel.add((Component)this.editButton, constraintsObj);
        ++constraintsObj.gridy;
        buttonsPanel.add((Component)this.removeButton, constraintsObj);
        ++constraintsObj.gridy;
        buttonsPanel.add((Component)this.copyButton, constraintsObj);
        ++constraintsObj.gridy;
        constraintsObj.weighty = 0.75;
        buttonsPanel.add(Box.createVerticalStrut(1), constraintsObj);
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 10));
        JScrollPane listScrollPane = new JScrollPane(this.regionJListObj, 20, 30);
        JPanel scrollPanePanel = new JPanel(new BorderLayout());
        scrollPanePanel.add((Component)listScrollPane, "Center");
        scrollPanePanel.setBorder(BorderFactory.createEmptyBorder(2, 10, 10, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPanePanel, "Center");
        this.add((Component)buttonsPanel, "East");
        this.addCircleButton.setToolTipText("Create and add a new point-radius region");
        this.addPolyButton.setToolTipText("Create and add a new polygon region");
        this.editButton.setToolTipText("Edit an existing region entry");
        this.removeButton.setToolTipText("Remove an existing region entry");
        this.copyButton.setToolTipText("Copy fields from an existing region");
        this.regionJListObj.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evtObj) {
                try {
                    if (IstiRegionPanel.this.mouseClickEditFlag && evtObj.getClickCount() >= 2) {
                        int idx = IstiRegionPanel.this.regionJListObj.locationToIndex(evtObj.getPoint());
                        Object obj = IstiRegionPanel.this.regionJListObj.getModel().getElementAt(idx);
                        if (obj instanceof String) {
                            IstiRegionPanel.this.editSpecifiedRegion((String)obj, idx);
                        }
                    }
                }
                catch (Exception ex) {
                    System.err.println("Error processing mouse click on regions list:  " + ex);
                    ex.printStackTrace();
                }
            }
        });
    }

    public void addActionListener(ActionListener l) {
        this.panelListenerList.add(l);
    }

    public IstiDialogPopup createDialog(String titleStr, Component regionParentComp, Component regionEditParentComp, boolean modalFlag) {
        Object[] objectArray;
        if (regionEditParentComp != null) {
            this.regionEditParentComp = regionEditParentComp;
            this.centerEditDialogFlag = modalFlag;
        } else {
            this.regionEditParentComp = this;
            this.centerEditDialogFlag = true;
        }
        this.dialogModalFlag = modalFlag;
        int msgType = -1;
        int optionType = -1;
        if (this.isHelpActionListenerInstalled()) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = CLOSE_OPTION_TEXT;
            objectArray = objectArray2;
            objectArray2[1] = HELP_OPTION_TEXT;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = CLOSE_OPTION_TEXT;
        }
        Object[] optionsArr = objectArray;
        this.dialogObj = new IstiDialogPopup(regionParentComp, this, titleStr, -1, optionsArr, 0, modalFlag, false, -1);
        final JOptionPane paneObj = this.dialogObj.getOptionPaneObj();
        this.dialogObj.setDefaultCloseOperation(2);
        if (!this.centerEditDialogFlag) {
            this.dialogObj.setLocation(0, 0);
        }
        this.dialogObj.setHideDialogOnButtonFlag(false);
        this.dialogObj.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Object newValue = evt.getNewValue();
                String prop = evt.getPropertyName();
                if (IstiRegionPanel.this.dialogObj.isVisible() && evt.getSource() == paneObj && ("value".equals(prop) || "inputValue".equals(prop))) {
                    Object value = paneObj.getValue();
                    if (value == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    if (IstiRegionPanel.HELP_OPTION_TEXT.equals(newValue)) {
                        IstiRegionPanel.this.notifyHelpActionListener(IstiRegionPanel.this);
                        paneObj.setValue(JOptionPane.UNINITIALIZED_VALUE);
                        return;
                    }
                    IstiRegionPanel.this.dialogObj.dispose();
                }
            }
        });
        this.dialogObj.addWindowListener(this);
        return this.dialogObj;
    }

    public IstiDialogPopup createDialog(String titleStr, Component regionParentComp, Component regionEditParentComp) {
        return this.createDialog(titleStr, regionParentComp, regionEditParentComp, false);
    }

    public IstiDialogPopup createDialog(String titleStr, Component regionParentComp, boolean modalFlag) {
        return this.createDialog(titleStr, regionParentComp, null, modalFlag);
    }

    public IstiDialogPopup createDialog(String titleStr, Component regionParentComp) {
        return this.createDialog(titleStr, regionParentComp, null, false);
    }

    public void showDialog(Component regionParentComp, String titleStr, boolean modalFlag) {
        this.createDialog(titleStr, regionParentComp, null, modalFlag).show();
    }

    public void showDialog(Component regionParentComp, String titleStr) {
        this.createDialog(titleStr, regionParentComp, null).show();
    }

    public IstiDialogPopup getDialog() {
        return this.dialogObj;
    }

    public boolean isDialogVisible() {
        return this.dialogObj != null && this.dialogObj.isVisible();
    }

    public void requestFocus() {
        if (this.dialogObj != null) {
            this.dialogObj.requestFocus();
        }
        super.requestFocus();
    }

    public String getRegionString() {
        StringBuffer s = new StringBuffer();
        int numRegions = this.regionListDataObj.size();
        for (int i = 0; i < numRegions; ++i) {
            if (i > 0) {
                s.append("; ");
            }
            s.append(this.regionListDataObj.get(i));
        }
        return s.toString();
    }

    public void removeActionListener(ActionListener l) {
        this.panelListenerList.remove(l);
    }

    public void setHelpActionListener(ActionListener l) {
        this.helpActionListener = l;
    }

    public void setRegionString(String str) {
        String[] subStr = UtilFns.parseSeparatedSubstrings(str, ";");
        int numRegions = subStr.length;
        this.regionListDataObj.clear();
        for (int i = 0; i < numRegions; ++i) {
            this.regionListDataObj.add(subStr[i].trim());
        }
        this.regionJListObj.setListData(this.regionListDataObj);
        if (this.regionListDataObj.size() > 0) {
            this.selectAndShowListRegion(0);
        }
        this.notifyRegionsUpdated();
    }

    protected void addNewRegion(boolean circleFlag) {
        String regionStr;
        regionStr = this.istiRegionMgrObj != null && (regionStr = this.istiRegionMgrObj.checkGenerateRegionName(this.newRegionNameStr)) != null && regionStr.length() > 0 ? "\"" + regionStr + "\"" : "";
        this.openRegionEditPanel(regionStr, this.regionEditPanels.size());
        this.regionEditPanel.createDialog(this, true, this.regionEditParentComp, this.dialogModalFlag, this.centerEditDialogFlag);
        this.regionEditPanel.setCircle(circleFlag);
        int retVal = this.regionEditPanel.showDialog();
        if (retVal == 0 && (regionStr = this.regionEditPanel.getRegionString()).length() > 0) {
            this.regionListDataObj.add(regionStr);
            this.regionJListObj.setListData(this.regionListDataObj);
            this.selectAndShowListRegion(this.regionListDataObj.indexOf(regionStr));
            this.regionJListObj.repaint();
            this.notifyRegionsUpdated();
        }
        this.closeRegionEditPanel();
    }

    protected void editSelectedRegion() {
        Object obj;
        if (this.regionJListObj.getModel().getSize() > 0 && (obj = this.regionJListObj.getSelectedValue()) instanceof String) {
            this.editSpecifiedRegion((String)obj, this.regionJListObj.getSelectedIndex());
        }
    }

    protected void editSpecifiedRegion(String specStr, int specIdx) {
        String editStr;
        boolean addFlag = specIdx < 0;
        this.openRegionEditPanel(specStr, addFlag ? this.regionEditPanels.size() : specIdx);
        this.regionEditPanel.createDialog(this, addFlag, this.regionEditParentComp, this.dialogModalFlag, this.centerEditDialogFlag);
        int retVal = this.regionEditPanel.showDialog();
        if (retVal == 0 && (editStr = this.regionEditPanel.getRegionString()).length() > 0 && (addFlag || !editStr.equals(specStr))) {
            if (addFlag) {
                this.regionListDataObj.add(editStr);
                this.regionJListObj.setListData(this.regionListDataObj);
                this.selectAndShowListRegion(this.regionListDataObj.indexOf(editStr));
            } else {
                this.regionListDataObj.set(specIdx, editStr);
            }
            this.regionJListObj.repaint();
            this.notifyRegionsUpdated();
        }
        this.closeRegionEditPanel();
    }

    protected void copyToNewRegion() {
        String srcRegionStr;
        Object selRegionObj;
        Object v0 = selRegionObj = this.regionJListObj.getModel().getSize() > 0 ? this.regionJListObj.getSelectedValue() : null;
        if (this.istiRegionMgrObj != null && this.istiRegionMgrObj.getAllRegionsCount() > 0) {
            Object obj;
            Vector regStrsVec = this.istiRegionMgrObj.getAllRegionStrsList();
            JList sourceJListObj = new JList(regStrsVec);
            int selIdx = regStrsVec.indexOf(selRegionObj);
            if (selIdx >= 0) {
                sourceJListObj.setSelectedIndex(selIdx);
            } else if (regStrsVec.size() > 0) {
                sourceJListObj.setSelectedIndex(0);
            }
            JScrollPane paneObj = new JScrollPane(sourceJListObj);
            paneObj.setPreferredSize(new Dimension(500, 150));
            final IstiDialogPopup popupObj = new IstiDialogPopup((Component)this, (Object)paneObj, "Select Source Region for Copy", false, 2);
            sourceJListObj.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evtObj) {
                    if (evtObj.getClickCount() >= 2) {
                        popupObj.close(new Integer(0));
                    }
                }
            });
            this.setButtonsEnabled(false);
            if (popupObj.showAndReturnIndex() != 0 || (selIdx = sourceJListObj.getSelectedIndex()) < 0 || selIdx >= regStrsVec.size() || !((obj = regStrsVec.get(selIdx)) instanceof String)) {
                this.setButtonsEnabled(true);
                return;
            }
            srcRegionStr = (String)obj;
        } else {
            if (!(selRegionObj instanceof String)) {
                return;
            }
            srcRegionStr = selRegionObj;
        }
        String oldNameStr = IstiRegion.extractRegionName(srcRegionStr);
        if (this.istiRegionMgrObj != null && this.istiRegionMgrObj.getAllRegionsCount() > 0) {
            String newNameStr = oldNameStr.length() > 0 ? this.istiRegionMgrObj.checkGenerateRegionName(oldNameStr + '_') : this.istiRegionMgrObj.checkGenerateRegionName(this.newRegionNameStr);
            srcRegionStr = IstiRegion.replaceRegionName(srcRegionStr, newNameStr);
        } else if (oldNameStr.length() > 0) {
            srcRegionStr = IstiRegion.replaceRegionName(srcRegionStr, "Copy of " + oldNameStr);
        }
        this.editSpecifiedRegion(srcRegionStr, -1);
    }

    protected void closeRegionEditPanel() {
        this.regionEditPanel = null;
        this.setButtonsEnabled(true);
    }

    protected void fireActionPerformed(ActionEvent event) {
        Object[] listeners = this.panelListenerList.toArray();
        for (int i = listeners.length - 1; i >= 0; --i) {
            ((ActionListener)listeners[i]).actionPerformed(event);
        }
    }

    public void notifyHelpActionListener(Object source) {
        if (this.helpActionListener != null) {
            this.helpActionListener.actionPerformed(new ActionEvent(source, 0, "Help pressed"));
        }
    }

    public boolean isHelpActionListenerInstalled() {
        return this.helpActionListener != null;
    }

    protected void notifyRegionsUpdated() {
        this.fireActionPerformed(new ActionEvent(this, 1001, "region updated"));
    }

    protected void openRegionEditPanel(String regionStr, int regionIndex) {
        Object tableObj;
        if (regionIndex < this.regionEditPanels.size()) {
            tableObj = this.regionEditPanels.get(regionIndex);
        } else {
            tableObj = null;
            this.regionEditPanels.setSize(regionIndex + 1);
        }
        if (tableObj instanceof IstiRegionEditPanel) {
            this.regionEditPanel = tableObj;
            this.regionEditPanel.setRegionString(regionStr);
        } else {
            this.regionEditPanel = new IstiRegionEditPanel(this.optionGroups, regionStr);
            this.regionEditPanels.set(regionIndex, this.regionEditPanel);
        }
        this.setButtonsEnabled(false);
    }

    protected void removeSelectedRegions() {
        String confirmRemovalStr = "Confirm Removal";
        Object[] selObjsArr = this.regionJListObj.getModel().getSize() > 0 ? this.regionJListObj.getSelectedValues() : new Object[]{};
        int numSel = selObjsArr.length;
        if (numSel > 0) {
            if (numSel > 1) {
                if (this.dialogUtilObj.popupYesNoConfirmMessage("Remove the " + numSel + " selected regions?", "Confirm Removal", false) != 0) {
                    return;
                }
                for (int idx = 0; idx < numSel; ++idx) {
                    Object obj = selObjsArr[idx];
                    if (!(obj instanceof String)) continue;
                    this.regionListDataObj.remove(obj);
                }
            } else {
                String regionText;
                Object obj = selObjsArr[0];
                if (!(obj instanceof String)) {
                    return;
                }
                String regionStr = (String)obj;
                IstiRegion region = IstiRegion.parse(regionStr);
                if (region == null || (regionText = region.getName()).trim().length() <= 0) {
                    int regionNum = this.regionJListObj.getSelectedIndex() + 1;
                    regionText = Integer.toString(regionNum);
                }
                if (this.dialogUtilObj.popupYesNoConfirmMessage("Remove region \"" + regionText + "\"?", "Confirm Removal", false) != 0) {
                    return;
                }
                this.regionListDataObj.remove(obj);
            }
            this.regionJListObj.setListData(this.regionListDataObj);
            this.regionJListObj.repaint();
            this.notifyRegionsUpdated();
            this.selectAndShowListRegion(0);
        }
    }

    protected void selectAndShowListRegion(final int idx) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    IstiRegionPanel.this.regionJListObj.setSelectedIndex(idx);
                    IstiRegionPanel.this.regionJListObj.ensureIndexIsVisible(idx);
                }
                catch (Exception ex) {
                    System.err.println("Error selecting list entry:  " + ex);
                    ex.printStackTrace();
                }
            }
        });
    }

    protected void setButtonsEnabled(boolean b) {
        this.addCircleButton.setEnabled(b);
        this.addPolyButton.setEnabled(b);
        this.editButton.setEnabled(b);
        this.removeButton.setEnabled(b);
        this.copyButton.setEnabled(b);
        this.mouseClickEditFlag = b;
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        if (!this.dialogModalFlag && this.regionEditPanel != null) {
            this.regionEditPanel.closeDialog();
        }
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

