/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.IstiNamedValue;
import com.isti.util.UtilFns;
import com.isti.util.gui.textvalidator.TextValidator;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class GuiUtilFns {
    public static final char defaultWidthChar = 'm';
    public static int DEF_PAD_WIDTH = 4;
    private static JLabel utilLabelObj = null;
    private static Font utilFontObj = null;
    private static FontMetrics utilMetricsObj = null;
    private static final String SPACE_STR = " ";
    private static final int DEF_SPACE_WIDTH = 4;
    private static Method compSetPreferredSizeMethodObj = null;
    private static Method frameGetExtendedStateMethodObj = null;
    private static Method frameSetExtendedStateMethodObj = null;
    private static Method getMaximumWindowBoundsMethodObj = null;
    private static int FRAME_MAXIMIZED_BOTH = 6;
    static /* synthetic */ Class class$java$awt$Dimension;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$java$awt$GraphicsEnvironment;

    private GuiUtilFns() {
    }

    public static void ensureSelectionVisible(JTable tableObj) {
        int selIdx = tableObj.getSelectedRow();
        if (selIdx >= 0) {
            GuiUtilFns.ensureRowVisible(tableObj, selIdx);
        }
    }

    public static void ensureRowVisible(JTable tableObj, int row) {
        tableObj.scrollRectToVisible(tableObj.getCellRect(row, 0, false));
    }

    public static int getMaxCharWidth(Component compObj) {
        return GuiUtilFns.getMaxCharWidth(compObj, 'm');
    }

    public static int getMaxCharWidth(Component compObj, char widthChar) {
        return compObj.getFontMetrics(compObj.getFont()).charWidth(widthChar);
    }

    public static int getMaxCharWidth(Component compObj, String specialChars, boolean allowedFlag) {
        return (Integer)GuiUtilFns.getMaxCharWidthValue(compObj, specialChars, allowedFlag).getValue();
    }

    public static IstiNamedValue getMaxCharWidthValue(Component compObj, String specialChars, boolean allowedFlag) {
        int maxWidth = 0;
        IstiNamedValue value = GuiUtilFns.createNamedValue('m', 0);
        if (specialChars == null) {
            return value;
        }
        int[] widths = compObj.getFontMetrics(compObj.getFont()).getWidths();
        if (allowedFlag) {
            for (int index = 0; index < specialChars.length(); ++index) {
                int charWidth;
                char ch = specialChars.charAt(index);
                if (ch >= widths.length || (charWidth = widths[ch]) <= maxWidth) continue;
                maxWidth = charWidth;
                value = GuiUtilFns.createNamedValue(ch, charWidth);
            }
        } else {
            for (char ch = '\u0000'; ch < widths.length; ch = (char)((char)(ch + 1))) {
                int charWidth;
                if (specialChars.indexOf(ch) < 0 == allowedFlag || (charWidth = widths[ch]) <= maxWidth) continue;
                maxWidth = charWidth;
                value = GuiUtilFns.createNamedValue(ch, charWidth);
            }
        }
        return value;
    }

    private static IstiNamedValue createNamedValue(char ch, int charWidth) {
        return new IstiNamedValue(String.valueOf(ch), new Integer(charWidth));
    }

    public static int getMaxCharWidth(Component compObj, TextValidator tv) {
        return GuiUtilFns.getMaxCharWidth(compObj, tv.getSpecialChars(), tv.getAllowedFlag());
    }

    public static int getStringWidth(Component compObj, Font fontObj, String str, int defWidthVal) {
        try {
            if (compObj == null) {
                if (fontObj == null) {
                    if (utilMetricsObj != null) {
                        return utilMetricsObj.stringWidth(str);
                    }
                    if (utilLabelObj == null) {
                        utilLabelObj = new JLabel();
                    }
                    if (utilFontObj == null) {
                        utilFontObj = utilLabelObj.getFont();
                    }
                    utilMetricsObj = utilLabelObj.getFontMetrics(utilFontObj);
                    return utilMetricsObj.stringWidth(str);
                }
                if (utilLabelObj == null) {
                    utilLabelObj = new JLabel();
                }
                compObj = utilLabelObj;
            } else if (fontObj == null) {
                fontObj = compObj.getFont();
            }
            return compObj.getFontMetrics(fontObj).stringWidth(str);
        }
        catch (Exception ex) {
            return defWidthVal;
        }
    }

    public static int getStringWidth(Component compObj, String str, int defWidthVal) {
        return GuiUtilFns.getStringWidth(compObj, null, str, defWidthVal);
    }

    public static int getStringWidth(Font fontObj, String str, int defWidthVal) {
        return GuiUtilFns.getStringWidth(null, fontObj, str, defWidthVal);
    }

    public static int getStringWidth(Component compObj, Font fontObj, String str) {
        return GuiUtilFns.getStringWidth(compObj, fontObj, str, 0);
    }

    public static int getStringWidth(Font fontObj, String str) {
        return GuiUtilFns.getStringWidth(null, fontObj, str, 0);
    }

    public static int getStringWidth(Component compObj, String str) {
        return GuiUtilFns.getStringWidth(compObj, null, str, 0);
    }

    public static int getStringWidth(String str, int defWidthVal) {
        return GuiUtilFns.getStringWidth(null, null, str, defWidthVal);
    }

    public static int getStringWidth(String str) {
        return GuiUtilFns.getStringWidth(null, null, str, 0);
    }

    public static String getSpacerStrForWidth(int widthVal, int spaceCharSize) {
        if (spaceCharSize <= 0 && (spaceCharSize = GuiUtilFns.getStringWidth(SPACE_STR)) <= 0) {
            spaceCharSize = 4;
        }
        return UtilFns.getSpacerString(widthVal / spaceCharSize);
    }

    public static String getSpacerStrForWidth(int widthVal, Component compObj, Font fontObj, int defWidthVal) {
        return GuiUtilFns.getSpacerStrForWidth(widthVal, GuiUtilFns.getStringWidth(compObj, fontObj, SPACE_STR, defWidthVal));
    }

    public static String getSpacerStrForWidth(int widthVal, Component compObj, Font fontObj) {
        return GuiUtilFns.getSpacerStrForWidth(widthVal, GuiUtilFns.getStringWidth(compObj, fontObj, SPACE_STR, 4));
    }

    public static String getSpacerStrForWidth(int widthVal, Component compObj, int defWidthVal) {
        return GuiUtilFns.getSpacerStrForWidth(widthVal, GuiUtilFns.getStringWidth(compObj, null, SPACE_STR, defWidthVal));
    }

    public static String getSpacerStrForWidth(int widthVal, Component compObj) {
        return GuiUtilFns.getSpacerStrForWidth(widthVal, GuiUtilFns.getStringWidth(compObj, null, SPACE_STR, 4));
    }

    public static void setScrollPaneCentered(final JScrollPane paneObj) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    JScrollBar barObj = paneObj.getHorizontalScrollBar();
                    barObj.setValue((barObj.getMaximum() - barObj.getVisibleAmount() + barObj.getMinimum()) / 2);
                    barObj = paneObj.getVerticalScrollBar();
                    barObj.setValue((barObj.getMaximum() - barObj.getVisibleAmount() + barObj.getMinimum()) / 2);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public static void setEmptyJListWidth(final JList listObj, final int widthVal) {
        if (listObj.getModel().getSize() <= 0) {
            listObj.setFixedCellWidth(widthVal);
        }
        listObj.getModel().addListDataListener(new ListDataListener(){
            private boolean fixedCellWidthFlag;
            {
                this.fixedCellWidthFlag = listObj.getModel().getSize() <= 0;
            }

            public void intervalAdded(ListDataEvent evtObj) {
                if (this.fixedCellWidthFlag) {
                    this.fixedCellWidthFlag = false;
                    listObj.setFixedCellWidth(-1);
                }
            }

            public void intervalRemoved(ListDataEvent evtObj) {
                if (!this.fixedCellWidthFlag && listObj.getModel().getSize() <= 0) {
                    this.fixedCellWidthFlag = true;
                    listObj.setFixedCellWidth(widthVal);
                }
            }

            public void contentsChanged(ListDataEvent evtObj) {
                if (this.fixedCellWidthFlag) {
                    if (listObj.getModel().getSize() > 0) {
                        this.fixedCellWidthFlag = false;
                        listObj.setFixedCellWidth(-1);
                    }
                } else if (listObj.getModel().getSize() <= 0) {
                    this.fixedCellWidthFlag = true;
                    listObj.setFixedCellWidth(widthVal);
                }
            }
        });
    }

    public static int getExtendedFrameState(Frame frameObj) {
        try {
            Object obj;
            if (frameGetExtendedStateMethodObj != null && (obj = frameGetExtendedStateMethodObj.invoke((Object)frameObj, null)) instanceof Integer) {
                return (Integer)obj;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return frameObj.getState();
    }

    public static boolean setExtendedFrameState(Frame frameObj, int stateVal) {
        try {
            if (frameSetExtendedStateMethodObj != null) {
                frameSetExtendedStateMethodObj.invoke((Object)frameObj, (Object[])new Integer[]{new Integer(stateVal)});
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void initColumnSizes(JTable tableObj) {
        TableModel model = tableObj.getModel();
        int maxRow = model.getRowCount();
        boolean row = false;
        int maxCol = model.getColumnCount();
        TableCellRenderer headerRenderer = tableObj.getTableHeader().getDefaultRenderer();
        TableColumnModel tableColumnModel = tableObj.getColumnModel();
        for (int col = 0; col < maxCol; ++col) {
            int modelCol = tableObj.convertColumnIndexToModel(col);
            TableColumn tableColumn = tableColumnModel.getColumn(col);
            Component comp = headerRenderer.getTableCellRendererComponent(null, tableColumn.getHeaderValue(), false, false, 0, 0);
            int width = comp.getPreferredSize().width;
            if (0 < maxRow) {
                comp = tableObj.getDefaultRenderer(model.getColumnClass(modelCol)).getTableCellRendererComponent(tableObj, model.getValueAt(0, modelCol), false, false, 0, col);
                width = Math.max(width, comp.getPreferredSize().width);
            }
            tableColumn.setPreferredWidth(width);
        }
    }

    public static boolean isFrameMaximized(Frame frameObj) {
        return (GuiUtilFns.getExtendedFrameState(frameObj) & FRAME_MAXIMIZED_BOTH) == FRAME_MAXIMIZED_BOTH;
    }

    public static boolean maximizeFrame(Frame frameObj) {
        return GuiUtilFns.setExtendedFrameState(frameObj, FRAME_MAXIMIZED_BOTH);
    }

    public static int getFrameMaximizedBothValue() {
        return FRAME_MAXIMIZED_BOTH;
    }

    public static Rectangle getMaximumWindowBounds() {
        try {
            Object obj;
            if (getMaximumWindowBoundsMethodObj != null && (obj = getMaximumWindowBoundsMethodObj.invoke((Object)GraphicsEnvironment.getLocalGraphicsEnvironment(), null)) instanceof Rectangle) {
                return (Rectangle)obj;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
    }

    public static boolean setPreferredSize(Component compObj, Dimension dimObj) {
        try {
            if (compSetPreferredSizeMethodObj != null) {
                compSetPreferredSizeMethodObj.invoke((Object)compObj, dimObj);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static final void setPreferredSize(Component compObj, int maxNumChars, int maxCharWidth) {
        int padWidth = 0;
        if (compObj instanceof JComboBox) {
            padWidth = DEF_PAD_WIDTH;
        }
        GuiUtilFns.setPreferredSize(compObj, maxNumChars, maxCharWidth, padWidth);
    }

    public static final void setPreferredSize(Component compObj, int maxNumChars, int maxCharWidth, int padWidth) {
        Dimension preferredSize = compObj.getPreferredSize();
        if (maxNumChars != 0) {
            preferredSize.width += padWidth + maxNumChars * maxCharWidth;
            if (!GuiUtilFns.setPreferredSize(compObj, preferredSize) && compObj instanceof JComponent) {
                ((JComponent)compObj).setPreferredSize(preferredSize);
            }
        }
    }

    public static final void setPreferredSize(JComponent compObj, int maxNumChars) {
        GuiUtilFns.setPreferredSize(compObj, maxNumChars, GuiUtilFns.getMaxCharWidth(compObj));
    }

    public static final void setPreferredSize(Component compObj, TextValidator tv) {
        GuiUtilFns.setPreferredSize(compObj, tv.getMaxNumChars(), GuiUtilFns.getMaxCharWidth(compObj, tv));
    }

    public static void setButtonsContentAreaFilled(Container contObj, boolean flgVal) {
        try {
            Component[] compArr = contObj.getComponents();
            for (int i = 0; i < compArr.length; ++i) {
                Component compObj = contObj.getComponent(i);
                if (compObj instanceof AbstractButton) {
                    ((AbstractButton)compObj).setContentAreaFilled(flgVal);
                    continue;
                }
                if (!(compObj instanceof Container)) continue;
                GuiUtilFns.setButtonsContentAreaFilled((Container)compObj, flgVal);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            compSetPreferredSizeMethodObj = (class$java$awt$Component == null ? (class$java$awt$Component = GuiUtilFns.class$("java.awt.Component")) : class$java$awt$Component).getMethod("setPreferredSize", class$java$awt$Dimension == null ? (class$java$awt$Dimension = GuiUtilFns.class$("java.awt.Dimension")) : class$java$awt$Dimension);
            frameGetExtendedStateMethodObj = (class$java$awt$Frame == null ? (class$java$awt$Frame = GuiUtilFns.class$("java.awt.Frame")) : class$java$awt$Frame).getMethod("getExtendedState", null);
            frameSetExtendedStateMethodObj = (class$java$awt$Frame == null ? (class$java$awt$Frame = GuiUtilFns.class$("java.awt.Frame")) : class$java$awt$Frame).getMethod("setExtendedState", Integer.TYPE);
            getMaximumWindowBoundsMethodObj = (class$java$awt$GraphicsEnvironment == null ? (class$java$awt$GraphicsEnvironment = GuiUtilFns.class$("java.awt.GraphicsEnvironment")) : class$java$awt$GraphicsEnvironment).getMethod("getMaximumWindowBounds", null);
            FRAME_MAXIMIZED_BOTH = (class$java$awt$Frame == null ? (class$java$awt$Frame = GuiUtilFns.class$("java.awt.Frame")) : class$java$awt$Frame).getField("MAXIMIZED_BOTH").getInt(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

