/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.database;

import com.isti.util.CallBackCompletion;
import com.isti.util.database.ConnectionJDBC;
import java.sql.SQLException;

public class OracleConnectionJDBC
extends ConnectionJDBC {
    protected static final String ORACLE_DRIVER_NAME = "oracle.jdbc.driver.OracleDriver";
    public static final String ORACLE_SUBPROTOCOL = "oracle";
    public static final String ORACALE_SUBNAME = "oci8";
    public static final String ORACALE_THIN_SUBNAME = "thin";
    public static final String ORACLE_URL = OracleConnectionJDBC.getURL("oracle", "oci8");
    public static final String ORACLE_THIN_URL = OracleConnectionJDBC.getURL("oracle", "thin");
    private static boolean oracleDriverLoaded = false;

    public static String getURL(String subProtocol, String subName) {
        return "jdbc:" + subProtocol + ":" + subName + ":@";
    }

    public static void registerDriver() throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        if (!oracleDriverLoaded) {
            ConnectionJDBC.registerDriver(ORACLE_DRIVER_NAME);
            oracleDriverLoaded = true;
        }
    }

    public static void deregisterDriver() throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        if (oracleDriverLoaded) {
            ConnectionJDBC.deregisterDriver(ORACLE_DRIVER_NAME);
            oracleDriverLoaded = false;
        }
    }

    public OracleConnectionJDBC(String userName, String passWord, CallBackCompletion callBack) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        this(ORACLE_URL, userName, passWord, callBack);
    }

    public OracleConnectionJDBC(String hostName, int port, String sid, String userName, String passWord, CallBackCompletion callBack) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        this(ORACLE_THIN_URL + hostName + ":" + port + ":" + sid, userName, passWord, callBack);
    }

    public OracleConnectionJDBC(String url, String userName, String passWord, CallBackCompletion callBack) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        super(url, userName, passWord, callBack);
    }
}

