/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.FifoHashtable;

public class TagValueTable {
    protected final FifoHashtable hashTableObj;

    public TagValueTable() {
        this.hashTableObj = new FifoHashtable();
    }

    protected TagValueTable(FifoHashtable hashTableObj) {
        this.hashTableObj = hashTableObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String tagStr, long value) {
        FifoHashtable fifoHashtable = this.hashTableObj;
        synchronized (fifoHashtable) {
            Object obj = this.hashTableObj.get(tagStr);
            if (obj instanceof MutableLong) {
                ((MutableLong)obj).setValue(value);
            } else {
                this.hashTableObj.put(tagStr, this.createMutableLong(value));
            }
        }
    }

    public long get(String tagStr) {
        Object obj = this.hashTableObj.get(tagStr);
        return obj instanceof MutableLong ? ((MutableLong)obj).getValue() : 0L;
    }

    public Long getLong(String tagStr) {
        Object obj = this.hashTableObj.get(tagStr);
        return obj instanceof MutableLong ? new Long(((MutableLong)obj).getValue()) : null;
    }

    public MutableLong getMutableLong(String tagStr) {
        Object obj = this.hashTableObj.get(tagStr);
        return obj instanceof MutableLong ? (MutableLong)obj : null;
    }

    public MutableLong remove(String tagStr) {
        Object obj = this.hashTableObj.remove(tagStr);
        return obj instanceof MutableLong ? (MutableLong)obj : null;
    }

    public MutableLong createMutableLong(long value) {
        return new MutableLong(value);
    }

    public int getNumEntries() {
        return this.hashTableObj.size();
    }

    public Object clone() {
        return new TagValueTable(this.hashTableObj);
    }

    public String getEntriesListStr(String sepStr) {
        return this.hashTableObj.toQuotedStrings(sepStr, true, false, true);
    }

    public String getEntriesListStr() {
        return this.getEntriesListStr(",");
    }

    public static TagValueTable entriesListStrToTable(String listStr) {
        FifoHashtable tableObj = FifoHashtable.quotedStringsToTable(listStr, ',', false);
        if (tableObj == null) {
            return null;
        }
        int tSize = tableObj.size();
        for (int i = 0; i < tSize; ++i) {
            MutableLong mutLongObj;
            Object obj = tableObj.elementAt(i);
            if (!(obj instanceof String) || (mutLongObj = MutableLong.stringToObj((String)obj)) == null) {
                return null;
            }
            tableObj.setElementAt(mutLongObj, i);
        }
        return new TagValueTable(tableObj);
    }

    public static class MutableLong {
        private long value;

        public MutableLong(long value) {
            this.value = value;
        }

        public void setValue(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }

        public String toString() {
            return Long.toString(this.value);
        }

        public static MutableLong stringToObj(String str) {
            try {
                int p = str.startsWith("+") ? 1 : 0;
                return new MutableLong(Long.parseLong(str.substring(p).trim()));
            }
            catch (NumberFormatException ex) {
                return null;
            }
            catch (NullPointerException ex) {
                return null;
            }
        }
    }
}

