/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.CircularBuffer;
import com.isti.util.DataChangedListener;
import com.isti.util.FileUtils;
import com.isti.util.LogOutputStream;
import com.isti.util.UtilFns;
import com.isti.util.logging.AbstractIstiLogger;
import com.isti.util.logging.IstiConsoleLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class LogFile
extends IstiConsoleLogger {
    public static final int NO_LEVEL = 998;
    private static final int MIN_LEVEL_VAL = -999;
    private static final int MAX_LEVEL_VAL = 999;
    public static final boolean DEFAULT_GMT_FLAG = false;
    public static final boolean DEFAULT_USE_DATE_IN_FNAME_FLAG = false;
    public static final String FNAME_DATE_SEPSTR = "_";
    public static final String FILE_DATE_PATTERNSTR = "yyyyMMdd";
    public static final String SHORT_DATE_PATTERNSTR = "MMM dd yyyy HH:mm:ss";
    public static final String LONG_DATE_PATTERNSTR = "MMMM dd, yyyy HH:mm:ss z";
    private String logFileName = null;
    private PrintWriter logWriter = null;
    private final String baseFileName;
    private int logFileLevel = 999;
    private final DateFormat fileDateFormatter = UtilFns.createDateFormatObj("yyyyMMdd");
    private final DateFormat shortDateFormatter = UtilFns.createDateFormatObj("MMM dd yyyy HH:mm:ss");
    private final DateFormat longDateFormatter = UtilFns.createDateFormatObj("MMMM dd, yyyy HH:mm:ss z");
    private static final Object staticLogsSyncObj = new Object();
    private static LogFile globalLogObj = null;
    private static LogFile consoleLogObj = null;
    private static LogFile nullLogObj = null;
    private final boolean useDateInFnameFlag;
    private final boolean writeHdrFdrFlag;
    private final File directoryObj;
    private String logFileFilterStr = "*.log";
    private int maxLogFileAge = 0;
    private long logFileStartTime = 0L;
    private long logFileSwitchIntervalMS = 86400000L;
    private boolean writeDatePrefixFlag = true;
    private static Vector levelNamesVector = null;
    private static String[] levelNamesArray = null;
    private CircularBuffer msgTrackingBufferObj = null;
    private int msgTrackingBuffLevel = 999;
    private ArrayList trackedMsgListenersList = null;

    public LogFile(String fName, int logFileLevel, int consoleLevel, boolean gmtFlag, boolean useDateInFnameFlag, boolean writeHdrFdrFlag) {
        super(consoleLevel);
        this.baseFileName = fName;
        this.useDateInFnameFlag = useDateInFnameFlag;
        this.writeHdrFdrFlag = writeHdrFdrFlag;
        if (logFileLevel >= 999 || this.baseFileName == null || this.baseFileName.length() < 1) {
            this.directoryObj = null;
            return;
        }
        this.directoryObj = new File(this.baseFileName).getParentFile();
        if (gmtFlag) {
            this.fileDateFormatter.setTimeZone(UtilFns.GMT_TIME_ZONE_OBJ);
            this.shortDateFormatter.setTimeZone(UtilFns.GMT_TIME_ZONE_OBJ);
            this.longDateFormatter.setTimeZone(UtilFns.GMT_TIME_ZONE_OBJ);
        }
        this.logFileFilterStr = FileUtils.addStrToFileName(this.baseFileName, "_*");
        this.determineLogFileName(new Date());
        this.logFileLevel = logFileLevel;
    }

    public LogFile(String fName, int logFileLevel, int consoleLevel, boolean gmtFlag, boolean useDateInFnameFlag) {
        this(fName, logFileLevel, consoleLevel, gmtFlag, useDateInFnameFlag, true);
    }

    public LogFile(String fName, int logFileLevel, int consoleLevel, boolean gmtFlag) {
        this(fName, logFileLevel, consoleLevel, gmtFlag, false, true);
    }

    public LogFile(String fName, int logFileLevel, int consoleLevel) {
        this(fName, logFileLevel, consoleLevel, false, false, true);
    }

    public int getMaxLogFileAge() {
        return this.maxLogFileAge;
    }

    public synchronized void setMaxLogFileAge(int maxAge) {
        this.maxLogFileAge = maxAge;
        if (this.useDateInFnameFlag) {
            this.deleteOldLogFiles();
        }
    }

    public synchronized void setLogFileSwitchIntervalDays(int numDays) {
        this.logFileSwitchIntervalMS = (long)numDays * 86400000L;
    }

    public synchronized void setWriteDatePrefixFlag(boolean flgVal) {
        this.writeDatePrefixFlag = flgVal;
    }

    public synchronized void setupMessageTracking(int msgLevel, int msgCount) {
        if (msgLevel <= 3 && msgCount > 0) {
            this.msgTrackingBuffLevel = msgLevel;
            this.msgTrackingBufferObj = new CircularBuffer(msgCount);
        } else {
            this.msgTrackingBufferObj = null;
            this.msgTrackingBuffLevel = 999;
        }
    }

    public synchronized String[] getTrackedMessages(int maxAgeMs) {
        if (this.msgTrackingBufferObj != null) {
            try {
                if (maxAgeMs <= 0) {
                    return this.msgTrackingBufferObj.getStrBufferItems();
                }
                Date minDateObj = new Date(System.currentTimeMillis() - (long)maxAgeMs);
                Object[] objsArr = this.msgTrackingBufferObj.getBufferItems();
                int numItems = objsArr.length;
                if (numItems <= 0) {
                    return new String[0];
                }
                List<Object> listObj = Arrays.asList(objsArr);
                int i = numItems - 1;
                do {
                    Object obj;
                    if ((obj = listObj.get(i)) instanceof TrackedDatedMessage) {
                        TrackedDatedMessage datedMsgObj = (TrackedDatedMessage)obj;
                        if (datedMsgObj.dateObj != null && minDateObj.compareTo(datedMsgObj.dateObj) > 0) {
                            listObj = listObj.subList(i + 1, numItems);
                            break;
                        }
                        listObj.set(i, datedMsgObj.messageStr);
                        continue;
                    }
                    if (obj instanceof String) continue;
                    listObj.set(i, obj.toString());
                } while (--i >= 0);
                return listObj.toArray(new String[listObj.size()]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public synchronized String[] getTrackedMessages() {
        return this.getTrackedMessages(0);
    }

    public synchronized String getTrackedMsgsAsString(String sepStr, int maxAgeMs) {
        String[] strArr = this.getTrackedMessages(maxAgeMs);
        if (strArr == null) {
            return null;
        }
        if (sepStr == null) {
            sepStr = "";
        }
        StringBuffer buff = new StringBuffer();
        if (strArr.length > 0) {
            int idx = 0;
            while (true) {
                buff.append(strArr[idx]);
                if (++idx >= strArr.length) break;
                buff.append(sepStr);
            }
        }
        return buff.toString();
    }

    public synchronized String getTrackedMsgsAsString(String sepStr) {
        return this.getTrackedMsgsAsString(sepStr, 0);
    }

    public synchronized void addTrackedMsgListener(DataChangedListener listenerObj) {
        if (this.trackedMsgListenersList == null) {
            this.trackedMsgListenersList = new ArrayList();
        }
        this.trackedMsgListenersList.add(listenerObj);
    }

    public synchronized void removeTrackedMsgListener(DataChangedListener listenerObj) {
        if (this.trackedMsgListenersList != null) {
            this.trackedMsgListenersList.remove(listenerObj);
            if (this.trackedMsgListenersList.size() <= 0) {
                this.trackedMsgListenersList = null;
            }
        }
    }

    private void fireTrackedMsgListeners() {
        if (this.trackedMsgListenersList != null) {
            Iterator iterObj = ((AbstractList)this.trackedMsgListenersList).iterator();
            while (iterObj.hasNext()) {
                ((DataChangedListener)iterObj.next()).dataChanged(this);
            }
        }
    }

    private void determineLogFileName(Date dateObj) {
        long currentTimeVal = System.currentTimeMillis();
        if (this.logFileStartTime <= 0L || this.useDateInFnameFlag && this.logFileSwitchIntervalMS > 0L && currentTimeVal - this.logFileStartTime >= this.logFileSwitchIntervalMS) {
            String newLogFileName;
            if (this.useDateInFnameFlag) {
                Calendar calObj = Calendar.getInstance(this.getDateFormat().getTimeZone());
                calObj.setTime(new Date(currentTimeVal));
                calObj.set(11, 0);
                calObj.set(12, 0);
                calObj.set(13, 0);
                calObj.set(14, 0);
                this.logFileStartTime = calObj.getTime().getTime();
            } else {
                this.logFileStartTime = currentTimeVal;
            }
            if (this.useDateInFnameFlag) {
                String dateText = FNAME_DATE_SEPSTR + this.fileDateFormatter.format(dateObj);
                newLogFileName = FileUtils.addStrToFileName(this.baseFileName, dateText);
            } else {
                newLogFileName = this.baseFileName;
            }
            if (!newLogFileName.equals(this.logFileName)) {
                boolean writeContinuedFrom = false;
                if (this.writeHdrFdrFlag && this.logWriter != null) {
                    writeContinuedFrom = true;
                    this.logWriter.println("Log file continues in \"" + newLogFileName + "\"");
                }
                this.closeLogFile();
                String oldLogFileName = this.logFileName;
                this.logFileName = newLogFileName;
                this.createLogFile(dateObj);
                if (writeContinuedFrom && this.logWriter != null) {
                    this.logWriter.println("  continued from \"" + oldLogFileName + "\"");
                }
                this.deleteOldLogFiles();
            }
        }
    }

    private void deleteOldLogFiles() {
        if (this.directoryObj != null && this.maxLogFileAge > 0) {
            FileUtils.deleteOldFiles(this.directoryObj, this.maxLogFileAge, this.logFileFilterStr);
        }
    }

    private void closeLogFile() {
        if (this.logWriter != null) {
            this.logWriter.close();
            this.logWriter = null;
        }
    }

    private void createLogFile(Date dateObj) {
        try {
            FileUtils.createParentDirs(this.logFileName);
            this.logWriter = new PrintWriter((Writer)new BufferedWriter(new FileWriter(this.logFileName, true)), true);
            try {
                if (this.writeHdrFdrFlag) {
                    this.logWriter.println();
                    this.logWriter.println("Log file opened " + this.longDateFormatter.format(dateObj));
                }
                if (this.logWriter.checkError()) {
                    System.err.println("Error writing to log file \"" + this.logFileName + "\"");
                    this.logFileName = null;
                }
            }
            catch (Exception ex) {
                System.err.println("Exception writing to log file \"" + this.logFileName + "\":  " + ex);
                this.logFileName = null;
            }
        }
        catch (IOException ex) {
            System.err.println("Exception opening log file \"" + ex.getMessage() + "\":  " + ex);
            this.logFileName = null;
        }
        if (this.logFileName == null) {
            this.closeLogFile();
        }
    }

    protected synchronized boolean logMessage(int level, String str, Throwable t) {
        boolean retFlag;
        boolean logOutputFlag;
        super.logMessage(level, str, t);
        str = this.getMessage(str, t);
        boolean msgTrkFlag = false;
        if (level < this.logFileLevel) {
            if (level < this.msgTrackingBuffLevel) {
                return true;
            }
            logOutputFlag = false;
            retFlag = true;
        } else if (this.logWriter == null) {
            if (level < this.msgTrackingBuffLevel) {
                return false;
            }
            logOutputFlag = false;
            retFlag = false;
        } else {
            logOutputFlag = true;
            retFlag = true;
        }
        try {
            String outStr;
            Date dateObj = new Date();
            String string = outStr = this.writeDatePrefixFlag ? this.getDateFormat().format(dateObj) + ":  " + str : str;
            if (level >= this.msgTrackingBuffLevel && this.msgTrackingBufferObj != null) {
                this.msgTrackingBufferObj.add(new TrackedDatedMessage(dateObj, outStr));
                msgTrkFlag = true;
            }
            if (logOutputFlag) {
                this.println(dateObj, outStr);
                if (this.logWriter.checkError()) {
                    this.logWriter.close();
                    this.logWriter = null;
                    retFlag = false;
                    System.err.println("Error writing to log file \"" + this.logFileName + "\"");
                }
            }
        }
        catch (Exception ex) {
            if (this.logWriter != null) {
                this.logWriter.close();
                this.logWriter = null;
            }
            retFlag = false;
        }
        if (msgTrkFlag) {
            this.fireTrackedMsgListeners();
        }
        return retFlag;
    }

    protected String getMessage(int level) {
        if (level < 998) {
            return super.getMessage(level);
        }
        return "";
    }

    public boolean println(String str) {
        return this.println(998, str);
    }

    private void println(Date dateObj, String str) {
        this.determineLogFileName(dateObj);
        this.logWriter.println(str);
    }

    public synchronized void close() {
        if (this.logWriter != null) {
            if (this.writeHdrFdrFlag) {
                Date dateObj = new Date();
                this.println(dateObj, "Log file closed " + this.longDateFormatter.format(dateObj));
            }
            this.logWriter.close();
            this.logWriter = null;
        }
    }

    public LogOutputStream getLogOutputStream() {
        return new LogOutputStream(this);
    }

    public String getFileName() {
        return this.logFileName;
    }

    public boolean isOpen() {
        return this.logWriter != null;
    }

    public int getLogFileLevel() {
        return this.logFileLevel;
    }

    public synchronized void setLogFileLevel(int level) {
        this.logFileLevel = level;
    }

    public static Vector getLevelNamesVector() {
        if (levelNamesVector == null) {
            levelNamesVector = new Vector();
            for (int l = 999; l >= -999; --l) {
                String str;
                if (l == 998 || (str = AbstractIstiLogger.getLevelStringNull(l)) == null) continue;
                levelNamesVector.add(str);
            }
        }
        return levelNamesVector;
    }

    public static String[] getLevelNamesArray() {
        if (levelNamesArray == null) {
            Vector vec = LogFile.getLevelNamesVector();
            levelNamesArray = vec.toArray(new String[vec.size()]);
        }
        return levelNamesArray;
    }

    public static String getLevelNamesDisplayStr() {
        return UtilFns.enumToQuotedStrings(LogFile.getLevelNamesVector().elements());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogFile initGlobalLogObj(LogFile logObj) {
        Object object = staticLogsSyncObj;
        synchronized (object) {
            globalLogObj = logObj;
            return globalLogObj;
        }
    }

    public static LogFile initGlobalLogObj(String fName, int logFileLevel, int consoleLevel, boolean gmtFlag, boolean useDateInFnameFlag) {
        return LogFile.initGlobalLogObj(new LogFile(fName, logFileLevel, consoleLevel, gmtFlag, useDateInFnameFlag));
    }

    public static LogFile initGlobalLogObj(String fName, int logFileLevel, int consoleLevel, boolean gmtFlag) {
        return LogFile.initGlobalLogObj(fName, logFileLevel, consoleLevel, gmtFlag, false);
    }

    public static LogFile initGlobalLogObj(String fName, int logFileLevel, int consoleLevel) {
        return LogFile.initGlobalLogObj(fName, logFileLevel, consoleLevel, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogFile getGlobalLogObj() {
        Object object = staticLogsSyncObj;
        synchronized (object) {
            if (globalLogObj != null) {
                return globalLogObj;
            }
            return LogFile.initGlobalLogObj("default.log", 1, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogFile getGlobalLogObj(boolean consoleFlag) {
        Object object = staticLogsSyncObj;
        synchronized (object) {
            if (globalLogObj != null) {
                return globalLogObj;
            }
            if (consoleFlag) {
                return LogFile.getConsoleLogObj();
            }
            return LogFile.getNullLogObj();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogFile getConsoleLogObj() {
        Object object = staticLogsSyncObj;
        synchronized (object) {
            if (consoleLogObj == null) {
                consoleLogObj = new LogFile(null, 999, -999);
            }
            return consoleLogObj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogFile getNullLogObj() {
        Object object = staticLogsSyncObj;
        synchronized (object) {
            if (nullLogObj == null) {
                nullLogObj = new LogFile(null, 999, 999);
            }
            return nullLogObj;
        }
    }

    public DateFormat getDateFormat() {
        return this.shortDateFormatter;
    }

    private static class TrackedDatedMessage {
        public final Date dateObj;
        public final String messageStr;

        public TrackedDatedMessage(Date dateObj, String messageStr) {
            this.dateObj = dateObj;
            this.messageStr = messageStr;
        }

        public String toString() {
            return this.messageStr;
        }
    }
}

