/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.FifoHashtable;
import com.isti.util.LogFile;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class IstiTimeObjectCache {
    protected final LogFile logObj;
    protected final boolean useLookupKeyFlag;
    protected long tolerance = 0L;
    protected long defaultRemoveAge = 0L;
    protected int maximumObjectCount = 0;
    protected long maximumTotalDataSize = 0L;
    protected long totalCacheDataSize = 0L;
    protected final FifoHashtable objectCache = new FifoHashtable();
    protected long lastMsgTimeTracker = 0L;

    public IstiTimeObjectCache(LogFile logObj, long tolerance, long removeAge, boolean useLookupKeyFlag) {
        this.logObj = logObj;
        this.tolerance = tolerance;
        this.defaultRemoveAge = removeAge;
        this.useLookupKeyFlag = useLookupKeyFlag;
    }

    public IstiTimeObjectCache(LogFile logObj, long tolerance, long removeAge) {
        this.logObj = logObj;
        this.tolerance = tolerance;
        this.defaultRemoveAge = removeAge;
        this.useLookupKeyFlag = true;
    }

    public IstiTimeObjectCache(LogFile logObj, long tolerance, boolean useLookupKeyFlag) {
        this(logObj, tolerance, 0L, useLookupKeyFlag);
    }

    public IstiTimeObjectCache(LogFile logObj, long tolerance) {
        this(logObj, tolerance, 0L, true);
    }

    public void add(long timeGenerated, Object dataObj, String keyStr) {
        this.add(new BasicTimeObjectEntry(timeGenerated, dataObj, keyStr));
    }

    public Vector getAllObjects() {
        return this.objectCache.getValuesVector();
    }

    public Vector getFirstObjects(int numObjects) {
        if (numObjects > this.objectCache.size()) {
            numObjects = this.objectCache.size();
        }
        return this.objectCache.getValuesVector(0, numObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeObjectEntry getFirstObject() {
        FifoHashtable fifoHashtable = this.objectCache;
        synchronized (fifoHashtable) {
            return this.objectCache.size() > 0 ? this.getObject(0) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeObjectEntry getLastObject() {
        FifoHashtable fifoHashtable = this.objectCache;
        synchronized (fifoHashtable) {
            int cacheSize = this.objectCache.size();
            return cacheSize > 0 ? this.getObject(cacheSize - 1) : null;
        }
    }

    public LogFile getLogFile() {
        return this.logObj;
    }

    public boolean getUseLookupKeyFlag() {
        return this.useLookupKeyFlag;
    }

    public VectorWithCount getNewerObjects(long time, int maxCount) {
        return this.getObjects(time, 0L, maxCount);
    }

    public VectorWithCount getNewerObjects(long time) {
        return this.getObjects(time, 0L, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VectorWithCount getObjects(long beginTime, long endTime, int maxCount) {
        FifoHashtable fifoHashtable = this.objectCache;
        synchronized (fifoHashtable) {
            if (beginTime > 0L) {
                beginTime -= this.tolerance;
            }
            if (endTime > 0L) {
                endTime += this.tolerance;
            }
            return this.subListVector(beginTime, endTime, maxCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VectorWithCount getObjects(long beginTime, long endTime) {
        FifoHashtable fifoHashtable = this.objectCache;
        synchronized (fifoHashtable) {
            if (beginTime > 0L) {
                beginTime -= this.tolerance;
            }
            if (endTime > 0L) {
                endTime += this.tolerance;
            }
            return this.subListVector(beginTime, endTime, 0);
        }
    }

    public VectorWithCount getOlderObjects(long time, int maxCount) {
        return this.getObjects(0L, time, maxCount);
    }

    public VectorWithCount getOlderObjects(long time) {
        return this.getObjects(0L, time, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOldObjects(long removeAge) {
        boolean retFlag = false;
        FifoHashtable fifoHashtable = this.objectCache;
        synchronized (fifoHashtable) {
            int cacheSize;
            long currentTime;
            long removeTime;
            VectorWithCount listObj;
            if (removeAge > 0L && (listObj = this.subListVector(0L, removeTime = (currentTime = System.currentTimeMillis()) - removeAge, 0)).size() > 0) {
                Iterator iterObj = listObj.iterator();
                while (iterObj.hasNext()) {
                    Object obj = iterObj.next();
                    this.objectCache.removeValue(obj);
                    if (!(obj instanceof TimeObjectEntry)) continue;
                    this.totalCacheDataSize -= (long)((TimeObjectEntry)obj).getDataSize();
                }
                retFlag = true;
            }
            if (this.maximumObjectCount > 0 && (cacheSize = this.objectCache.size()) > this.maximumObjectCount) {
                int numRemVal = cacheSize - this.maximumObjectCount;
                for (int c = 0; c < numRemVal; ++c) {
                    Object obj = this.objectCache.removeElementAt(0);
                    if (!(obj instanceof TimeObjectEntry)) continue;
                    this.totalCacheDataSize -= (long)((TimeObjectEntry)obj).getDataSize();
                }
                retFlag = true;
            }
            if (this.maximumTotalDataSize > 0L) {
                this.checkRemoveViaTotalDataSize();
            } else if (this.objectCache.size() <= 0) {
                this.totalCacheDataSize = 0L;
            }
        }
        return retFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOldObjects() {
        FifoHashtable fifoHashtable = this.objectCache;
        synchronized (fifoHashtable) {
            return this.removeOldObjects(this.defaultRemoveAge);
        }
    }

    protected void checkRemoveViaTotalDataSize() {
        int cacheSize = this.objectCache.size();
        while (--cacheSize > 0 && this.totalCacheDataSize > this.maximumTotalDataSize) {
            Object obj = this.objectCache.removeElementAt(0);
            if (!(obj instanceof TimeObjectEntry)) continue;
            this.totalCacheDataSize -= (long)((TimeObjectEntry)obj).getDataSize();
        }
        if (cacheSize <= 0) {
            this.totalCacheDataSize = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        FifoHashtable fifoHashtable = this.objectCache;
        synchronized (fifoHashtable) {
            this.objectCache.clear();
            this.totalCacheDataSize = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultRemoveAge(long ageVal) {
        FifoHashtable fifoHashtable = this.objectCache;
        synchronized (fifoHashtable) {
            this.defaultRemoveAge = ageVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumObjectCount(int val) {
        FifoHashtable fifoHashtable = this.objectCache;
        synchronized (fifoHashtable) {
            this.maximumObjectCount = val;
        }
    }

    public int getMaximumObjectCount() {
        return this.maximumObjectCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumTotalDataSize(long val) {
        FifoHashtable fifoHashtable = this.objectCache;
        synchronized (fifoHashtable) {
            this.maximumTotalDataSize = val;
        }
    }

    public long getMaximumTotalDataSize() {
        return this.maximumTotalDataSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalCacheDataSize() {
        FifoHashtable fifoHashtable = this.objectCache;
        synchronized (fifoHashtable) {
            return this.totalCacheDataSize;
        }
    }

    public int getMessageCount() {
        return this.objectCache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheInformation getCacheInformation() {
        FifoHashtable fifoHashtable = this.objectCache;
        synchronized (fifoHashtable) {
            return new CacheInformation(this.getFirstObject(), this.getLastObject(), this.objectCache.size(), this.totalCacheDataSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TimeObjectEntry entryObj) {
        FifoHashtable fifoHashtable = this.objectCache;
        synchronized (fifoHashtable) {
            Object obj;
            if (this.maximumObjectCount > 0 && this.objectCache.size() >= this.maximumObjectCount && (obj = this.objectCache.removeElementAt(0)) instanceof TimeObjectEntry) {
                this.totalCacheDataSize -= (long)((TimeObjectEntry)obj).getDataSize();
            }
            this.objectCache.put(this.useLookupKeyFlag ? entryObj.getKeyStr() : new Object(), entryObj);
            this.totalCacheDataSize += (long)entryObj.getDataSize();
            if (this.maximumTotalDataSize > 0L) {
                this.checkRemoveViaTotalDataSize();
            }
            if (this.logObj != null) {
                long timeVal = entryObj.getTimeGenerated();
                if (timeVal < this.lastMsgTimeTracker) {
                    this.logObj.debug2(this.getLogPrefixString() + ":  Time value of added item (" + timeVal + ") is less than time value of previous item (" + this.lastMsgTimeTracker + ")");
                }
                this.lastMsgTimeTracker = timeVal;
            }
        }
    }

    public boolean containsKey(Object keyObj) {
        return this.objectCache.containsKey(keyObj);
    }

    public boolean containsObjectKey(TimeObjectEntry entryObj) {
        return this.objectCache.containsKey(entryObj.getKeyStr());
    }

    public boolean containsEntry(TimeObjectEntry entryObj) {
        return this.objectCache.containsValue(entryObj);
    }

    public int size() {
        return this.objectCache.size();
    }

    public boolean isEmpty() {
        return this.objectCache.isEmpty();
    }

    protected String getLogPrefixString() {
        return "IstiTimeObjectCache";
    }

    protected TimeObjectEntry getObject(int index) {
        return (TimeObjectEntry)this.objectCache.elementAt(index);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected VectorWithCount subListVector(long beginTime, long endTime, int maxCount) {
        try {
            int lastIndex;
            int firstIndex;
            block23: {
                int i;
                block25: {
                    int cacheSize;
                    block22: {
                        block17: {
                            block24: {
                                long cacheTotalTime;
                                long cacheEndTime;
                                long cacheBeginTime;
                                block20: {
                                    int i2;
                                    block21: {
                                        block18: {
                                            block16: {
                                                block19: {
                                                    cacheSize = this.objectCache.size();
                                                    if (cacheSize <= 0) return new VectorWithCount();
                                                    cacheBeginTime = this.getObject(0).getTimeGenerated();
                                                    cacheEndTime = this.getObject(cacheSize - 1).getTimeGenerated();
                                                    cacheTotalTime = cacheEndTime - cacheBeginTime;
                                                    firstIndex = -1;
                                                    if (beginTime <= cacheBeginTime) break block18;
                                                    if (cacheTotalTime <= 0L) break block19;
                                                    i2 = (int)((double)cacheSize / (double)cacheTotalTime * (double)(beginTime - cacheBeginTime));
                                                    if (i2 < cacheSize) {
                                                        if (this.getObject(i2).getTimeGenerated() >= beginTime) {
                                                            while (--i2 >= 0 && this.getObject(i2).getTimeGenerated() >= beginTime) {
                                                            }
                                                            firstIndex = i2 + 1;
                                                            break block16;
                                                        } else {
                                                            ++i2;
                                                        }
                                                        break block16;
                                                    } else {
                                                        i2 = 0;
                                                    }
                                                    break block16;
                                                }
                                                i2 = 0;
                                            }
                                            if (firstIndex >= 0) break block20;
                                            break block21;
                                        }
                                        firstIndex = 0;
                                        break block20;
                                    }
                                    while (i2 < cacheSize) {
                                        if (this.getObject(i2).getTimeGenerated() >= beginTime) {
                                            firstIndex = i2;
                                            break;
                                        }
                                        ++i2;
                                    }
                                }
                                lastIndex = -1;
                                if (endTime <= 0L || endTime >= cacheEndTime) break block22;
                                if (endTime < cacheBeginTime) break block23;
                                if (cacheTotalTime <= 0L) break block24;
                                i = (int)((double)cacheSize / (double)cacheTotalTime * (double)(endTime - cacheBeginTime));
                                if (i < cacheSize) {
                                    if (this.getObject(i).getTimeGenerated() <= endTime) {
                                        while (++i < cacheSize && this.getObject(i).getTimeGenerated() <= endTime) {
                                        }
                                        lastIndex = i - 1;
                                        break block17;
                                    } else {
                                        --i;
                                    }
                                    break block17;
                                } else {
                                    i = cacheSize - 1;
                                }
                                break block17;
                            }
                            i = cacheSize - 1;
                        }
                        if (lastIndex >= 0) break block23;
                        break block25;
                    }
                    lastIndex = cacheSize - 1;
                    break block23;
                }
                while (i >= 0) {
                    if (this.getObject(i).getTimeGenerated() <= endTime) {
                        lastIndex = i;
                        break;
                    }
                    --i;
                }
            }
            if (firstIndex < 0) return new VectorWithCount();
            if (lastIndex < firstIndex) return new VectorWithCount();
            int reqCount = lastIndex - firstIndex + 1;
            if (maxCount <= 0) return new VectorWithCount(this.objectCache.getValuesVector(firstIndex, lastIndex + 1), reqCount);
            if (reqCount <= maxCount) return new VectorWithCount(this.objectCache.getValuesVector(firstIndex, lastIndex + 1), reqCount);
            lastIndex = firstIndex + maxCount - 1;
            return new VectorWithCount(this.objectCache.getValuesVector(firstIndex, lastIndex + 1), reqCount);
        }
        catch (Exception ex) {
            if (this.logObj == null) return new VectorWithCount();
            this.logObj.warning(this.getLogPrefixString() + " error accessing cache:  " + ex);
        }
        return new VectorWithCount();
    }

    public void close() {
        this.objectCache.clear();
    }

    public static class CacheInformation {
        public final TimeObjectEntry firstMsgObj;
        public final TimeObjectEntry lastMsgObj;
        public final int messageCount;
        public final long totalDataSize;

        public CacheInformation(TimeObjectEntry firstMsgObj, TimeObjectEntry lastMsgObj, int messageCount, long totalDataSize) {
            this.firstMsgObj = firstMsgObj;
            this.lastMsgObj = lastMsgObj;
            this.messageCount = messageCount;
            this.totalDataSize = totalDataSize;
        }
    }

    public static class VectorWithCount
    extends Vector {
        protected int count = 0;

        public VectorWithCount() {
        }

        public VectorWithCount(Collection cObj) {
            super(cObj);
        }

        public VectorWithCount(Collection cObj, int count) {
            super(cObj);
            this.count = count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public void addToCount(int val) {
            this.count += val;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static class BasicTimeObjectEntry
    implements TimeObjectEntry {
        protected long timeGenerated;
        protected Object dataObj;
        protected String keyStr;
        protected int dataSize;

        public BasicTimeObjectEntry(long timeGenerated, Object dataObj, String keyStr) {
            this.timeGenerated = timeGenerated;
            this.dataObj = dataObj;
            this.keyStr = keyStr;
        }

        protected BasicTimeObjectEntry() {
        }

        public long getTimeGenerated() {
            return this.timeGenerated;
        }

        public Object getDataObj() {
            return this.dataObj;
        }

        public String getKeyStr() {
            return this.keyStr;
        }

        public void setDataSize(int val) {
            this.dataSize = val;
        }

        public int getDataSize() {
            return this.dataSize;
        }
    }

    public static interface TimeObjectEntry {
        public long getTimeGenerated();

        public Object getDataObj();

        public String getKeyStr();

        public int getDataSize();
    }
}

