/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.bag.wrapper;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.iris.dmc.seedcodec.CodecException;
import edu.sc.seis.bag.wrapper.AbstractWrapper;
import edu.sc.seis.fissuresUtil.bag.Arithmatic;
import edu.sc.seis.fissuresUtil.chooser.ThreadSafeSimpleDateFormat;
import edu.sc.seis.fissuresUtil.display.UnitDisplayUtil;
import java.util.Date;
import org.python.core.Py;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyIterator;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyType;

public class SeisWrapper
extends AbstractWrapper {
    private LocalSeismogramImpl seis;
    private ThreadSafeSimpleDateFormat dateFormat = new ThreadSafeSimpleDateFormat("yyyy-mm-dd hh:MM:ss.SSS Z");

    public SeisWrapper(PyType pyType, LocalSeismogramImpl seis) {
        super(pyType, seis);
        this.seis = seis;
    }

    public PyObject __getitem__(PyObject key) {
        int i;
        try {
            i = key.asInt(0);
        }
        catch (PyObject.ConversionException e) {
            throw Py.KeyError((String)key.toString());
        }
        PyObject ret = this.__finditem__(i);
        if (ret == null) {
            throw Py.KeyError((String)key.toString());
        }
        return ret;
    }

    public PyObject __finditem__(int key) {
        if (key < 0) {
            key = this.seis.getNumPoints() + key;
        }
        if (key >= this.seis.getNumPoints() || key < 0) {
            return null;
        }
        try {
            return Py.java2py((Object)this.seis.getValueAt(key));
        }
        catch (CodecException e) {
            throw Py.JavaError((Throwable)e);
        }
    }

    public int __len__() {
        return this.seis.getNumPoints();
    }

    public PyObject __iter__() {
        return new PyIterator(){
            private int i;

            public PyObject __iternext__() {
                return SeisWrapper.this.__finditem__(this.i++);
            }
        };
    }

    private static final boolean canCoerceNumeric(PyObject other) {
        return other instanceof PyFloat || other instanceof PyInteger || other instanceof PyLong;
    }

    private static final float coerceNumeric(PyObject other) {
        if (other instanceof PyFloat) {
            return (float)((PyFloat)other).getValue();
        }
        if (other instanceof PyInteger) {
            return ((PyInteger)other).getValue();
        }
        if (other instanceof PyLong) {
            return (float)((PyLong)other).doubleValue();
        }
        throw Py.TypeError((String)"xxx");
    }

    public PyObject __add__(PyObject other) {
        if (SeisWrapper.canCoerceNumeric(other)) {
            try {
                return new SeisWrapper(this.getType(), Arithmatic.add((LocalSeismogramImpl)this.seis, (float)SeisWrapper.coerceNumeric(other)));
            }
            catch (FissuresException e) {
                return null;
            }
        }
        return null;
    }

    public PyObject __radd__(PyObject other) {
        return this.__add__(other);
    }

    public PyObject __sub__(PyObject other) {
        if (SeisWrapper.canCoerceNumeric(other)) {
            try {
                return new SeisWrapper(this.getType(), Arithmatic.sub((LocalSeismogramImpl)this.seis, (float)SeisWrapper.coerceNumeric(other)));
            }
            catch (FissuresException e) {
                return null;
            }
        }
        return null;
    }

    public PyObject __rsub__(PyObject other) {
        return this.__sub__(other).__mul__((PyObject)new PyFloat(-1.0f));
    }

    public PyObject __mul__(PyObject other) {
        if (SeisWrapper.canCoerceNumeric(other)) {
            try {
                return new SeisWrapper(this.getType(), Arithmatic.mul((LocalSeismogramImpl)this.seis, (float)SeisWrapper.coerceNumeric(other)));
            }
            catch (FissuresException e) {
                return null;
            }
        }
        return null;
    }

    public PyObject __rmul__(PyObject other) {
        return this.__mul__(other);
    }

    public PyObject __div__(PyObject other) {
        if (SeisWrapper.canCoerceNumeric(other)) {
            try {
                return new SeisWrapper(this.getType(), Arithmatic.div((LocalSeismogramImpl)this.seis, (float)SeisWrapper.coerceNumeric(other)));
            }
            catch (FissuresException e) {
                return null;
            }
        }
        return null;
    }

    public PyObject __rdiv__(PyObject other) {
        return this.__div__(other).__invert__();
    }

    public PyObject __invert__() {
        try {
            return new SeisWrapper(this.getType(), Arithmatic.invert((LocalSeismogramImpl)this.seis));
        }
        catch (FissuresException e) {
            return null;
        }
    }

    public String toString() {
        String out = SeisWrapper.nameValue("Channel", ChannelIdUtil.toStringNoDates((ChannelId)this.seis.channel_id)) + "\n";
        out = out + SeisWrapper.nameValue("Num Points", this.seis.num_points) + "\n";
        out = out + SeisWrapper.nameValue("Name", this.seis.getName()) + "\n";
        out = out + SeisWrapper.nameValue("Begin", this.dateFormat.format((Date)this.seis.getBeginTime())) + "\n";
        out = out + SeisWrapper.nameValue("Sampling", this.seis.getSampling().toString()) + "\n";
        out = out + SeisWrapper.nameValue("Unit", UnitDisplayUtil.getNameForUnit((UnitImpl)((UnitImpl)this.seis.y_unit)));
        return out;
    }
}

