/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.bag;

import edu.sc.seis.bag.BagUtil;
import edu.sc.seis.fissuresUtil.simple.Initializer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.Completor;
import jline.ConsoleReader;
import jline.Terminal;
import org.apache.log4j.BasicConfigurator;
import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyException;
import org.python.core.PyJavaType;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.util.InteractiveConsole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bag
extends InteractiveConsole {
    protected String prompt = "Bag 0.1";
    protected String historyFilename = ".jline-bag.history";
    private static Properties props = System.getProperties();
    public static final String DEFAULT_PROPS = "edu/sc/seis/bag/bag.props";
    private ConsoleReader reader;
    private static final Logger logger = LoggerFactory.getLogger(Bag.class);
    public static final String VERSION = "0.1";

    public Bag() throws IOException {
        Initializer.loadProps((InputStream)Bag.class.getClassLoader().getResourceAsStream(DEFAULT_PROPS), (Properties)props);
        Terminal.setupTerminal();
        this.reader = new ConsoleReader();
        this.reader.getHistory().setHistoryFile(new File(System.getProperty("user.home"), this.historyFilename));
        this.reader.addCompletor((Completor)new DirCompleter());
        BagUtil.addClassAdapters();
        this.systemState.ps1 = new PyString("bag> ");
        this.exec("import sys");
        this.exec("sys.path.append('" + Bag.formatForJythonSysPath(Bag.class, "edu/sc/seis/bag/jython") + "')");
        this.exec("print sys.path");
        this.exec("from bag import *");
        this.set("history", PyJavaType.wrapJavaObject((Object)this.reader.getHistory()));
        this.exec("def h(num):\n    his = history.getHistoryList().toArray()[-num:]\n    for line in his:\n        print line");
    }

    public void interact() {
        this.interact(this.prompt, null);
    }

    public String raw_input(PyObject prompt) {
        String line = null;
        try {
            line = this.reader.readLine(prompt.toString());
        }
        catch (IOException io) {
            throw new PyException(Py.IOError);
        }
        if (line == null) {
            throw new PyException(Py.EOFError);
        }
        return line.endsWith("\n") ? line.substring(0, line.length() - 1) : line;
    }

    public static String formatForJythonSysPath(Class c, String jarDir) {
        String out = c.getClassLoader().getResource(jarDir).toString().substring("jar:file:".length()).replaceAll("\\!", "");
        return out;
    }

    public static void main(String[] args) throws IOException {
        BasicConfigurator.configure();
        Bag ic = new Bag();
        if (args.length > 0) {
            ic.execfile(args[0]);
        } else {
            ic.interact();
        }
    }

    public class DirCompleter
    implements Completor {
        Pattern rightmostPeriod = Pattern.compile(".*(\\.)[^.]*");

        public int complete(String buffer, int cursor, List candidates) {
            try {
                PyArray res;
                Matcher m = this.rightmostPeriod.matcher(buffer);
                int knownEnd = 0;
                String partial = buffer;
                if (m.matches()) {
                    knownEnd = m.start(1);
                    partial = buffer.substring(knownEnd + 1);
                }
                if (buffer.trim().length() != 0) {
                    res = Bag.this.eval("dir(" + buffer.substring(0, knownEnd) + ")");
                } else {
                    res = new PyArray(String.class, 1);
                    res.__setitem__(0, (PyObject)new PyString("  "));
                }
                for (int i = 0; i < res.__len__(); ++i) {
                    String possible = res.__getitem__(i).toString();
                    if (!possible.startsWith(partial)) continue;
                    candidates.add(possible);
                }
                return m.matches() ? knownEnd + 1 : 0;
            }
            catch (Throwable e) {
                return 0;
            }
        }
    }
}

