/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.areas;

import de.erichseifert.gral.graphics.AbstractDrawable;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.plots.DataPoint;
import de.erichseifert.gral.plots.areas.AbstractAreaRenderer;
import de.erichseifert.gral.plots.areas.AreaRenderer;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.settings.Key;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.MathUtils;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineAreaRenderer2D
extends AbstractAreaRenderer {
    private static final long serialVersionUID = -8396097579938931392L;
    public static final Key STROKE = new Key("linearea.stroke");

    public LineAreaRenderer2D() {
        this.setSettingDefault(STROKE, new BasicStroke(1.0f));
    }

    @Override
    public Drawable getArea(List<DataPoint> list, Shape shape) {
        return new AbstractDrawable(this, shape){
            private static final long serialVersionUID = 5492321759151727458L;
            private /* synthetic */ Shape a;
            private /* synthetic */ LineAreaRenderer2D b;
            {
                this.b = lineAreaRenderer2D;
                this.a = shape;
            }

            public final void draw(DrawingContext drawingContext) {
                Paint paint = (Paint)this.b.getSetting(AreaRenderer.COLOR);
                GraphicsUtils.fillPaintedShape(drawingContext.getGraphics(), this.a, paint, null);
            }
        };
    }

    @Override
    public Shape getAreaShape(List<DataPoint> list) {
        if (list.isEmpty() || list.get(0) == null) {
            return null;
        }
        Serializable serializable = list.get((int)0).data.axes.get(1);
        Object object = list.get((int)0).data.axisRenderers.get(1);
        double d = ((Axis)serializable).getMin().doubleValue();
        double d2 = ((Axis)serializable).getMax().doubleValue();
        double d3 = MathUtils.limit(0.0, d, d2);
        double d4 = 0.0;
        if (object != null) {
            d4 = object.getPosition((Axis)serializable, d3, true, false).get(1);
        }
        serializable = new Path2D.Double();
        object = list.iterator();
        while (object.hasNext()) {
            Point2D point2D = ((DataPoint)object.next()).position.getPoint2D();
            double d5 = point2D.getX();
            double d6 = point2D.getY();
            ((Path2D)((Object)serializable)).moveTo(d5, d6);
            ((Path2D)((Object)serializable)).lineTo(d5, d4);
        }
        object = (Stroke)this.getSetting(STROKE);
        return this.punch(object.createStrokedShape((Shape)((Object)serializable)), list);
    }
}

