/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.areas;

import de.erichseifert.gral.plots.DataPoint;
import de.erichseifert.gral.plots.areas.AreaRenderer;
import de.erichseifert.gral.plots.settings.BasicSettingsStorage;
import de.erichseifert.gral.plots.settings.SettingChangeEvent;
import de.erichseifert.gral.plots.settings.SettingsListener;
import de.erichseifert.gral.util.DataUtils;
import de.erichseifert.gral.util.GeometryUtils;
import de.erichseifert.gral.util.MathUtils;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Area;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAreaRenderer
extends BasicSettingsStorage
implements AreaRenderer,
SettingsListener {
    private static final long serialVersionUID = -9064749128190128428L;

    public AbstractAreaRenderer() {
        this.addSettingsListener(this);
        this.setSettingDefault(GAP, 0.0);
        this.setSettingDefault(GAP_ROUNDED, false);
        this.setSettingDefault(COLOR, Color.GRAY);
    }

    protected Shape punch(Shape shape, List<DataPoint> object) {
        double d = DataUtils.getValueOrDefault((Number)this.getSetting(GAP), 0.0);
        if (!MathUtils.isCalculatable(d) || d == 0.0) {
            return shape;
        }
        boolean bl = (Boolean)this.getSetting(GAP_ROUNDED);
        shape = new Area(shape);
        object = object.iterator();
        while (object.hasNext()) {
            DataPoint dataPoint = (DataPoint)object.next();
            shape = GeometryUtils.punch((Area)shape, d, bl, dataPoint.position.getPoint2D(), dataPoint.shape);
        }
        return shape;
    }

    @Override
    public void settingChanged(SettingChangeEvent settingChangeEvent) {
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.addSettingsListener(this);
    }
}

