/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.io.data;

import de.erichseifert.gral.io.AbstractIOFactory;
import de.erichseifert.gral.io.data.DataWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataWriterFactory
extends AbstractIOFactory<DataWriter> {
    private static DataWriterFactory a;

    private DataWriterFactory() throws IOException {
        super("datawriters.properties");
    }

    public static DataWriterFactory getInstance() {
        if (a == null) {
            try {
                a = new DataWriterFactory();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return a;
    }

    @Override
    public final DataWriter get(String string) {
        DataWriter dataWriter = null;
        Class clazz = this.getTypeClass(string);
        try {
            if (clazz != null) {
                dataWriter = (DataWriter)clazz.getDeclaredConstructor(String.class).newInstance(string);
            }
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        if (dataWriter == null) {
            throw new IllegalArgumentException(MessageFormat.format("Unsupported MIME type: {0}", string));
        }
        return dataWriter;
    }
}

