/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.graphics;

import de.erichseifert.gral.graphics.Container;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.Layout;
import de.erichseifert.gral.util.Dimension2D;
import de.erichseifert.gral.util.Insets2D;
import de.erichseifert.gral.util.Orientation;
import java.awt.geom.Dimension2D;
import java.awt.geom.RectangularShape;

public class StackedLayout
implements Layout {
    private static final long serialVersionUID = -3183337606556363756L;
    private final Orientation a;
    private final Dimension2D b;

    public StackedLayout(Orientation orientation) {
        this(orientation, null);
    }

    public StackedLayout(Orientation orientation, Dimension2D dimension2D) {
        this.a = orientation;
        this.b = new Dimension2D.Double();
        if (dimension2D != null) {
            this.b.setSize(dimension2D);
        }
    }

    public void layout(Container iterator) {
        Object object = this.getPreferredSize((Container)((Object)iterator));
        Cloneable cloneable = iterator.getBounds();
        Insets2D insets2D = iterator.getInsets();
        Dimension2D dimension2D = this.getGap();
        double d = ((RectangularShape)cloneable).getMinX() + insets2D.getLeft();
        double d2 = ((RectangularShape)cloneable).getMinY() + insets2D.getTop();
        double d3 = ((RectangularShape)cloneable).getWidth() - insets2D.getLeft() - insets2D.getRight();
        double d4 = ((RectangularShape)cloneable).getHeight() - insets2D.getTop() - insets2D.getBottom();
        int n = 0;
        if (this.getOrientation() == Orientation.HORIZONTAL) {
            d += Math.max(((RectangularShape)cloneable).getWidth() - ((Dimension2D)object).getWidth(), 0.0) * 0.5;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                object = (Drawable)iterator.next();
                if (n++ > 0) {
                    d += dimension2D.getWidth();
                }
                cloneable = object.getPreferredSize();
                object.setBounds(d, d2, ((Dimension2D)cloneable).getWidth(), d4);
                d += ((Dimension2D)cloneable).getWidth();
            }
            return;
        }
        if (this.getOrientation() == Orientation.VERTICAL) {
            d2 += Math.max(((RectangularShape)cloneable).getHeight() - ((Dimension2D)object).getHeight(), 0.0) * 0.5;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                object = (Drawable)iterator.next();
                if (n++ > 0) {
                    d2 += dimension2D.getHeight();
                }
                cloneable = object.getPreferredSize();
                object.setBounds(d, d2, d3, ((Dimension2D)cloneable).getHeight());
                d2 += ((Dimension2D)cloneable).getHeight();
            }
        }
    }

    public Dimension2D getPreferredSize(Container iterator) {
        Insets2D insets2D = iterator.getInsets();
        Dimension2D dimension2D = this.getGap();
        double d = insets2D.getLeft();
        double d2 = insets2D.getTop();
        int n = 0;
        if (this.getOrientation() == Orientation.HORIZONTAL) {
            double d3 = 0.0;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object object = (Drawable)iterator.next();
                if (n++ > 0) {
                    d += dimension2D.getWidth();
                }
                object = object.getPreferredSize();
                d += ((Dimension2D)object).getWidth();
                d3 = Math.max(d2, ((Dimension2D)object).getHeight());
            }
            d2 += d3;
        } else if (this.getOrientation() == Orientation.VERTICAL) {
            double d4 = 0.0;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object object = (Drawable)iterator.next();
                if (n++ > 0) {
                    d2 += dimension2D.getHeight();
                }
                object = object.getPreferredSize();
                d4 = Math.max(d4, ((Dimension2D)object).getWidth());
                d2 += ((Dimension2D)object).getHeight();
            }
            d += d4;
        }
        return new Dimension2D.Double(d += insets2D.getRight(), d2 += insets2D.getBottom());
    }

    public Orientation getOrientation() {
        return this.a;
    }

    public Dimension2D getGap() {
        Dimension2D.Double double_ = new Dimension2D.Double();
        double_.setSize(this.b);
        return double_;
    }
}

