/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data;

import de.erichseifert.gral.data.Column;
import de.erichseifert.gral.data.DataChangeEvent;
import de.erichseifert.gral.data.DataListener;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.data.statistics.Statistics;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataSource
implements DataSource,
Serializable {
    private static final long serialVersionUID = 9139975565475816812L;
    private int a;
    private Class<? extends Comparable<?>>[] b;
    private transient Set<DataListener> c;
    private transient Statistics d;

    public AbstractDataSource(Class<? extends Comparable<?>> ... classArray) {
        this.setColumnTypes(classArray);
        this.c = new LinkedHashSet<DataListener>();
    }

    @Override
    public Statistics getStatistics() {
        if (this.d == null) {
            this.d = new Statistics(this);
        }
        return this.d;
    }

    @Override
    public void addDataListener(DataListener dataListener) {
        this.c.add(dataListener);
    }

    @Override
    public void removeDataListener(DataListener dataListener) {
        this.c.remove(dataListener);
    }

    @Override
    public Iterator<Comparable<?>> iterator() {
        return new a(this);
    }

    protected void notifyDataAdded(DataChangeEvent ... dataChangeEventArray) {
        Iterator iterator = new LinkedList<DataListener>(this.c).iterator();
        while (iterator.hasNext()) {
            ((DataListener)iterator.next()).dataAdded(this, dataChangeEventArray);
        }
    }

    protected void notifyDataRemoved(DataChangeEvent ... dataChangeEventArray) {
        Iterator iterator = new LinkedList<DataListener>(this.c).iterator();
        while (iterator.hasNext()) {
            ((DataListener)iterator.next()).dataRemoved(this, dataChangeEventArray);
        }
    }

    protected void notifyDataUpdated(DataChangeEvent ... dataChangeEventArray) {
        Iterator iterator = new LinkedList<DataListener>(this.c).iterator();
        while (iterator.hasNext()) {
            ((DataListener)iterator.next()).dataUpdated(this, dataChangeEventArray);
        }
    }

    @Override
    public Column getColumn(int n) {
        return new Column(this, n);
    }

    @Override
    public int getColumnCount() {
        return this.a;
    }

    @Override
    public Class<? extends Comparable<?>>[] getColumnTypes() {
        return Arrays.copyOf(this.b, this.b.length);
    }

    @Override
    public boolean isColumnNumeric(int n) {
        if (n < 0 || n >= this.b.length) {
            return false;
        }
        Class<? extends Comparable<?>> clazz = this.b[n];
        return Number.class.isAssignableFrom(clazz);
    }

    protected void setColumnTypes(Class<? extends Comparable<?>> ... classArray) {
        this.b = Arrays.copyOf(classArray, classArray.length);
        this.a = classArray.length;
    }

    @Override
    public Row getRow(int n) {
        return new Row(this, n);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.c = new HashSet<DataListener>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class a
    implements Iterator<Comparable<?>> {
        private int a = 0;
        private int b = 0;
        private /* synthetic */ AbstractDataSource c;

        public a(AbstractDataSource abstractDataSource) {
            this.c = abstractDataSource;
        }

        @Override
        public final boolean hasNext() {
            return this.a < this.c.getColumnCount() && this.b < this.c.getRowCount();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object next() {
            a a2 = this;
            if (!a2.hasNext()) {
                throw new NoSuchElementException();
            }
            Comparable<?> comparable = a2.c.get(a2.a, a2.b);
            if (++a2.a >= a2.c.getColumnCount()) {
                a2.a = 0;
                ++a2.b;
            }
            return comparable;
        }
    }
}

