/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.NoSuchMatPropException;
import edu.sc.seis.TauP.VelocityLayer;
import edu.sc.seis.TauP.VelocityModelException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;

public class VelocityModel
implements Cloneable,
Serializable {
    protected String modelName = "unknown";
    protected double radiusOfEarth = 6371.0;
    public static final double DEFAULT_MOHO = 35.0;
    public static final double DEFAULT_CMB = 2889.0;
    public static final double DEFAULT_IOCB = 5153.9;
    protected double mohoDepth = 35.0;
    protected double cmbDepth = 2889.0;
    protected double iocbDepth = 5153.9;
    protected double minRadius = 0.0;
    protected double maxRadius = 6371.0;
    protected boolean spherical = true;
    protected static int vectorLength = 16;
    protected List<VelocityLayer> layer;

    public VelocityModel(String modelName, double radiusOfEarth, double mohoDepth, double cmbDepth, double iocbDepth, double minRadius, double maxRadius, boolean spherical, List<VelocityLayer> layer) {
        this.modelName = modelName;
        this.radiusOfEarth = radiusOfEarth;
        this.mohoDepth = mohoDepth;
        this.cmbDepth = cmbDepth;
        this.iocbDepth = iocbDepth;
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
        this.spherical = spherical;
        this.layer = layer;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName.length() > 0 ? modelName : "unknown";
    }

    public void setRadiusOfEarth(double radiusOfEarth) {
        this.radiusOfEarth = radiusOfEarth;
    }

    public double getRadiusOfEarth() {
        return this.radiusOfEarth;
    }

    public boolean isDisconDepth(double depth) {
        double[] discons = this.getDisconDepths();
        for (int i = 0; i < discons.length; ++i) {
            if (depth != discons[i]) continue;
            return true;
        }
        return false;
    }

    public double[] getDisconDepths() {
        double[] disconDepths = new double[this.getNumLayers() + 2];
        int numFound = 0;
        disconDepths[numFound++] = this.getVelocityLayer(0).getTopDepth();
        for (int layerNum = 0; layerNum < this.getNumLayers() - 1; ++layerNum) {
            VelocityLayer aboveLayer = this.getVelocityLayer(layerNum);
            VelocityLayer belowLayer = this.getVelocityLayer(layerNum + 1);
            if (aboveLayer.getBotPVelocity() == belowLayer.getTopPVelocity() && aboveLayer.getBotSVelocity() == belowLayer.getTopSVelocity()) continue;
            disconDepths[numFound++] = aboveLayer.getBotDepth();
        }
        disconDepths[numFound++] = this.getVelocityLayer(this.getNumLayers() - 1).getBotDepth();
        double[] temp = new double[numFound];
        System.arraycopy(disconDepths, 0, temp, 0, numFound);
        return temp;
    }

    public double getMohoDepth() {
        return this.mohoDepth;
    }

    public void setMohoDepth(double mohoDepth) {
        this.mohoDepth = mohoDepth;
    }

    public double getCmbDepth() {
        return this.cmbDepth;
    }

    public void setCmbDepth(double cmbDepth) {
        this.cmbDepth = cmbDepth;
    }

    public double getIocbDepth() {
        return this.iocbDepth;
    }

    public void setIocbDepth(double iocbDepth) {
        this.iocbDepth = iocbDepth;
    }

    public double getMinRadius() {
        return this.minRadius;
    }

    public void setMinRadius(double minRadius) {
        this.minRadius = minRadius;
    }

    public double getMaxRadius() {
        return this.maxRadius;
    }

    public void setMaxRadius(double maxRadius) {
        this.maxRadius = maxRadius;
    }

    public boolean getSpherical() {
        return this.spherical;
    }

    public void setSpherical(boolean spherical) {
        this.spherical = spherical;
    }

    public VelocityLayer getVelocityLayerClone(int layerNum) {
        return (VelocityLayer)this.layer.get(layerNum).clone();
    }

    public VelocityLayer getVelocityLayer(int layerNum) {
        return this.layer.get(layerNum);
    }

    public int getNumLayers() {
        return this.layer.size();
    }

    public VelocityLayer[] getLayers() {
        return this.layer.toArray(new VelocityLayer[0]);
    }

    public int layerNumberAbove(double depth) throws NoSuchLayerException {
        VelocityLayer tempLayer = this.getVelocityLayer(0);
        if (depth == tempLayer.getTopDepth()) {
            return 0;
        }
        int tooSmallNum = 0;
        int tooLargeNum = this.getNumLayers() - 1;
        int currentNum = 0;
        boolean found = false;
        if (depth < tempLayer.getTopDepth() || this.getVelocityLayer(tooLargeNum).getBotDepth() < depth) {
            throw new NoSuchLayerException(depth);
        }
        while (!found) {
            currentNum = Math.round((float)(tooSmallNum + tooLargeNum) / 2.0f);
            tempLayer = this.getVelocityLayer(currentNum);
            if (tempLayer.getTopDepth() >= depth) {
                tooLargeNum = currentNum - 1;
                continue;
            }
            if (tempLayer.getBotDepth() < depth) {
                tooSmallNum = currentNum + 1;
                continue;
            }
            found = true;
        }
        return currentNum;
    }

    public int layerNumberBelow(double depth) throws NoSuchLayerException {
        VelocityLayer tempLayer = this.getVelocityLayer(0);
        int tooSmallNum = 0;
        int tooLargeNum = this.getNumLayers() - 1;
        int currentNum = 0;
        boolean found = false;
        if (depth == tempLayer.getTopDepth()) {
            return 0;
        }
        if (this.getVelocityLayer(tooLargeNum).getBotDepth() == depth) {
            return tooLargeNum;
        }
        if (depth < tempLayer.getTopDepth() || this.getVelocityLayer(tooLargeNum).getBotDepth() < depth) {
            throw new NoSuchLayerException(depth);
        }
        while (!found) {
            currentNum = Math.round((float)(tooSmallNum + tooLargeNum) / 2.0f);
            tempLayer = this.getVelocityLayer(currentNum);
            if (tempLayer.getTopDepth() > depth) {
                tooLargeNum = currentNum - 1;
                continue;
            }
            if (tempLayer.getBotDepth() <= depth) {
                tooSmallNum = currentNum + 1;
                continue;
            }
            found = true;
        }
        return currentNum;
    }

    public double evaluateAbove(double depth, char materialProperty) throws NoSuchLayerException, NoSuchMatPropException {
        VelocityLayer tempLayer = this.getVelocityLayer(this.layerNumberAbove(depth));
        return tempLayer.evaluateAt(depth, materialProperty);
    }

    public double evaluateBelow(double depth, char materialProperty) throws NoSuchLayerException, NoSuchMatPropException {
        VelocityLayer tempLayer = this.getVelocityLayer(this.layerNumberBelow(depth));
        return tempLayer.evaluateAt(depth, materialProperty);
    }

    public double evaluateAtTop(int layerNumber, char materialProperty) throws NoSuchMatPropException {
        VelocityLayer tempLayer = this.getVelocityLayer(layerNumber);
        return tempLayer.evaluateAtTop(materialProperty);
    }

    public double evaluateAtBottom(int layerNumber, char materialProperty) throws NoSuchMatPropException {
        VelocityLayer tempLayer = this.getVelocityLayer(layerNumber);
        return tempLayer.evaluateAtBottom(materialProperty);
    }

    public double depthAtTop(int layerNumber) {
        VelocityLayer tempLayer = this.getVelocityLayer(layerNumber);
        return tempLayer.getTopDepth();
    }

    public double depthAtBottom(int layerNumber) throws NoSuchMatPropException {
        VelocityLayer tempLayer = this.getVelocityLayer(layerNumber);
        return tempLayer.getBotDepth();
    }

    public VelocityModel replaceLayers(VelocityLayer[] newLayers, String name, boolean matchTop, boolean matchBot) throws NoSuchLayerException {
        int i;
        VelocityLayer newVLayer;
        int topLayerNum = this.layerNumberBelow(newLayers[0].getTopDepth());
        VelocityLayer topLayer = this.getVelocityLayer(topLayerNum);
        int botLayerNum = this.layerNumberAbove(newLayers[newLayers.length - 1].getBotDepth());
        VelocityLayer botLayer = this.getVelocityLayer(botLayerNum);
        ArrayList<VelocityLayer> outLayers = new ArrayList<VelocityLayer>();
        outLayers.addAll(this.layer);
        try {
            if (matchTop) {
                newLayers[0] = new VelocityLayer(newLayers[0].getLayerNum(), newLayers[0].getTopDepth(), newLayers[0].getBotDepth(), topLayer.evaluateAt(newLayers[0].getTopDepth(), 'P'), newLayers[0].getBotPVelocity(), topLayer.evaluateAt(newLayers[0].getTopDepth(), 'S'), newLayers[0].getBotSVelocity(), newLayers[0].getTopDensity(), newLayers[0].getBotDensity(), newLayers[0].getTopQp(), newLayers[0].getBotQp(), newLayers[0].getTopQs(), newLayers[0].getBotQs());
            }
            if (matchBot) {
                VelocityLayer end = newLayers[newLayers.length - 1];
                newLayers[newLayers.length - 1] = new VelocityLayer(end.getLayerNum(), end.getTopDepth(), end.getBotDepth(), end.getTopPVelocity(), botLayer.evaluateAt(newLayers[newLayers.length - 1].getBotDepth(), 'P'), end.getTopSVelocity(), botLayer.evaluateAt(newLayers[newLayers.length - 1].getBotDepth(), 'S'), end.getTopDensity(), end.getBotDensity(), end.getTopQp(), end.getBotQp(), end.getTopQs(), end.getBotQs());
            }
        }
        catch (NoSuchMatPropException e) {
            throw new RuntimeException(e);
        }
        if (topLayer.getBotDepth() > newLayers[0].getTopDepth()) {
            newVLayer = (VelocityLayer)topLayer.clone();
            try {
                int topIndex = outLayers.indexOf(topLayer);
                topLayer = new VelocityLayer(topLayer.getLayerNum(), topLayer.getTopDepth(), newLayers[0].getTopDepth(), topLayer.getTopPVelocity(), topLayer.evaluateAt(newLayers[0].getTopDepth(), 'P'), topLayer.getTopSVelocity(), topLayer.evaluateAt(newLayers[0].getTopDepth(), 'S'), topLayer.getTopDensity(), topLayer.getBotDensity());
                outLayers.set(topIndex, topLayer);
            }
            catch (NoSuchMatPropException e) {
                throw new RuntimeException(e);
            }
            newVLayer.setTopPVelocity(topLayer.getBotPVelocity());
            newVLayer.setTopSVelocity(topLayer.getBotSVelocity());
            newVLayer.setTopDepth(topLayer.getBotDepth());
            outLayers.add(topLayerNum + 1, newVLayer);
            ++botLayerNum;
            ++topLayerNum;
        }
        if (botLayer.getBotDepth() > newLayers[newLayers.length - 1].getBotDepth()) {
            newVLayer = (VelocityLayer)botLayer.clone();
            try {
                botLayer.setBotPVelocity(botLayer.evaluateAt(newLayers[newLayers.length - 1].getBotDepth(), 'P'));
                botLayer.setBotSVelocity(botLayer.evaluateAt(newLayers[newLayers.length - 1].getBotDepth(), 'S'));
                botLayer.setBotDepth(newLayers[newLayers.length - 1].getBotDepth());
            }
            catch (NoSuchMatPropException e) {
                System.err.println("Caught NoSuchMatPropException: " + e.getMessage());
                e.printStackTrace();
            }
            newVLayer.setTopPVelocity(botLayer.getBotPVelocity());
            newVLayer.setTopSVelocity(botLayer.getBotSVelocity());
            newVLayer.setTopDepth(botLayer.getBotDepth());
            outLayers.add(botLayerNum + 1, newVLayer);
            ++botLayerNum;
        }
        for (i = topLayerNum; i <= botLayerNum; ++i) {
            outLayers.remove(topLayerNum);
        }
        for (i = 0; i < newLayers.length; ++i) {
            outLayers.add(topLayerNum + i, newLayers[i]);
        }
        VelocityModel outVMod = new VelocityModel(name, this.getRadiusOfEarth(), this.getMohoDepth(), this.getCmbDepth(), this.getIocbDepth(), this.getMinRadius(), this.getMaxRadius(), this.getSpherical(), outLayers);
        outVMod.fixDisconDepths();
        outVMod.validate();
        return outVMod;
    }

    public void printGMT(String filename) throws IOException {
        String psFile = filename.endsWith(".gmt") ? filename.substring(0, filename.length() - 4) + ".ps" : filename + ".ps";
        PrintWriter dos = new PrintWriter(new BufferedWriter(new FileWriter(filename)));
        dos.println("#!/bin/sh");
        dos.println("#\n# This script will plot the " + this.getModelName() + " velocity model using GMT. If you want to\n" + "#use this as a data file for psxy in another script, delete these" + "\n# first lines, as well as the last line.\n#");
        dos.println("/bin/rm -f " + psFile + "\n");
        double maxVel = 0.0;
        for (VelocityLayer vLayer : this.layer) {
            if (vLayer.getTopPVelocity() > maxVel) {
                maxVel = vLayer.getTopPVelocity();
            }
            if (vLayer.getBotPVelocity() > maxVel) {
                maxVel = vLayer.getBotPVelocity();
            }
            if (vLayer.getTopSVelocity() > maxVel) {
                maxVel = vLayer.getTopSVelocity();
            }
            if (!(vLayer.getBotSVelocity() > maxVel)) continue;
            maxVel = vLayer.getBotSVelocity();
        }
        dos.println("PCOLOR=0/0/255");
        dos.println("SCOLOR=255/0/0");
        dos.println();
        dos.println("psbasemap -JX6i/-9i -P -R0/" + (maxVel *= 1.05) + "/0/" + this.getMaxRadius() + " -B1a2:'Velocity (km/s)':/200a400:'Depth (km)':/:.'" + this.getModelName() + "':WSen  -K > " + psFile);
        dos.println();
        dos.println("psxy -JX -P -R -W2p,${PCOLOR} -: -m -O -K >> " + psFile + " <<END");
        this.printGMTforP(dos);
        dos.println("END\n");
        dos.println("psxy -JX -P -R -W2p,${SCOLOR} -: -m -O >> " + psFile + " <<END");
        this.printGMTforS(dos);
        dos.println("END\n");
        dos.close();
    }

    public void printGMT(PrintWriter dos) throws IOException {
        dos.println("> P velocity for " + this.modelName + "  below");
        this.printGMTforP(dos);
        dos.println("> S velocity for " + this.modelName + "  below");
        this.printGMTforP(dos);
    }

    void printGMTforP(PrintWriter dos) throws IOException {
        double pVel = -1.0;
        for (int layerNum = 0; layerNum < this.getNumLayers(); ++layerNum) {
            VelocityLayer currVelocityLayer = this.getVelocityLayer(layerNum);
            if (currVelocityLayer.getTopPVelocity() != pVel) {
                dos.println((float)currVelocityLayer.getTopDepth() + " " + (float)currVelocityLayer.getTopPVelocity());
            }
            dos.println((float)currVelocityLayer.getBotDepth() + " " + (float)currVelocityLayer.getBotPVelocity());
            pVel = currVelocityLayer.getBotPVelocity();
        }
    }

    void printGMTforS(PrintWriter dos) throws IOException {
        double sVel = -1.0;
        for (int layerNum = 0; layerNum < this.getNumLayers(); ++layerNum) {
            VelocityLayer currVelocityLayer = this.getVelocityLayer(layerNum);
            if (currVelocityLayer.getTopSVelocity() != sVel) {
                dos.println((float)currVelocityLayer.getTopDepth() + " " + (float)currVelocityLayer.getTopSVelocity());
            }
            dos.println((float)currVelocityLayer.getBotDepth() + " " + (float)currVelocityLayer.getBotSVelocity());
            sVel = currVelocityLayer.getBotSVelocity();
        }
    }

    public boolean validate() {
        if (this.radiusOfEarth <= 0.0) {
            System.err.println("Radius of earth is not positive. radiusOfEarth = " + this.radiusOfEarth);
            return false;
        }
        if (this.mohoDepth < 0.0) {
            System.err.println("mohoDepth is not non-negative. mohoDepth = " + this.mohoDepth);
            return false;
        }
        if (this.cmbDepth < this.mohoDepth) {
            System.err.println("cmbDepth < mohoDepth. cmbDepth = " + this.cmbDepth + " mohoDepth = " + this.mohoDepth);
            return false;
        }
        if (this.cmbDepth <= 0.0) {
            System.err.println("cmbDepth is not positive. cmbDepth = " + this.cmbDepth);
            return false;
        }
        if (this.iocbDepth < this.cmbDepth) {
            System.err.println("iocbDepth < cmbDepth. iocbDepth = " + this.iocbDepth + " cmbDepth = " + this.cmbDepth);
            return false;
        }
        if (this.iocbDepth <= 0.0) {
            System.err.println("iocbDepth is not positive. iocbDepth = " + this.iocbDepth);
            return false;
        }
        if (this.minRadius < 0.0) {
            System.err.println("minRadius is not non-negative. minRadius = " + this.minRadius);
            return false;
        }
        if (this.maxRadius <= 0.0) {
            System.err.println("maxRadius is not positive. maxRadius = " + this.maxRadius);
            return false;
        }
        if (this.maxRadius <= this.minRadius) {
            System.err.println("maxRadius <= minRadius. maxRadius = " + this.maxRadius + " minRadius = " + this.minRadius);
            return false;
        }
        VelocityLayer currVelocityLayer = this.getVelocityLayer(0);
        VelocityLayer prevVelocityLayer = new VelocityLayer(0, currVelocityLayer.getTopDepth(), currVelocityLayer.getTopDepth(), currVelocityLayer.getTopPVelocity(), currVelocityLayer.getTopPVelocity(), currVelocityLayer.getTopSVelocity(), currVelocityLayer.getTopSVelocity(), currVelocityLayer.getTopDensity(), currVelocityLayer.getTopDensity());
        for (int layerNum = 0; layerNum < this.getNumLayers(); ++layerNum) {
            currVelocityLayer = this.getVelocityLayer(layerNum);
            if (prevVelocityLayer.getBotDepth() != currVelocityLayer.getTopDepth()) {
                System.err.println("There is a gap in the velocity model between layers " + (layerNum - 1) + " and " + layerNum);
                System.err.println("prevVelocityLayer=" + prevVelocityLayer);
                System.err.println("currVelocityLayer=" + currVelocityLayer);
                return false;
            }
            if (currVelocityLayer.getBotDepth() == currVelocityLayer.getTopDepth()) {
                System.err.println("There is a zero thickness layer in the velocity model at layer " + layerNum);
                System.err.println("prevVelocityLayer=" + prevVelocityLayer);
                System.err.println("currVelocityLayer=" + currVelocityLayer);
                return false;
            }
            if (currVelocityLayer.getTopPVelocity() <= 0.0 || currVelocityLayer.getBotPVelocity() <= 0.0) {
                System.err.println("There is a negative P velocity layer in the velocity model at layer " + layerNum);
                return false;
            }
            if (currVelocityLayer.getTopSVelocity() < 0.0 || currVelocityLayer.getBotSVelocity() < 0.0) {
                System.err.println("There is a negative S velocity layer in the velocity model at layer " + layerNum);
                return false;
            }
            if (currVelocityLayer.getTopPVelocity() != 0.0 && currVelocityLayer.getBotPVelocity() == 0.0 || currVelocityLayer.getTopPVelocity() == 0.0 && currVelocityLayer.getBotPVelocity() != 0.0) {
                System.err.println("There is a layer that goes to zero P velocity without a discontinuity in the velocity model at layer " + layerNum + "\nThis would cause a divide by zero within this " + "depth range. Try making the velocity small, followed by a " + "discontinuity to zero velocity.");
                return false;
            }
            if (currVelocityLayer.getTopSVelocity() != 0.0 && currVelocityLayer.getBotSVelocity() == 0.0 || currVelocityLayer.getTopSVelocity() == 0.0 && currVelocityLayer.getBotSVelocity() != 0.0) {
                System.err.println("There is a layer that goes to zero S velocity without a discontinuity in the velocity model at layer " + layerNum + "\nThis would cause a divide by zero within this " + "depth range. Try making the velocity small, followed by a " + "discontinuity to zero velocity.");
                return false;
            }
            prevVelocityLayer = currVelocityLayer;
        }
        return true;
    }

    public String toString() {
        String desc = "modelName=" + this.modelName + "\n" + "\n radiusOfEarth=" + this.radiusOfEarth + "\n mohoDepth=" + this.mohoDepth + "\n cmbDepth=" + this.cmbDepth + "\n iocbDepth=" + this.iocbDepth + "\n minRadius=" + this.minRadius + "\n maxRadius=" + this.maxRadius + "\n spherical=" + this.spherical;
        desc = desc + "\ngetNumLayers()=" + this.getNumLayers() + "\n";
        return desc;
    }

    public void print() {
        for (int i = 0; i < this.getNumLayers(); ++i) {
            System.out.println(this.getVelocityLayer(i));
        }
    }

    public static String getModelNameFromFileName(String filename) {
        String modelFilename;
        int j = filename.lastIndexOf(System.getProperty("file.separator"));
        String modelName = modelFilename = filename.substring(j + 1);
        modelName = modelFilename.endsWith("tvel") ? modelFilename.substring(0, modelFilename.length() - 5) : (modelFilename.endsWith(".nd") ? modelFilename.substring(0, modelFilename.length() - 3) : (modelFilename.startsWith("GB.") ? modelFilename.substring(3, modelFilename.length()) : modelFilename));
        return modelName;
    }

    public static VelocityModel readVelocityFile(String filename, String fileType) throws IOException, VelocityModelException {
        VelocityModel vMod;
        File f;
        if (fileType == null || fileType.equals("")) {
            if (filename.endsWith(".nd")) {
                fileType = ".nd";
            } else if (filename.endsWith(".tvel")) {
                fileType = ".tvel";
            }
        }
        if (fileType.startsWith(".")) {
            fileType = fileType.substring(1, fileType.length());
        }
        if (!(f = new File(filename)).exists() && !filename.endsWith("." + fileType) && new File(filename + "." + fileType).exists()) {
            f = new File(filename + "." + fileType);
        }
        if (fileType.equalsIgnoreCase("nd")) {
            vMod = VelocityModel.readNDFile(f);
        } else if (fileType.equalsIgnoreCase("tvel")) {
            vMod = VelocityModel.readTVelFile(f);
        } else {
            throw new VelocityModelException("What type of velocity file, .tvel or .nd?");
        }
        vMod.fixDisconDepths();
        return vMod;
    }

    public static VelocityModel readTVelFile(File file) throws IOException, VelocityModelException {
        FileReader fileIn = new FileReader(file);
        VelocityModel vmod = VelocityModel.readTVelFile(fileIn, VelocityModel.getModelNameFromFileName(file.getName()));
        fileIn.close();
        return vmod;
    }

    public static VelocityModel readTVelFile(Reader in, String modelName) throws IOException, VelocityModelException {
        double topDensity;
        StreamTokenizer tokenIn = new StreamTokenizer(in);
        tokenIn.commentChar(35);
        tokenIn.slashStarComments(true);
        tokenIn.slashSlashComments(true);
        tokenIn.eolIsSignificant(true);
        tokenIn.parseNumbers();
        while (tokenIn.nextToken() != 10) {
        }
        while (tokenIn.nextToken() != 10) {
        }
        int myLayerNumber = 0;
        tokenIn.nextToken();
        double topDepth = tokenIn.nval;
        tokenIn.nextToken();
        double topPVel = tokenIn.nval;
        tokenIn.nextToken();
        double topSVel = tokenIn.nval;
        if (topSVel > topPVel) {
            throw new VelocityModelException("S velocity, " + topSVel + " at depth " + topDepth + " is greater than the P velocity, " + topPVel);
        }
        tokenIn.nextToken();
        if (tokenIn.ttype != 10) {
            topDensity = tokenIn.nval;
            tokenIn.nextToken();
        } else {
            topDensity = 5571.0;
        }
        if (tokenIn.ttype != 10) {
            throw new VelocityModelException("Should have found an EOL but didn't Layer=" + myLayerNumber + " tokenIn=" + tokenIn);
        }
        tokenIn.nextToken();
        ArrayList<VelocityLayer> layers = new ArrayList<VelocityLayer>();
        while (tokenIn.ttype != -1) {
            double botDensity;
            double botDepth = tokenIn.nval;
            tokenIn.nextToken();
            double botPVel = tokenIn.nval;
            tokenIn.nextToken();
            double botSVel = tokenIn.nval;
            if (botSVel > botPVel) {
                throw new VelocityModelException("S velocity, " + botSVel + " at depth " + botDepth + " is greater than the P velocity, " + botPVel);
            }
            tokenIn.nextToken();
            if (tokenIn.ttype != 10) {
                botDensity = tokenIn.nval;
                tokenIn.nextToken();
            } else {
                botDensity = topDensity;
            }
            VelocityLayer tempLayer = new VelocityLayer(myLayerNumber, topDepth, botDepth, topPVel, botPVel, topSVel, botSVel, topDensity, botDensity);
            topDepth = botDepth;
            topPVel = botPVel;
            topSVel = botSVel;
            topDensity = botDensity;
            if (tokenIn.ttype != 10) {
                throw new VelocityModelException("Should have found an EOL but didn't Layer=" + myLayerNumber + " tokenIn=" + tokenIn);
            }
            tokenIn.nextToken();
            if (tempLayer.getTopDepth() == tempLayer.getBotDepth()) continue;
            layers.add(tempLayer);
            ++myLayerNumber;
        }
        double radiusOfEarth = topDepth;
        double maxRadius = topDepth;
        return new VelocityModel(modelName, radiusOfEarth, 35.0, 2889.0, 5153.9, 0.0, maxRadius, true, layers);
    }

    public static VelocityModel readNDFile(File file) throws IOException, VelocityModelException {
        FileReader fileIn = new FileReader(file);
        VelocityModel vmod = VelocityModel.readNDFile(fileIn, VelocityModel.getModelNameFromFileName(file.getName()));
        fileIn.close();
        return vmod;
    }

    public static VelocityModel readNDFile(Reader in, String modelName) throws IOException, VelocityModelException {
        StreamTokenizer tokenIn = new StreamTokenizer(in);
        tokenIn.commentChar(35);
        tokenIn.slashStarComments(true);
        tokenIn.slashSlashComments(true);
        tokenIn.eolIsSignificant(true);
        tokenIn.parseNumbers();
        int myLayerNumber = 0;
        double topDensity = 2.6;
        double topQp = 1000.0;
        double topQs = 2000.0;
        double botDensity = topDensity;
        double botQp = topQp;
        double botQs = topQs;
        tokenIn.nextToken();
        double topDepth = tokenIn.nval;
        tokenIn.nextToken();
        double topPVel = tokenIn.nval;
        tokenIn.nextToken();
        double topSVel = tokenIn.nval;
        if (topSVel > topPVel) {
            throw new VelocityModelException("S velocity, " + topSVel + " at depth " + topDepth + " is greater than the P velocity, " + topPVel);
        }
        tokenIn.nextToken();
        if (tokenIn.ttype != 10) {
            topDensity = tokenIn.nval;
            tokenIn.nextToken();
            if (tokenIn.ttype != 10) {
                topQp = tokenIn.nval;
                tokenIn.nextToken();
                if (tokenIn.ttype != 10) {
                    topQs = tokenIn.nval;
                    tokenIn.nextToken();
                }
            }
        }
        if (tokenIn.ttype != 10) {
            throw new VelocityModelException("Should have found an EOL but didn't Layer=" + myLayerNumber + " tokenIn=" + tokenIn);
        }
        tokenIn.nextToken();
        double mohoDepth = 35.0;
        double cmbDepth = 2889.0;
        double iocbDepth = 5153.9;
        ArrayList<VelocityLayer> layers = new ArrayList<VelocityLayer>();
        while (tokenIn.ttype != -1) {
            if (tokenIn.ttype == -3) {
                if (tokenIn.sval.equalsIgnoreCase("mantle") || tokenIn.sval.equalsIgnoreCase("moho")) {
                    mohoDepth = topDepth;
                }
                if (tokenIn.sval.equalsIgnoreCase("outer-core") || tokenIn.sval.equalsIgnoreCase("cmb")) {
                    cmbDepth = topDepth;
                }
                if (tokenIn.sval.equalsIgnoreCase("inner-core") || tokenIn.sval.equalsIgnoreCase("icocb")) {
                    iocbDepth = topDepth;
                }
                while (tokenIn.ttype != 10) {
                    tokenIn.nextToken();
                }
                tokenIn.nextToken();
                continue;
            }
            double botDepth = tokenIn.nval;
            tokenIn.nextToken();
            double botPVel = tokenIn.nval;
            tokenIn.nextToken();
            double botSVel = tokenIn.nval;
            if (botSVel > botPVel) {
                throw new VelocityModelException("S velocity, " + botSVel + " at depth " + botDepth + " is greater than the P velocity, " + botPVel);
            }
            tokenIn.nextToken();
            if (tokenIn.ttype != 10) {
                botDensity = tokenIn.nval;
                tokenIn.nextToken();
                if (tokenIn.ttype != 10) {
                    botQp = tokenIn.nval;
                    tokenIn.nextToken();
                    if (tokenIn.ttype != 10) {
                        botQs = tokenIn.nval;
                        tokenIn.nextToken();
                    }
                }
            }
            VelocityLayer tempLayer = new VelocityLayer(myLayerNumber, topDepth, botDepth, topPVel, botPVel, topSVel, botSVel, topDensity, botDensity, topQp, botQp, topQs, botQs);
            topDepth = botDepth;
            topPVel = botPVel;
            topSVel = botSVel;
            topDensity = botDensity;
            topQp = botQp;
            topQs = botQs;
            if (tokenIn.ttype != 10) {
                throw new VelocityModelException("Should have found an EOL but didn't Layer=" + myLayerNumber + " tokenIn=" + tokenIn);
            }
            tokenIn.nextToken();
            if (tempLayer.getTopDepth() == tempLayer.getBotDepth()) continue;
            layers.add(tempLayer);
            ++myLayerNumber;
        }
        double radiusOfEarth = topDepth;
        double maxRadius = topDepth;
        return new VelocityModel(modelName, radiusOfEarth, mohoDepth, cmbDepth, iocbDepth, 0.0, maxRadius, true, layers);
    }

    public boolean fixDisconDepths() {
        boolean changeMade = false;
        double mohoMin = 65.0;
        double cmbMin = this.radiusOfEarth;
        double iocbMin = this.radiusOfEarth - 100.0;
        double tempMohoDepth = 0.0;
        double tempCmbDepth = this.radiusOfEarth;
        double tempIocbDepth = this.radiusOfEarth;
        for (int layerNum = 0; layerNum < this.getNumLayers() - 1; ++layerNum) {
            VelocityLayer aboveLayer = this.getVelocityLayer(layerNum);
            VelocityLayer belowLayer = this.getVelocityLayer(layerNum + 1);
            if (aboveLayer.getBotPVelocity() == belowLayer.getTopPVelocity() && aboveLayer.getBotSVelocity() == belowLayer.getTopSVelocity()) continue;
            if (Math.abs(this.mohoDepth - aboveLayer.getBotDepth()) < mohoMin) {
                tempMohoDepth = aboveLayer.getBotDepth();
                mohoMin = Math.abs(this.mohoDepth - aboveLayer.getBotDepth());
            }
            if (Math.abs(this.cmbDepth - aboveLayer.getBotDepth()) < cmbMin) {
                tempCmbDepth = aboveLayer.getBotDepth();
                cmbMin = Math.abs(this.cmbDepth - aboveLayer.getBotDepth());
            }
            if (aboveLayer.getBotSVelocity() != 0.0 || !(belowLayer.getTopSVelocity() > 0.0) || !(Math.abs(this.iocbDepth - aboveLayer.getBotDepth()) < iocbMin)) continue;
            tempIocbDepth = aboveLayer.getBotDepth();
            iocbMin = Math.abs(this.iocbDepth - aboveLayer.getBotDepth());
        }
        if (this.mohoDepth != tempMohoDepth || this.cmbDepth != tempCmbDepth || this.iocbDepth != tempIocbDepth) {
            changeMade = true;
        }
        this.mohoDepth = tempMohoDepth;
        this.cmbDepth = tempCmbDepth;
        this.iocbDepth = tempCmbDepth != tempIocbDepth ? tempIocbDepth : this.radiusOfEarth;
        return changeMade;
    }

    public VelocityModel earthFlattenTransform() throws VelocityModelException {
        boolean spherical = false;
        ArrayList<VelocityLayer> layers = new ArrayList<VelocityLayer>(vectorLength);
        for (int i = 0; i < this.getNumLayers(); ++i) {
            VelocityLayer oldLayer = this.getVelocityLayer(i);
            VelocityLayer newLayer = new VelocityLayer(i, this.radiusOfEarth * Math.log(oldLayer.getTopDepth() / this.radiusOfEarth), this.radiusOfEarth * Math.log(oldLayer.getBotDepth() / this.radiusOfEarth), this.radiusOfEarth * oldLayer.getTopPVelocity() / oldLayer.getTopDepth(), this.radiusOfEarth * oldLayer.getBotPVelocity() / oldLayer.getBotDepth(), this.radiusOfEarth * oldLayer.getTopSVelocity() / oldLayer.getTopDepth(), this.radiusOfEarth * oldLayer.getBotSVelocity() / oldLayer.getBotDepth());
            layers.add(newLayer);
        }
        return new VelocityModel(this.modelName, this.getRadiusOfEarth(), this.getMohoDepth(), this.getCmbDepth(), this.getIocbDepth(), this.getMinRadius(), this.getMaxRadius(), spherical, layers);
    }
}

