/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Time;
import edu.sc.seis.TauP.Theta;
import edu.sc.seis.seisFile.sac.SacHeader;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.util.List;

public class TauP_WKBJ
extends TauP_Time {
    protected double deltaT = 0.05;
    protected int numSamples = 1000;
    protected double startTime = 0.0;

    public TauP_WKBJ() {
    }

    public TauP_WKBJ(TauModel tMod) throws TauModelException {
        super(tMod);
    }

    public TauP_WKBJ(String modelName) throws TauModelException {
        super(modelName);
    }

    public double getDeltaT() {
        return this.deltaT;
    }

    public void setDeltaT(double v) {
        this.deltaT = v;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNumSamples(int v) {
        this.numSamples = v;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double v) {
        this.startTime = v;
    }

    @Override
    public void calculate(double degrees) throws TauModelException {
        this.calcWKBJ(degrees);
    }

    public void calcWKBJ(double degrees) throws TauModelException {
        this.degrees = degrees;
        this.depthCorrect(this.getSourceDepth(), this.getReceiverDepth());
        this.recalcPhases();
        this.clearArrivals();
        System.out.println("In calcWKBJ for " + degrees + " degrees.");
        List<SeismicPhase> phaseList = this.getSeismicPhases();
        for (int phaseNum = 0; phaseNum < phaseList.size(); ++phaseNum) {
            System.out.println("Phase " + phaseList.get(phaseNum).getName() + ".");
            SeismicPhase phase = phaseList.get(phaseNum);
            List<Arrival> phaseArrivals = phase.calcTime(degrees);
            double minRayParam = phase.getMinRayParam();
            for (Arrival arrival : phaseArrivals) {
                System.out.println("Arrival  " + arrival);
                Theta thetaAtX = new Theta(phase, arrival.getDist());
                System.out.println("Got Theta");
                float[] seismogramPoints = new float[this.numSamples];
                double rayParam = thetaAtX.getMaxRayParam();
                System.out.println("Got ray param");
                double theta = thetaAtX.getTheta(rayParam);
                System.out.println("Got theta for ray param");
                this.setStartTime(320.0);
                double nextRayParam = thetaAtX.getStepRayParam(rayParam, this.getDeltaT());
                double nextTheta = thetaAtX.getTheta(nextRayParam);
                int n = 0;
                try {
                    while (nextRayParam >= minRayParam) {
                        n = (int)Math.round((theta - this.getStartTime()) / this.getDeltaT());
                        if (n >= 0 && n < seismogramPoints.length) {
                            System.out.println(n + "  " + seismogramPoints[n]);
                        }
                        rayParam = nextRayParam;
                        theta = nextTheta;
                        nextRayParam = thetaAtX.getStepRayParam(rayParam, this.getDeltaT());
                        nextTheta = thetaAtX.getTheta(nextRayParam);
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.out.println("ArrayIndexOutOfBoundsException: " + e);
                }
                SacHeader header = SacHeader.createEmptyEvenSampledTimeSeriesHeader();
                SacTimeSeries sac = new SacTimeSeries(header, seismogramPoints);
                header.setDelta((float)this.getDeltaT());
                header.setTHeader(0, (float)arrival.getTime(), arrival.getName());
                header.setO(0.0f);
                header.setB(320.0f);
                header.setE(header.getB() + (float)(header.getNpts() - 1) * header.getDelta());
                try {
                    sac.write("tempsacfile");
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        try {
            long prevTime = 0L;
            prevTime = System.currentTimeMillis();
            TauP_WKBJ tauPTime = new TauP_WKBJ();
            String[] noComprendoArgs = tauPTime.parseCmdLineArgs(args);
            TauP_WKBJ.printNoComprendoArgs(noComprendoArgs);
            long currTime = System.currentTimeMillis();
            prevTime = System.currentTimeMillis();
            tauPTime.init();
            currTime = System.currentTimeMillis();
            if (TauP_Time.DEBUG) {
                System.out.println("taup model read time=" + (currTime - prevTime));
            }
            tauPTime.start();
            tauPTime.destroy();
        }
        catch (TauModelException e) {
            System.out.println("Caught: " + e.getMessage());
            e.printStackTrace();
        }
        catch (TauPException e) {
            System.out.println("Caught: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

