/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.ArrivalTableModel;
import edu.sc.seis.TauP.PathPlot;
import edu.sc.seis.TauP.PhaseDialog;
import edu.sc.seis.TauP.PierceTableModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauP_Path;
import edu.sc.seis.TauP.TauP_Pierce;
import edu.sc.seis.TauP.TauP_Time;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TauP
extends JFrame {
    protected double distance = 0.0;
    protected JTable timeTable;
    protected JTable pierceTable;
    protected ArrivalTableModel arrivalTM;
    PierceTableModel pierceTableModel;
    protected PathPlot pathPlotArea;
    protected boolean quitExits = false;
    private JTabbedPane jTabbedPane1;
    private JPanel jPanel1;
    private JPanel timePanel;
    private JPanel piercePanel;
    private JPanel pathPanel;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JList pierceArrivalList;
    private JLabel jLabel1;
    private JComboBox modelComboBox;
    private JLabel jLabel2;
    private JTextField distanceTextField;
    private JLabel jLabel3;
    private JTextField depthTextField;
    private JButton phaseChooserButton;
    private JButton calculateButton;
    private JButton jButton1;
    private JScrollPane jScrollPane3;
    private JList jList1;
    private TauP_Time timeTool;
    private TauP_Pierce pierceTool;
    private TauP_Path pathTool;
    private PhaseDialog phaseDialog;
    private DefaultListModel pierceModel;

    public TauP() {
        super("The TauP Toolkit");
        this.initComponents();
        this.pack();
        try {
            this.timeTool = new TauP_Time("iasp91");
            this.timeTool.init();
            this.pierceTool = new TauP_Pierce(this.timeTool.getTauModel());
            this.pierceTool.init();
            this.pathTool = new TauP_Path(this.timeTool.getTauModel());
            this.pathTool.init();
            this.phaseDialog = new PhaseDialog((Frame)this, false);
            this.phaseDialog.setPhases(this.timeTool.getPhaseNames());
            this.pathPlotArea = new PathPlot();
            this.pathPlotArea.setPreferredSize(new Dimension(500, 300));
            this.pathPlotArea.setMinimumSize(new Dimension(500, 200));
            this.pathPanel.add((Component)this.pathPlotArea, "Center");
        }
        catch (TauModelException e) {
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println(e);
        }
        this.arrivalTM = new ArrivalTableModel();
        this.timeTable = new JTable(this.arrivalTM);
        JScrollPane timeTableScrollPane = new JScrollPane(this.timeTable);
        timeTableScrollPane.setPreferredSize(new Dimension(500, 300));
        timeTableScrollPane.setMinimumSize(new Dimension(500, 200));
        this.timePanel.add((Component)timeTableScrollPane, "Center");
        this.modelComboBox.addItem("iasp91");
        this.modelComboBox.addItem("prem");
        this.modelComboBox.addItem("ak135");
        this.modelComboBox.addItem("qdt");
        this.setSize(new Dimension(500, 300));
        this.pierceTableModel = new PierceTableModel();
        this.pierceTable = new JTable(this.pierceTableModel);
        this.pierceArrivalList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    TauP.this.pierceListValueChanged(e);
                }
            }
        });
        this.jScrollPane2.setViewportView(this.pierceTable);
        this.pierceModel = new DefaultListModel();
        this.pierceArrivalList.setModel(this.pierceModel);
        this.jList1.setModel(this.pierceModel);
        this.jList1.setSelectionModel(this.pierceArrivalList.getSelectionModel());
        this.validate();
    }

    private void initComponents() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TauP.this.exitForm(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.jTabbedPane1 = new JTabbedPane();
        this.jTabbedPane1.setMinimumSize(new Dimension(200, 200));
        this.timePanel = new JPanel();
        this.timePanel.setToolTipText("travel times");
        this.timePanel.setName("Time");
        this.timePanel.setLayout(new BorderLayout());
        this.jTabbedPane1.addTab("Time", null, this.timePanel, "travel times");
        this.piercePanel = new JPanel();
        this.piercePanel.setToolTipText("pierce points");
        this.piercePanel.setName("Pierce");
        this.piercePanel.setLayout(new BorderLayout());
        this.jScrollPane1 = new JScrollPane();
        this.pierceArrivalList = new JList();
        this.pierceArrivalList.setPreferredSize(new Dimension(60, 60));
        this.pierceArrivalList.setSelectionMode(0);
        this.pierceArrivalList.setMinimumSize(new Dimension(60, 60));
        this.jScrollPane1.add(this.pierceArrivalList);
        this.jScrollPane1.setViewportView(this.pierceArrivalList);
        this.piercePanel.add((Component)this.jScrollPane1, "West");
        this.jScrollPane2 = new JScrollPane();
        this.piercePanel.add((Component)this.jScrollPane2, "Center");
        this.jTabbedPane1.addTab("Pierce", this.piercePanel);
        this.pathPanel = new JPanel();
        this.pathPanel.setToolTipText("path points");
        this.pathPanel.setName("Path Points");
        this.pathPanel.setLayout(new BorderLayout());
        this.jScrollPane3 = new JScrollPane();
        this.jList1 = new JList();
        this.jList1.setPreferredSize(new Dimension(60, 60));
        this.jList1.setMinimumSize(new Dimension(60, 60));
        this.jScrollPane3.setViewportView(this.jList1);
        this.pathPanel.add((Component)this.jScrollPane3, "West");
        this.jTabbedPane1.addTab("Path", this.pathPanel);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.jPanel1 = new JPanel();
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1 = new JLabel();
        this.jLabel1.setText("Model");
        this.jLabel1.setName("modelLabel");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = 2;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints1);
        this.modelComboBox = new JComboBox();
        this.modelComboBox.setToolTipText("choose a model");
        this.modelComboBox.setActionCommand("modelChanged");
        this.modelComboBox.setName("modelMenu");
        this.modelComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TauP.this.chooseModelActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = 2;
        this.jPanel1.add((Component)this.modelComboBox, gridBagConstraints1);
        this.jLabel2 = new JLabel();
        this.jLabel2.setText("Distance (deg)");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints1.anchor = 13;
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints1);
        this.distanceTextField = new JTextField();
        this.distanceTextField.setToolTipText("distance in degrees");
        this.distanceTextField.setPreferredSize(new Dimension(100, 21));
        this.distanceTextField.setMinimumSize(new Dimension(100, 21));
        this.distanceTextField.setText("50.0");
        this.distanceTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TauP.this.distanceActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = 2;
        this.jPanel1.add((Component)this.distanceTextField, gridBagConstraints1);
        this.jLabel3 = new JLabel();
        this.jLabel3.setText("Depth");
        this.jLabel3.setHorizontalAlignment(4);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints1.anchor = 13;
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints1);
        this.depthTextField = new JTextField();
        this.depthTextField.setToolTipText("source depth in km");
        this.depthTextField.setPreferredSize(new Dimension(100, 21));
        this.depthTextField.setMinimumSize(new Dimension(100, 21));
        this.depthTextField.setText("0.0");
        this.depthTextField.setName("depthTextField");
        this.depthTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TauP.this.depthActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 2;
        this.jPanel1.add((Component)this.depthTextField, gridBagConstraints1);
        this.phaseChooserButton = new JButton();
        this.phaseChooserButton.setToolTipText("show phase chooser");
        this.phaseChooserButton.setText("Phases");
        this.phaseChooserButton.setActionCommand("showPhases");
        this.phaseChooserButton.setLabel("Phases");
        this.phaseChooserButton.setName("phaseButton");
        this.phaseChooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TauP.this.phaseChooserActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 2;
        this.jPanel1.add((Component)this.phaseChooserButton, gridBagConstraints1);
        this.calculateButton = new JButton();
        this.calculateButton.setToolTipText("calculate times");
        this.calculateButton.setText("Calculate");
        this.calculateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TauP.this.calculateActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 4;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 20, 0, 0);
        this.jPanel1.add((Component)this.calculateButton, gridBagConstraints1);
        this.jButton1 = new JButton();
        this.jButton1.setText("Quit");
        this.jButton1.setActionCommand("quit");
        this.jButton1.setLabel("Quit");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TauP.this.quitActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 4;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 20, 0, 0);
        this.jPanel1.add((Component)this.jButton1, gridBagConstraints1);
        this.getContentPane().add((Component)this.jPanel1, "South");
    }

    public boolean getQuitExits() {
        return this.quitExits;
    }

    public void setQuitExits(boolean v) {
        this.quitExits = v;
    }

    private void phaseChooserActionPerformed(ActionEvent evt) {
        this.phaseDialog.setVisible(true);
    }

    private void quitActionPerformed(ActionEvent evt) {
        if (this.getQuitExits()) {
            System.exit(0);
        } else {
            this.dispose();
        }
    }

    private void calculateActionPerformed(ActionEvent evt) {
        try {
            this.timeTool.setSourceDepth(Double.valueOf(this.depthTextField.getText()));
            this.timeTool.clearPhaseNames();
            this.timeTool.setPhaseNames(this.phaseDialog.getPhases());
            this.setDistance(Double.valueOf(this.distanceTextField.getText()));
            this.timeTool.calculate(this.distance);
            this.pierceTool.setSourceDepth(Double.valueOf(this.depthTextField.getText()));
            this.pierceTool.clearPhaseNames();
            this.pierceTool.setPhaseNames(this.phaseDialog.getPhases());
            this.pierceTool.calculate(this.distance);
            this.pathTool.setSourceDepth(Double.valueOf(this.depthTextField.getText()));
            this.pathTool.clearPhaseNames();
            this.pathTool.setPhaseNames(this.phaseDialog.getPhases());
            this.pathTool.calculate(this.distance);
            this.showResults();
        }
        catch (Exception e) {
            System.out.println("exception in calculate " + e);
            e.printStackTrace();
        }
    }

    private void distanceActionPerformed(ActionEvent evt) {
        this.setDistance(Double.valueOf(evt.getActionCommand()));
        this.calculateActionPerformed(evt);
    }

    private void depthActionPerformed(ActionEvent evt) {
        this.setDepth(Double.valueOf(evt.getActionCommand()));
        this.calculateActionPerformed(evt);
    }

    private void chooseModelActionPerformed(ActionEvent evt) {
        this.setModel((String)this.modelComboBox.getSelectedItem());
    }

    private void pierceListValueChanged(ListSelectionEvent e) {
        this.pierceTableModel.setSelectedIndex(this.pierceArrivalList.getSelectedIndex());
        this.pathPlotArea.setSelectedIndex(this.pierceArrivalList.getSelectedIndex());
    }

    private void exitForm(WindowEvent evt) {
        if (this.getQuitExits()) {
            System.exit(0);
        } else {
            this.dispose();
        }
    }

    protected void setModel(String modelName) {
        try {
            this.timeTool.loadTauModel(modelName);
            this.pierceTool.setTauModel(this.timeTool.getTauModel());
            this.pathTool.setTauModel(this.timeTool.getTauModel());
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    protected void setDepth(double depth) {
        this.timeTool.setSourceDepth(depth);
    }

    protected void setDistance(double distance) {
        this.distance = distance;
    }

    protected void showResults() {
        int i;
        this.arrivalTM.setArrivals(this.timeTool.getArrivals());
        this.pierceTableModel.setArrivals(this.pierceTool.getArrivals());
        this.pierceModel.removeAllElements();
        for (i = 0; i < this.pierceTool.getNumArrivals(); ++i) {
            this.pierceModel.addElement(this.pierceTool.getArrival(i).getName());
        }
        this.pierceArrivalList.setSelectedIndex(0);
        this.pathPlotArea.setTauModel(this.pathTool.getTauModel());
        this.pathPlotArea.removeAllElements();
        for (i = 0; i < this.pathTool.getNumArrivals(); ++i) {
            this.pathPlotArea.addElement(this.pathTool.getArrival(i));
        }
        this.pathPlotArea.repaint();
    }

    public static void main(String[] args) {
        TauP t = new TauP();
        t.setQuitExits(true);
        t.show();
    }
}

