/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Format;
import java.util.Properties;

public class Outputs {
    protected static Format depthFormat = new Format("%8.1f");
    protected static Format distanceFormat = new Format("%8.2f");
    protected static Format timeFormat = new Format("%8.2f");
    protected static Format rayParamFormat = new Format("%8.3f");
    protected static Format latLonFormat = new Format("%8.2f");

    public static void configure(Properties props) {
        String formString = "%8." + props.getProperty("taup.depth.precision", "1") + "f";
        depthFormat = new Format(formString);
        formString = "%8." + props.getProperty("taup.distance.precision", "2") + "f";
        distanceFormat = new Format(formString);
        formString = "%8." + props.getProperty("taup.time.precision", "2") + "f";
        timeFormat = new Format(formString);
        formString = "%8." + props.getProperty("taup.rayparam.precision", "3") + "f";
        rayParamFormat = new Format(formString);
        formString = "%8." + props.getProperty("taup.latlon.precision", "2") + "f";
        latLonFormat = new Format(formString);
    }

    public static String formatDepth(double depth) {
        return depthFormat.form(depth);
    }

    public static String formatDistance(double distance) {
        return distanceFormat.form(distance);
    }

    public static String formatTime(double time) {
        return timeFormat.form(time);
    }

    public static String formatRayParam(double rayParam) {
        return rayParamFormat.form(rayParam);
    }

    public static String formatLatLon(double latlon) {
        return latLonFormat.form(latlon);
    }
}

