/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.velocity;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.mockFissures.IfEvent.MockEventAccessOperations;
import edu.sc.seis.fissuresUtil.mockFissures.IfNetwork.MockChannel;
import edu.sc.seis.fissuresUtil.mockFissures.IfNetwork.MockStation;
import edu.sc.seis.fissuresUtil.mockFissures.IfSeismogramDC.MockSeismogram;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.UserConfigurationException;
import edu.sc.seis.sod.status.FissuresFormatter;
import edu.sc.seis.sod.velocity.ContextWrangler;
import edu.sc.seis.sod.velocity.SimpleVelocitizer;
import edu.sc.seis.sod.velocity.event.VelocityEvent;
import edu.sc.seis.sod.velocity.network.VelocityChannel;
import edu.sc.seis.sod.velocity.network.VelocityNetwork;
import edu.sc.seis.sod.velocity.network.VelocityStation;
import edu.sc.seis.sod.velocity.seismogram.VelocitySeismogram;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintlineVelocitizer {
    static VelocityContext mockContext = new VelocityContext();
    private SimpleVelocitizer simple = new SimpleVelocitizer();
    private static final Logger logger;

    public PrintlineVelocitizer(String[] strings) throws ConfigurationException {
        if (System.getProperty("printlinevelocitizer.check") == null || !System.getProperty("printlinevelocitizer.check").equalsIgnoreCase("false")) {
            for (int i = 0; i < strings.length; ++i) {
                try {
                    StringWriter stringWriter = new StringWriter();
                    Velocity.evaluate((Context)mockContext, (Writer)stringWriter, (String)"PrintlineTest", (String)strings[i]);
                    logger.debug("PrintlineVelocitizer: " + strings[i] + " Result: " + stringWriter.toString());
                    continue;
                }
                catch (ParseErrorException e) {
                    throw new UserConfigurationException("Malformed Velocity '" + strings[i] + "'.  " + e.getMessage());
                }
                catch (Exception e) {
                    throw new ConfigurationException("Exception caused by testing Velocity", e);
                }
            }
        }
    }

    public String evaluate(String fileTemplate, String template, NetworkAttr attr) throws IOException {
        return this.evalulate(fileTemplate, template, ContextWrangler.createContext(attr));
    }

    public String evaluate(String fileTemplate, String template, Channel chan) throws IOException {
        return this.evalulate(fileTemplate, template, ContextWrangler.createContext(chan));
    }

    public String evaluate(String fileTemplate, String template, StationImpl sta) throws IOException {
        return this.evalulate(fileTemplate, template, ContextWrangler.createContext(sta));
    }

    public String evaluate(String fileTemplate, String template, EventAccessOperations event, StationImpl sta, CookieJar cookieJar) throws IOException {
        VelocityContext cntxt = ContextWrangler.createContext(sta);
        ContextWrangler.insertIntoContext(event, cntxt);
        cntxt.put("cookieJar", (Object)cookieJar);
        return this.evalulate(fileTemplate, template, cntxt);
    }

    public String evaluate(String filename, String template, EventAccessOperations event, ChannelImpl channel, RequestFilter[] request, CookieJar cookieJar) throws IOException {
        return this.evaluate(filename, template, event, channel, request, new RequestFilter[0], cookieJar);
    }

    public String evaluate(String filename, String template, EventAccessOperations event, ChannelImpl channel, RequestFilter[] original, RequestFilter[] available, CookieJar cookieJar) throws IOException {
        return this.evaluate(filename, template, event, channel, original, available, new LocalSeismogramImpl[0], cookieJar);
    }

    public String evaluate(String fileTemplate, String template, EventAccessOperations event, ChannelImpl channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, CookieJar cookieJar) throws IOException {
        return this.evalulate(fileTemplate, template, ContextWrangler.createContext(event, channel, original, available, seismograms, cookieJar));
    }

    public String evaluate(String fileTemplate, String template, EventAccessOperations event) throws IOException {
        return this.evalulate(fileTemplate, template, ContextWrangler.createContext(event));
    }

    public String evalulate(String fileTemplate, String template, VelocityContext ctx) throws IOException {
        String result = this.simple.evaluate(template, ctx);
        if (fileTemplate.equals("")) {
            System.out.println(result);
        } else {
            this.appendToFile(fileTemplate, result, ctx);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendToFile(String fileTemplate, String toAppend, VelocityContext ctx) throws IOException {
        String filename = FissuresFormatter.filize(this.simple.evaluate(fileTemplate, ctx));
        File file = new File(filename);
        file.getAbsoluteFile().getParentFile().mkdirs();
        FileWriter fwriter = new FileWriter(file, true);
        try (BufferedWriter bwriter = null;){
            bwriter = new BufferedWriter(fwriter);
            bwriter.write(toAppend);
            bwriter.newLine();
        }
    }

    static {
        VelocityEvent event = new VelocityEvent(MockEventAccessOperations.createEvent());
        ChannelImpl chan = MockChannel.createChannel();
        mockContext.put("event", (Object)event);
        mockContext.put("channel", (Object)new VelocityChannel(chan));
        mockContext.put("station", (Object)new VelocityStation(MockStation.createStation()));
        mockContext.put("net", (Object)new VelocityNetwork((NetworkAttrImpl)MockChannel.createChannel().getNetworkAttr()));
        ArrayList<VelocitySeismogram> seisList = new ArrayList<VelocitySeismogram>();
        seisList.add(new VelocitySeismogram(MockSeismogram.createSpike((ChannelId)chan.getId()), (Channel)chan));
        mockContext.put("seismograms", seisList);
        mockContext.put("index", (Object)new Integer(1));
        logger = LoggerFactory.getLogger(PrintlineVelocitizer.class);
    }
}

